/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.security.symmetric;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;
import me.wuwenbin.security.SecurityUtils;
import me.wuwenbin.security.exception.CryptoException;
import me.wuwenbin.security.symmetric.SymmetricAlgorithm;
import me.wuwenbin.security.zsupport.FastByteArrayOutputStream;

public class SymmetricCriptor {
    private SecretKey secretKey;
    private Cipher cipher;
    private AlgorithmParameterSpec params;
    private Lock lock = new ReentrantLock();

    public SymmetricCriptor(SymmetricAlgorithm algorithm) {
        this(algorithm, null);
    }

    public SymmetricCriptor(String algorithm) {
        this(algorithm, null);
    }

    public SymmetricCriptor(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCriptor(String algorithm, byte[] key) {
        this.init(algorithm, key);
    }

    public SymmetricCriptor init(String algorithm, byte[] key) {
        this.secretKey = SecurityUtils.generateKey(algorithm, key);
        if (algorithm.startsWith("PBE")) {
            Random random = new Random();
            byte[] bytes = new byte[8];
            random.nextBytes(bytes);
            this.params = new PBEParameterSpec(bytes, 100);
        }
        try {
            this.cipher = Cipher.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(1, this.secretKey);
            } else {
                this.cipher.init(1, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.cipher.doFinal(data);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] encrypt(String data, String charset) {
        if (data == null) {
            return null;
        }
        return this.encrypt(charset == null || charset.length() == 0 ? data.getBytes() : data.getBytes(Charset.forName(charset)));
    }

    public byte[] encrypt(String data) {
        if (data == null) {
            return null;
        }
        return this.encrypt(data.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] encrypt(InputStream data) {
        try {
            return this.encrypt(SymmetricCriptor.readBytes(data));
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] decrypt(byte[] bytes) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.cipher.init(2, this.secretKey);
            } else {
                this.cipher.init(2, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.cipher.doFinal(bytes);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public byte[] decrypt(InputStream data) {
        try {
            return this.decrypt(SymmetricCriptor.readBytes(data));
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getCipher() {
        return this.cipher;
    }

    private static byte[] readBytes(InputStream data) throws IOException {
        int readSize;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        if (null == data) {
            throw new NullPointerException("InputStream is null!");
        }
        if (null == out) {
            throw new NullPointerException("OutputStream is null!");
        }
        byte[] buffer = new byte[1024];
        while ((readSize = data.read(buffer)) != -1) {
            out.write(buffer, 0, readSize);
            out.flush();
        }
        return out.toByteArray();
    }
}

