/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.security.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import me.wuwenbin.security.HexUtils;
import me.wuwenbin.security.SecurityUtils;
import me.wuwenbin.security.digest.HmacAlgorithm;
import me.wuwenbin.security.exception.CryptoException;

public class HMac {
    private Mac mac;
    private SecretKey secretKey;

    public HMac(HmacAlgorithm algorithm) {
        this(algorithm, null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key) {
        this.init(algorithm.getValue(), key);
    }

    public HMac init(String algorithm, byte[] key) {
        try {
            this.mac = Mac.getInstance(algorithm);
            this.secretKey = null != key ? new SecretKeySpec(key, algorithm) : SecurityUtils.generateKey(algorithm);
            this.mac.init(this.secretKey);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(data == null ? null : data.getBytes(charset == null || charset.trim().length() == 0 ? Charset.defaultCharset() : Charset.forName(charset)));
    }

    public byte[] digest(String data) {
        return this.digest(data, StandardCharsets.UTF_8.name());
    }

    public String digestHex(String data, String charset) {
        return HexUtils.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, StandardCharsets.UTF_8.name());
    }

    public byte[] digest(File file) {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = this.digest(in);
            return byArray;
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String digestHex(File file) {
        return HexUtils.encodeHexStr(this.digest(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(byte[] data) {
        byte[] result;
        try {
            result = this.mac.doFinal(data);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexUtils.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexUtils.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.mac.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            this.mac.doFinal();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtils.encodeHexStr(this.digest(data, bufferLength));
    }

    public Mac getMac() {
        return this.mac;
    }
}

