/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.security.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import me.wuwenbin.security.HexUtils;
import me.wuwenbin.security.digest.DigestAlgorithm;
import me.wuwenbin.security.exception.CryptoException;

public class Digester {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private MessageDigest digest;

    public Digester(DigestAlgorithm algorithm) {
        this.init(algorithm.getValue());
    }

    public Digester init(String algorithm) {
        try {
            this.digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] digest(String data, String charset) {
        if (data == null) {
            return null;
        }
        return this.digest(charset == null ? data.getBytes() : data.getBytes(Charset.forName(charset)));
    }

    public byte[] digest(String data) {
        return this.digest(data, StandardCharsets.UTF_8.displayName());
    }

    public String digestHex(String data, String charset) {
        return HexUtils.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, Charset.defaultCharset().displayName());
    }

    public byte[] digest(File file) {
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            byte[] byArray = this.digest(in);
            return byArray;
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public String digestHex(File file) {
        return HexUtils.encodeHexStr(this.digest(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(byte[] data) {
        byte[] result;
        try {
            result = this.digest.digest(data);
        }
        finally {
            this.digest.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexUtils.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexUtils.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.digest.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            this.digest.digest();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.digest.reset();
        }
        return result;
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtils.encodeHexStr(this.digest(data, bufferLength));
    }

    public MessageDigest getDigest() {
        return this.digest;
    }
}

