/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.security.asymmetric;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.interfaces.RSAKey;
import me.wuwenbin.security.asymmetric.AsymmetricAlgorithm;
import me.wuwenbin.security.asymmetric.AsymmetricCriptor;
import me.wuwenbin.security.asymmetric.KeyType;
import me.wuwenbin.security.bcd.BCD;
import me.wuwenbin.security.exception.CryptoException;

public class RSA
extends AsymmetricCriptor {
    private static final AsymmetricAlgorithm ALGORITHM_RSA = AsymmetricAlgorithm.RSA;

    public RSA() {
        super(ALGORITHM_RSA);
    }

    public RSA(byte[] privateKey, byte[] publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public String encryptStr(String data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        int keyLength = ((RSAKey)((Object)key)).getModulus().bitLength() / 8;
        StringBuilder sb = new StringBuilder();
        this.lock.lock();
        try {
            String[] dataArray;
            this.clipher.init(1, key);
            for (String s : dataArray = RSA.split(data, keyLength - 11)) {
                sb.append(BCD.bcdToStr(this.clipher.doFinal(s.getBytes())));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    public String decryptStr(String data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        int keyLength = ((RSAKey)((Object)key)).getModulus().bitLength() / 8;
        StringBuilder sb = new StringBuilder();
        this.lock.lock();
        try {
            byte[][] arrays;
            this.clipher.init(2, key);
            byte[] bcd = BCD.ascToBcd(data == null ? null : data.getBytes(StandardCharsets.UTF_8));
            for (byte[] arr : arrays = RSA.split(bcd, keyLength)) {
                byte[] cipherBytes = this.clipher.doFinal(arr);
                sb.append(new String(cipherBytes, StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    private static String[] split(String str, int len) {
        int partCount = str.length() / len;
        int lastPartCount = str.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str.substring(i * len, i * len + lastPartCount) : str.substring(i * len, i * len + len);
        }
        return strs;
    }

    private static byte[][] split(byte[] array, int len) {
        int x = array.length / len;
        int y = array.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(array, i * len, arr, 0, y);
            } else {
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }
}

