/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.security;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import me.wuwenbin.security.asymmetric.AsymmetricAlgorithm;
import me.wuwenbin.security.digest.DigestAlgorithm;
import me.wuwenbin.security.digest.Digester;
import me.wuwenbin.security.digest.HMac;
import me.wuwenbin.security.digest.HmacAlgorithm;
import me.wuwenbin.security.exception.CryptoException;
import me.wuwenbin.security.symmetric.SymmetricAlgorithm;
import me.wuwenbin.security.symmetric.SymmetricCriptor;

public class SecurityUtils {
    public static final int DEFAULT_KEY_SIZE = 1024;

    public static SecretKey generateKey(String algorithm) {
        SecretKey secretKey;
        try {
            secretKey = KeyGenerator.getInstance(algorithm).generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return secretKey;
    }

    public static SecretKey generateKey(String algorithm, byte[] key) {
        if (algorithm == null || algorithm.length() == 0 || algorithm.trim().length() == 0) {
            throw new IllegalArgumentException("Algorithm is blank!");
        }
        SecretKey secretKey = algorithm.startsWith("PBE") ? SecurityUtils.generatePBEKey(algorithm, null == key ? null : new String(key, StandardCharsets.UTF_8).toCharArray()) : (algorithm.startsWith("DES") ? SecurityUtils.generateDESKey(algorithm, key) : (null == key ? SecurityUtils.generateKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey generateDESKey(String algorithm, byte[] key) {
        SecretKey secretKey;
        if (algorithm == null || algorithm.length() == 0 || algorithm.trim().length() == 0 || !algorithm.startsWith("DES")) {
            throw new CryptoException("Algorithm is not a DES algorithm!");
        }
        if (null == key) {
            secretKey = SecurityUtils.generateKey(algorithm);
        } else {
            DESKeySpec keySpec;
            try {
                keySpec = new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            secretKey = SecurityUtils.generateKey(algorithm, keySpec);
        }
        return secretKey;
    }

    public static SecretKey generatePBEKey(String algorithm, char[] key) {
        if (algorithm == null || algorithm.length() == 0 || algorithm.trim().length() == 0 || !algorithm.startsWith("PBE")) {
            throw new CryptoException("Algorithm is not a PBE algorithm!");
        }
        if (null == key) {
            key = SecurityUtils.randomString("0123456789abcdefghijklmnopqrstuvwxyz", 32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return SecurityUtils.generateKey(algorithm, keySpec);
    }

    public static SecretKey generateKey(String algorithm, KeySpec keySpec) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            return keyFactory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        try {
            return KeyFactory.getInstance(algorithm).generatePrivate(pkcs8KeySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey generatePrivateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        try {
            return KeyFactory.getInstance(algorithm).generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static KeyPair generateKeyPair(String algorithm) {
        return SecurityUtils.generateKeyPair(algorithm, 1024, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize) {
        return SecurityUtils.generateKeyPair(algorithm, keySize, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int keySize, byte[] seed) {
        KeyPairGenerator keyPairGen;
        try {
            keyPairGen = KeyPairGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        if (keySize <= 0) {
            keySize = 1024;
        }
        if (null != seed) {
            SecureRandom random = new SecureRandom(seed);
            keyPairGen.initialize(keySize, random);
        } else {
            keyPairGen.initialize(keySize);
        }
        return keyPairGen.generateKeyPair();
    }

    public static Signature generateSignature(AsymmetricAlgorithm asymmetricAlgorithm, DigestAlgorithm digestAlgorithm) {
        String digestPart = null == digestAlgorithm ? "NONE" : digestAlgorithm.name();
        String algorithm = digestPart + "with" + asymmetricAlgorithm.getValue();
        try {
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static KeyStore readJKSKeyStore(InputStream in, char[] password) {
        return SecurityUtils.readKeyStore("JKS", in, password);
    }

    public static KeyStore readKeyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return keyStore;
    }

    public static Certificate readX509Certificate(InputStream in, char[] password) {
        return SecurityUtils.readCertificate("X.509", in, password);
    }

    public static Certificate readCertificate(String type, InputStream in, char[] password) {
        Certificate certificate;
        try {
            certificate = CertificateFactory.getInstance(type).generateCertificate(in);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return certificate;
    }

    public static Certificate getCertificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static SymmetricCriptor aes() {
        return new SymmetricCriptor(SymmetricAlgorithm.AES);
    }

    public static SymmetricCriptor aes(byte[] key) {
        return new SymmetricCriptor(SymmetricAlgorithm.AES, key);
    }

    public static SymmetricCriptor des() {
        return new SymmetricCriptor(SymmetricAlgorithm.DES);
    }

    public static SymmetricCriptor des(byte[] key) {
        return new SymmetricCriptor(SymmetricAlgorithm.DES, key);
    }

    public static Digester md5() {
        return new Digester(DigestAlgorithm.MD5);
    }

    public static String md5(String data) {
        return new Digester(DigestAlgorithm.MD5).digestHex(data);
    }

    public static String md5(InputStream data) {
        return new Digester(DigestAlgorithm.MD5).digestHex(data);
    }

    public static String md5(File dataFile) {
        return new Digester(DigestAlgorithm.MD5).digestHex(dataFile);
    }

    public static Digester sha1() {
        return new Digester(DigestAlgorithm.SHA1);
    }

    public static String sha1(String data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1(InputStream data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1(File dataFile) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(dataFile);
    }

    public static HMac hmacMd5(byte[] key) {
        return new HMac(HmacAlgorithm.HmacMD5, key);
    }

    public static HMac hmacMd5() {
        return new HMac(HmacAlgorithm.HmacMD5);
    }

    public static HMac hmacSha1(byte[] key) {
        return new HMac(HmacAlgorithm.HmacSHA1, key);
    }

    public static HMac hmacSha1() {
        return new HMac(HmacAlgorithm.HmacSHA1);
    }

    private static String randomString(String baseString, int length) {
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }
}

