/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.security;

import java.nio.charset.Charset;

public class HexUtils {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    public static char[] encodeHex(byte[] data) {
        return HexUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        return HexUtils.encodeHex(charset == null ? str.getBytes() : str.getBytes(charset), true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtils.encodeHexStr(data, true);
    }

    public static String encodeHexStr(String data, Charset charset) {
        if (data == null) {
            return null;
        }
        return HexUtils.encodeHexStr(charset == null ? data.getBytes() : data.getBytes(charset), true);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexUtils.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    public static String decodeHexStr(String hexStr, Charset charset) {
        if (hexStr == null || hexStr.length() == 0) {
            return hexStr;
        }
        return HexUtils.decodeHexStr(hexStr.toCharArray(), charset);
    }

    public static String decodeHexStr(char[] hexData, Charset charset) {
        if (hexData == null) {
            return null;
        }
        byte[] hexBytes = HexUtils.decodeHex(hexData);
        return hexBytes == null ? null : (charset == null ? new String(hexBytes) : new String(hexBytes, charset));
    }

    public static byte[] decodeHex(char[] hexData) {
        int len = hexData.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtils.toDigit(hexData[j], j) << 4;
            f |= HexUtils.toDigit(hexData[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    private static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexUtils.encodeHex(data, toDigits));
    }

    private static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

