/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.security;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import me.wuwenbin.security.digest.DigestAlgorithm;
import me.wuwenbin.security.digest.Digester;

public class DigestUtils {
    public static byte[] md5(byte[] data) {
        return new Digester(DigestAlgorithm.MD5).digest(data);
    }

    public static byte[] md5(String data, String charset) {
        return new Digester(DigestAlgorithm.MD5).digest(data, charset);
    }

    public static byte[] md5(String data) {
        return DigestUtils.md5(data, StandardCharsets.UTF_8.name());
    }

    public static byte[] md5(InputStream data) {
        return new Digester(DigestAlgorithm.MD5).digest(data);
    }

    public static byte[] md5(File file) {
        return new Digester(DigestAlgorithm.MD5).digest(file);
    }

    public static String md5Hex(byte[] data) {
        return new Digester(DigestAlgorithm.MD5).digestHex(data);
    }

    public static String md5Hex(String data, String charset) {
        return new Digester(DigestAlgorithm.MD5).digestHex(data, charset);
    }

    public static String md5Hex(String data) {
        return DigestUtils.md5Hex(data, StandardCharsets.UTF_8.name());
    }

    public static String md5Hex(InputStream data) {
        return new Digester(DigestAlgorithm.MD5).digestHex(data);
    }

    public static String md5Hex(File file) {
        return new Digester(DigestAlgorithm.MD5).digestHex(file);
    }

    public static byte[] sha1(byte[] data) {
        return new Digester(DigestAlgorithm.SHA1).digest(data);
    }

    public static byte[] sha1(String data, String charset) {
        return new Digester(DigestAlgorithm.SHA1).digest(data, charset);
    }

    public static byte[] sha1(String data) {
        return DigestUtils.sha1(data, StandardCharsets.UTF_8.name());
    }

    public static byte[] sha1(InputStream data) {
        return new Digester(DigestAlgorithm.SHA1).digest(data);
    }

    public static byte[] sha1(File file) {
        return new Digester(DigestAlgorithm.SHA1).digest(file);
    }

    public static String sha1Hex(byte[] data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1Hex(String data, String charset) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data, charset);
    }

    public static String sha1Hex(String data) {
        return DigestUtils.sha1Hex(data, StandardCharsets.UTF_8.name());
    }

    public static String sha1Hex(InputStream data) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(data);
    }

    public static String sha1Hex(File file) {
        return new Digester(DigestAlgorithm.SHA1).digestHex(file);
    }
}

