/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.web;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.springframework.util.Assert;

public class WebDate {
    public final String PATTERN_STANDARD = "yyyy-MM-dd HH:mm:ss";
    public final String PATTERN_DATE = "yyyy-MM-dd";

    public String timestamp2String(Timestamp timestamp, String pattern) {
        if (timestamp == null) {
            throw new IllegalArgumentException("timestamp null illegal");
        }
        if (pattern == null || pattern.equals("")) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(new Date(timestamp.getTime()));
    }

    public String date2String(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("timestamp null illegal");
        }
        if (pattern == null || pattern.equals("")) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(date);
    }

    public Timestamp currentTimestamp() {
        return new Timestamp(new Date().getTime());
    }

    public String currentTimestamp2String(String pattern) {
        return this.timestamp2String(this.currentTimestamp(), pattern);
    }

    public Timestamp string2Timestamp(String strDateTime, String pattern) {
        if (strDateTime == null || strDateTime.equals("")) {
            throw new IllegalArgumentException("Date Time Null Illegal");
        }
        if (pattern == null || pattern.equals("")) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = sdf.parse(strDateTime);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return new Timestamp(date.getTime());
    }

    public Date string2Date(String strDate, String pattern) {
        if (strDate == null || strDate.equals("")) {
            throw new RuntimeException("str date null");
        }
        if (pattern == null || pattern.equals("")) {
            pattern = "yyyy-MM-dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Date date = null;
        try {
            date = sdf.parse(strDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public String stringToYear(String strDest) {
        if (strDest == null || strDest.equals("")) {
            throw new IllegalArgumentException("str dest null");
        }
        Date date = this.string2Date(strDest, "yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return String.valueOf(c.get(1));
    }

    public String stringToMonth(String strDest) {
        if (strDest == null || strDest.equals("")) {
            throw new IllegalArgumentException("str dest null");
        }
        Date date = this.string2Date(strDest, "yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        if (++month < 10) {
            return "0" + month;
        }
        return String.valueOf(month);
    }

    public String stringToDay(String strDest) {
        if (strDest == null || strDest.equals("")) {
            throw new IllegalArgumentException("str dest null");
        }
        Date date = this.string2Date(strDest, "yyyy-MM-dd");
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        if (day < 10) {
            return "0" + day;
        }
        return "" + day;
    }

    public Date getFirstDayOfMonth(Calendar c) {
        int year = c.get(1);
        int month = c.get(2);
        int day = 1;
        c.set(year, month, day, 0, 0, 0);
        return c.getTime();
    }

    public Date getLastDayOfMonth(Calendar c) {
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = 1;
        if (month > 11) {
            month = 0;
            ++year;
        }
        c.set(year, month, day - 1, 0, 0, 0);
        return c.getTime();
    }

    public String date2GregorianCalendarString(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Date is null");
        }
        long tmp = date.getTime();
        GregorianCalendar ca = new GregorianCalendar();
        ca.setTimeInMillis(tmp);
        try {
            XMLGregorianCalendar t_XMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(ca);
            return t_XMLGregorianCalendar.normalize().toString();
        }
        catch (DatatypeConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Date is null");
        }
    }

    public boolean compareDate(Date firstDate, Date secondDate) {
        String strSecondDate;
        if (firstDate == null || secondDate == null) {
            throw new RuntimeException();
        }
        String strFirstDate = this.date2String(firstDate, "yyyy-MM-dd");
        return strFirstDate.equals(strSecondDate = this.date2String(secondDate, "yyyy-MM-dd"));
    }

    public Date getStartTimeOfDate(Date currentDate) {
        Assert.notNull((Object)currentDate);
        String strDateTime = this.date2String(currentDate, "yyyy-MM-dd") + " 00:00:00";
        return this.string2Date(strDateTime, "yyyy-MM-dd hh:mm:ss");
    }

    public Date getEndTimeOfDate(Date currentDate) {
        Assert.notNull((Object)currentDate);
        String strDateTime = this.date2String(currentDate, "yyyy-MM-dd") + " 59:59:59";
        return this.string2Date(strDateTime, "yyyy-MM-dd hh:mm:ss");
    }
}

