/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.support.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExpressionUtils {
    private static final String __pre = "\\$\\{";
    private static final String __suf = "\\}";
    private String __result;

    public static ExpressionUtils bind(String expressionStr) {
        return new ExpressionUtils(expressionStr);
    }

    private ExpressionUtils(String expressionStr) {
        this.__result = expressionStr;
    }

    public String getResult() {
        return this.__result;
    }

    public ExpressionUtils set(String key, String value) {
        String namePattern = __pre + key + __suf;
        this.__result = this.__result.replaceAll(namePattern, Matcher.quoteReplacement(value));
        return this;
    }

    public List<String> getVariables() {
        ArrayList<String> _vars = new ArrayList<String>();
        Matcher _match = Pattern.compile("(?<=\\$\\{)(.+?)(?=\\})").matcher(this.__result);
        boolean _result = _match.find();
        if (_result) {
            do {
                _vars.add(_match.group());
            } while (_result = _match.find());
        }
        return _vars;
    }

    public ExpressionUtils clean() {
        return this.set("(.+?)", "");
    }
}

