/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.support.lang;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.templateproject.lang.TP;

public class BlurObject
implements Serializable,
Cloneable {
    private static final Log _LOG = LogFactory.getLog(BlurObject.class);
    private static final long serialVersionUID = 4141840934670622411L;
    private Object attr;

    public static BlurObject bind(Object o) {
        return new BlurObject(o);
    }

    public BlurObject(Object o) {
        this.attr = o;
    }

    public Object toObjectValue() {
        return this.attr;
    }

    public BlurObject toBlurObjectValue() {
        if (this.attr instanceof BlurObject) {
            return (BlurObject)this.attr;
        }
        return this;
    }

    public Map<?, ?> toMapValue() {
        if (this.attr == null) {
            return null;
        }
        if (this.attr instanceof Map) {
            return (Map)this.attr;
        }
        return Collections.emptyMap();
    }

    public List<?> toListValue() {
        if (this.attr == null) {
            return null;
        }
        if (this.attr instanceof List) {
            return (List)this.attr;
        }
        LinkedList<Object> _returnValue = new LinkedList<Object>();
        _returnValue.add(this.attr);
        return _returnValue;
    }

    public Set<?> toSetValue() {
        if (this.attr == null) {
            return null;
        }
        if (this.attr instanceof List) {
            return (Set)this.attr;
        }
        LinkedHashSet<Object> _returnValue = new LinkedHashSet<Object>();
        _returnValue.add(this.attr);
        return _returnValue;
    }

    public boolean toBooleanValue() {
        if (this.attr == null) {
            return false;
        }
        if (this.attr instanceof String) {
            return "true".equalsIgnoreCase(this.attr.toString()) || "on".equalsIgnoreCase(this.attr.toString()) || "1".equalsIgnoreCase(this.attr.toString());
        }
        if (this.attr instanceof Boolean || Boolean.TYPE.isAssignableFrom(this.attr.getClass())) {
            return (Boolean)this.attr;
        }
        if (Float.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Float)this.attr).floatValue() > 0.0f;
        }
        if (Integer.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Integer)this.attr).floatValue() > 0.0f;
        }
        if (Long.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Long)this.attr).floatValue() > 0.0f;
        }
        if (Double.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Double)this.attr).floatValue() > 0.0f;
        }
        if (this.attr instanceof Number) {
            return ((Number)this.attr).floatValue() > 0.0f;
        }
        if (this.attr instanceof List) {
            return ((List)this.attr).size() > 0;
        }
        if (this.attr instanceof Map) {
            return ((Map)this.attr).size() > 0;
        }
        return this.attr instanceof BlurObject && ((BlurObject)this.attr).toBooleanValue();
    }

    public int toIntValue() {
        if (this.attr == null) {
            return 0;
        }
        if (this.attr instanceof Integer || Integer.TYPE.isAssignableFrom(this.attr.getClass())) {
            return (Integer)this.attr;
        }
        if (this.attr instanceof String) {
            if (StringUtils.isNotBlank((String)this.attr.toString())) {
                return Integer.parseInt(this.attr.toString(), 10);
            }
            return 0;
        }
        if (Long.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Long)this.attr).intValue();
        }
        if (Float.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Float)this.attr).intValue();
        }
        if (Double.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Double)this.attr).intValue();
        }
        if (this.attr instanceof Number) {
            return ((Number)this.attr).intValue();
        }
        if (this.attr instanceof Boolean || Boolean.TYPE.isAssignableFrom(this.attr.getClass())) {
            return (Boolean)this.attr != false ? 1 : 0;
        }
        if (this.attr instanceof Map) {
            return ((Map)this.attr).size();
        }
        if (this.attr instanceof List) {
            return ((List)this.attr).size();
        }
        if (this.attr instanceof Short || Short.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Short)this.attr).intValue();
        }
        if (this.attr instanceof BlurObject) {
            return ((BlurObject)this.attr).toIntValue();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringValue() {
        if (this.attr == null) {
            return null;
        }
        if (this.attr instanceof String) {
            return (String)this.attr;
        }
        if (this.attr instanceof Clob) {
            Clob _clob = (Clob)this.attr;
            Reader _reader = null;
            try {
                _reader = _clob.getCharacterStream();
                if (_clob.length() > 0L && _reader != null) {
                    String string = IOUtils.toString((Reader)_reader);
                    return string;
                }
            }
            catch (Exception e) {
                _LOG.warn((Object)"", TP.runtime.unwrapThrow(e));
            }
            finally {
                IOUtils.closeQuietly((Reader)_reader);
            }
        }
        if (this.attr instanceof BlurObject) {
            return ((BlurObject)this.attr).toStringValue();
        }
        return this.attr.toString();
    }

    public float toFloatValue() {
        if (this.attr == null) {
            return 0.0f;
        }
        if (Float.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Float)this.attr).floatValue();
        }
        if (Integer.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Integer)this.attr).floatValue();
        }
        if (Long.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Long)this.attr).floatValue();
        }
        if (Double.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Double)this.attr).floatValue();
        }
        if (this.attr instanceof Number) {
            return ((Number)this.attr).floatValue();
        }
        if (this.attr instanceof String) {
            if (StringUtils.isNotBlank((String)this.attr.toString())) {
                return Float.parseFloat(this.attr.toString());
            }
            return 0.0f;
        }
        if (this.attr instanceof Boolean || Boolean.TYPE.isAssignableFrom(this.attr.getClass())) {
            return (Boolean)this.attr != false ? 1.0f : 0.0f;
        }
        if (this.attr instanceof Map) {
            return ((Map)this.attr).size();
        }
        if (this.attr instanceof List) {
            return ((List)this.attr).size();
        }
        if (this.attr instanceof BlurObject) {
            return ((BlurObject)this.attr).toFloatValue();
        }
        return 0.0f;
    }

    public double toDoubleValue() {
        if (this.attr == null) {
            return 0.0;
        }
        if (Double.TYPE.isAssignableFrom(this.attr.getClass())) {
            return (Double)this.attr;
        }
        if (Integer.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Integer)this.attr).doubleValue();
        }
        if (Long.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Long)this.attr).doubleValue();
        }
        if (Float.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Float)this.attr).doubleValue();
        }
        if (this.attr instanceof Number) {
            return ((Number)this.attr).doubleValue();
        }
        if (this.attr instanceof String) {
            if (StringUtils.isNotBlank((String)this.attr.toString())) {
                return Double.parseDouble(this.attr.toString());
            }
            return 0.0;
        }
        if (this.attr instanceof Boolean || Boolean.TYPE.isAssignableFrom(this.attr.getClass())) {
            return (Boolean)this.attr != false ? 1.0 : 0.0;
        }
        if (this.attr instanceof Map) {
            return ((Map)this.attr).size();
        }
        if (this.attr instanceof List) {
            return ((List)this.attr).size();
        }
        if (this.attr instanceof BlurObject) {
            return ((BlurObject)this.attr).toDoubleValue();
        }
        return 0.0;
    }

    public long toLongValue() {
        if (this.attr == null) {
            return 0L;
        }
        if (Long.TYPE.isAssignableFrom(this.attr.getClass())) {
            return (Long)this.attr;
        }
        if (Integer.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Integer)this.attr).longValue();
        }
        if (Float.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Float)this.attr).longValue();
        }
        if (Double.TYPE.isAssignableFrom(this.attr.getClass())) {
            return ((Double)this.attr).longValue();
        }
        if (this.attr instanceof Number) {
            return ((Number)this.attr).longValue();
        }
        if (this.attr instanceof String) {
            if (StringUtils.isNotBlank((String)this.attr.toString())) {
                return Long.parseLong(this.attr.toString(), 10);
            }
            return 0L;
        }
        if (this.attr instanceof Boolean || Boolean.TYPE.isAssignableFrom(this.attr.getClass())) {
            return (Boolean)this.attr != false ? 1L : 0L;
        }
        if (this.attr instanceof Map) {
            return ((Map)this.attr).size();
        }
        if (this.attr instanceof List) {
            return ((List)this.attr).size();
        }
        if (this.attr instanceof BlurObject) {
            return ((BlurObject)this.attr).toLongValue();
        }
        return 0L;
    }

    public byte toByteValue() {
        if (this.attr == null) {
            return 0;
        }
        if (this.attr instanceof Byte) {
            return (Byte)this.attr;
        }
        if (this.attr instanceof BlurObject) {
            return ((BlurObject)this.attr).toByteValue();
        }
        return Byte.parseByte(this.toStringValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytesValue() {
        if (this.attr instanceof byte[]) {
            return (byte[])this.attr;
        }
        if (this.attr instanceof Byte[]) {
            Byte[] _bArr = (Byte[])this.attr;
            byte[] _returnBArr = new byte[_bArr.length];
            for (int _idx = 0; _idx < _bArr.length; ++_idx) {
                _returnBArr[_idx] = _bArr[_idx];
            }
            return _returnBArr;
        }
        if (this.attr instanceof Blob) {
            Blob _blob = (Blob)this.attr;
            InputStream _input = null;
            try {
                byte[] _bArr;
                _input = _blob.getBinaryStream();
                if (_blob.length() > 0L && _input != null && _input.read(_bArr = new byte[(int)_blob.length()]) > 0) {
                    byte[] byArray = _bArr;
                    return byArray;
                }
            }
            catch (Exception e) {
                _LOG.warn((Object)"", TP.runtime.unwrapThrow(e));
            }
            finally {
                IOUtils.closeQuietly((InputStream)_input);
            }
        }
        return null;
    }

    public short toShortValue() {
        return (short)this.toIntValue();
    }

    public char toCharValue() {
        if (this.attr == null) {
            return '\u0000';
        }
        if (this.attr instanceof Character) {
            return ((Character)this.attr).charValue();
        }
        if (this.attr instanceof BlurObject) {
            return ((BlurObject)this.attr).toCharValue();
        }
        return '\u0000';
    }

    public Object toObjectValue(Class<?> clazz) {
        String _value;
        Set<?> object = null;
        if (clazz.equals(String.class)) {
            object = this.attr == null ? null : this.toStringValue();
        } else if (clazz.equals(Double.class)) {
            object = this.attr == null ? null : Double.valueOf(this.toDoubleValue());
        } else if (clazz.equals(Double.TYPE)) {
            object = this.toDoubleValue();
        } else if (clazz.equals(Float.class)) {
            object = this.attr == null ? null : Float.valueOf(this.toFloatValue());
        } else if (clazz.equals(Float.TYPE)) {
            object = Float.valueOf(this.toFloatValue());
        } else if (clazz.equals(Integer.class)) {
            object = this.attr == null ? null : Integer.valueOf(this.toIntValue());
        } else if (clazz.equals(Integer.TYPE)) {
            object = this.toIntValue();
        } else if (clazz.equals(Long.class)) {
            object = this.attr == null ? null : Long.valueOf(this.toLongValue());
        } else if (clazz.equals(Long.TYPE)) {
            object = this.toLongValue();
        } else if (clazz.equals(BigInteger.class)) {
            _value = StringUtils.trimToNull((String)this.toStringValue());
            if (_value != null) {
                object = new BigInteger(_value);
            }
        } else if (clazz.equals(BigDecimal.class)) {
            _value = StringUtils.trimToNull((String)this.toStringValue());
            if (_value != null) {
                object = new BigDecimal(_value);
            }
        } else if (clazz.equals(Boolean.class)) {
            object = this.attr == null ? null : Boolean.valueOf(this.toBooleanValue());
        } else if (clazz.equals(Boolean.TYPE)) {
            object = this.toBooleanValue();
        } else if (clazz.equals(Byte.class)) {
            object = this.attr == null ? null : Byte.valueOf(this.toByteValue());
        } else if (clazz.equals(Byte.TYPE)) {
            object = this.toByteValue();
        } else if (clazz.equals(Byte[].class)) {
            object = (Set<?>)(this.attr == null ? null : this.toBytesValue());
        } else if (clazz.equals(byte[].class)) {
            object = (Set<?>)this.toBytesValue();
        } else if (clazz.equals(Character.class)) {
            object = this.attr == null ? null : Character.valueOf(this.toCharValue());
        } else if (clazz.equals(Character.TYPE)) {
            object = Character.valueOf(this.toCharValue());
        } else if (clazz.equals(List.class)) {
            object = this.toListValue();
        } else if (clazz.equals(Map.class)) {
            object = this.toMapValue();
        } else if (clazz.equals(Set.class)) {
            object = this.toSetValue();
        }
        if (object == null) {
            try {
                object = clazz.cast(this.attr);
            }
            catch (ClassCastException e) {
                _LOG.warn((Object)"", TP.runtime.unwrapThrow(e));
            }
        }
        return object;
    }

    public Class<?> getObjectClass() {
        if (this.attr != null) {
            return this.attr.getClass();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attr == null ? 0 : this.attr.hashCode());
        Class<?> _attrClass = this.attr == null ? null : this.attr.getClass();
        result = 31 * result + (_attrClass == null ? 0 : _attrClass.hashCode());
        result = 31 * result;
        return result;
    }

    public boolean equals(Object obj) {
        Class<?> _attrClass;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlurObject other = (BlurObject)obj;
        if (this.attr == null ? other.attr != null : !this.attr.equals(other.attr)) {
            return false;
        }
        Class<?> clazz = _attrClass = this.attr == null ? null : this.attr.getClass();
        if (_attrClass == null ? (other.attr != null ? other.attr.getClass() : null) != null : !_attrClass.equals(other.attr.getClass())) {
            return false;
        }
        return this.attr == other.attr;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        if (this.attr != null) {
            return this.attr.toString();
        }
        return "";
    }
}

