/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.okane;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Money {
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5143", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final String CN_FULL = "";
    private static final String CN_NEGATIVE = "\u8d1f";
    private static final String CN_ZEOR_FULL = "\u96f6\u5143\u6574";
    private static final int MONEY_PRECISION = 2;

    public String number2CNMontray(String numberOfMoney) {
        return this.number2CNMontray(new BigDecimal(numberOfMoney));
    }

    public String number2CNMontray(BigDecimal numberOfMoney) {
        StringBuffer sb = new StringBuffer();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, CN_NEGATIVE);
        }
        if (scale <= 0L) {
            sb.append(CN_FULL);
        }
        return sb.toString();
    }

    public String accountantMoney(BigDecimal money) {
        return this.accountantMoney(money, 2, 1.0);
    }

    public String getFormatMoney(BigDecimal money, int scale, double divisor) {
        return this.formatMoney(money, scale, divisor) + this.getCellFormat(divisor);
    }

    public String getAccountantMoney(BigDecimal money, int scale, double divisor) {
        return this.accountantMoney(money, scale, divisor) + this.getCellFormat(divisor);
    }

    private String accountantMoney(BigDecimal money, int scale, double divisor) {
        String disposeMoneyStr = this.formatMoney(money, scale, divisor);
        int dotPosition = disposeMoneyStr.indexOf(".");
        String exceptDotMoeny = null;
        String dotMeony = null;
        if (dotPosition > 0) {
            exceptDotMoeny = disposeMoneyStr.substring(0, dotPosition);
            dotMeony = disposeMoneyStr.substring(dotPosition);
        } else {
            exceptDotMoeny = disposeMoneyStr;
        }
        int negativePosition = exceptDotMoeny.indexOf("-");
        if (negativePosition == 0) {
            exceptDotMoeny = exceptDotMoeny.substring(1);
        }
        StringBuffer reverseExceptDotMoney = new StringBuffer(exceptDotMoeny);
        reverseExceptDotMoney.reverse();
        char[] moneyChar = reverseExceptDotMoney.toString().toCharArray();
        StringBuffer returnMeony = new StringBuffer();
        for (int i = 0; i < moneyChar.length; ++i) {
            if (i != 0 && i % 3 == 0) {
                returnMeony.append(",");
            }
            returnMeony.append(moneyChar[i]);
        }
        returnMeony.reverse();
        if (dotPosition > 0) {
            returnMeony.append(dotMeony);
        }
        if (negativePosition == 0) {
            return "-" + returnMeony.toString();
        }
        return returnMeony.toString();
    }

    private String formatMoney(BigDecimal money, int scale, double divisor) {
        if (divisor == 0.0) {
            return "0.00";
        }
        if (scale < 0) {
            return "0.00";
        }
        BigDecimal divisorBD = new BigDecimal(divisor);
        return money.divide(divisorBD, scale, RoundingMode.HALF_UP).toString();
    }

    private String getCellFormat(double divisor) {
        String str = String.valueOf(divisor);
        int len = str.substring(0, str.indexOf(".")).length();
        String cell = CN_FULL;
        switch (len) {
            case 1: {
                cell = "\u5143";
                break;
            }
            case 2: {
                cell = "\u5341\u5143";
                break;
            }
            case 3: {
                cell = "\u767e\u5143";
                break;
            }
            case 4: {
                cell = "\u5343\u5143";
                break;
            }
            case 5: {
                cell = "\u4e07\u5143";
                break;
            }
            case 6: {
                cell = "\u5341\u4e07\u5143";
                break;
            }
            case 7: {
                cell = "\u767e\u4e07\u5143";
                break;
            }
            case 8: {
                cell = "\u5343\u4e07\u5143";
                break;
            }
            case 9: {
                cell = "\u4ebf\u5143";
                break;
            }
            case 10: {
                cell = "\u5341\u4ebf\u5143";
            }
        }
        return cell;
    }
}

