/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.okane;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Amount {
    private static final Pattern AMOUNT_PATTERN = Pattern.compile("^(0|[1-9]\\d{0,11})\\.(\\d\\d)$");
    private static final char[] RMB = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".toCharArray();
    private static final String[] UNITS = new String[]{"\u5143", "\u89d2", "\u5206", "\u6574"};
    private static final String[] U1 = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] U2 = new String[]{"", "\u4e07", "\u4ebf"};

    public String convert(String amount) throws IllegalArgumentException {
        String[] amountArray = (amount = amount.replace(",", "")).split("\\.");
        if (amountArray.length != 2) {
            amount = amount + ".00";
        } else if (amountArray[1].length() == 1) {
            amount = amount + "0";
        }
        if (amount.equals("0.00")) {
            return "\u96f6\u5143\u6574";
        }
        Matcher matcher = AMOUNT_PATTERN.matcher(amount);
        if (!matcher.find()) {
            throw new IllegalArgumentException("\u8f93\u5165\u91d1\u989d\u6709\u8bef.");
        }
        String integer = matcher.group(1);
        String fraction = matcher.group(2);
        StringBuilder sb = new StringBuilder("");
        if (!integer.equals("0")) {
            sb.append(Amount.integer2rmb(integer)).append(UNITS[0]);
        }
        if (fraction.equals("00")) {
            sb.append(UNITS[3]);
        } else if (fraction.startsWith("0") && integer.equals("0")) {
            sb.append(Amount.fraction2rmb(fraction).substring(1));
        } else {
            sb.append(Amount.fraction2rmb(fraction));
        }
        return sb.toString();
    }

    private static String fraction2rmb(String fraction) {
        char jiao = fraction.charAt(0);
        char fen = fraction.charAt(1);
        return RMB[jiao - 48] + (jiao > '0' ? UNITS[1] : "") + (fen > '0' ? RMB[fen - 48] + UNITS[2] : "");
    }

    private static String integer2rmb(String integer) {
        StringBuilder buffer = new StringBuilder();
        int i = integer.length() - 1;
        int j = 0;
        while (i >= 0) {
            char n = integer.charAt(i);
            if (n == '0') {
                if (i < integer.length() - 1 && integer.charAt(i + 1) != '0') {
                    buffer.append(RMB[0]);
                }
                if (j % 4 == 0 && (i > 0 && integer.charAt(i - 1) != '0' || i > 1 && integer.charAt(i - 2) != '0' || i > 2 && integer.charAt(i - 3) != '0')) {
                    buffer.append(U2[j / 4]);
                }
            } else {
                if (j % 4 == 0) {
                    buffer.append(U2[j / 4]);
                }
                buffer.append(U1[j % 4]);
                buffer.append(RMB[n - 48]);
            }
            --i;
            ++j;
        }
        return buffer.reverse().toString();
    }
}

