/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    private static final String ZIP_FILE_SUFFIX = ".zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zipFile(String resourcePath, String targetPath) {
        File resourcesFile = new File(resourcePath);
        File targetFile = new File(targetPath);
        if (!targetFile.exists()) {
            targetFile.mkdirs();
        }
        String targetName = resourcesFile.getName() + ZIP_FILE_SUFFIX;
        ZipOutputStream out = null;
        try {
            FileOutputStream outputStream = new FileOutputStream(targetPath + "//" + targetName);
            out = new ZipOutputStream(new BufferedOutputStream(outputStream));
            this.compressedFile(out, resourcesFile, "");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressedFile(ZipOutputStream out, File file, String dir) {
        FileInputStream fis = null;
        try {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                out.putNextEntry(new ZipEntry(dir + "/"));
                dir = dir.length() == 0 ? "" : dir + "/";
                for (int i = 0; i < files.length; ++i) {
                    this.compressedFile(out, files[i], dir + files[i].getName());
                }
            } else {
                int j;
                fis = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(dir));
                byte[] buffer = new byte[1024];
                while ((j = fis.read(buffer)) > 0) {
                    out.write(buffer, 0, j);
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

