/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.clazz;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public class ClassScan {
    public Set<Class<?>> scan(String basePackage, Set<Class<? extends Annotation>> includeAnnotations, Set<String> includeNames) throws IOException, ClassNotFoundException {
        HashSet result = new HashSet();
        String packageDir = basePackage.replace('.', '/');
        Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources(packageDir);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            switch (url.getProtocol()) {
                case "file": {
                    result.addAll(ClassScan.findAndAddClassesByFile(basePackage, new File(URLDecoder.decode(url.getFile(), "UTF-8")), includeAnnotations, includeNames));
                    break;
                }
                case "jar": {
                    result.addAll(ClassScan.findAndAddClassesByJar(((JarURLConnection)url.openConnection()).getJarFile(), packageDir, includeAnnotations, includeNames));
                    break;
                }
            }
        }
        return result;
    }

    private static Set<Class<?>> findAndAddClassesByFile(String currentPackage, File currentFile, Set<Class<? extends Annotation>> annotations, Set<String> classNames) throws ClassNotFoundException {
        HashSet result = new HashSet();
        if (currentFile.exists() && currentFile.isDirectory()) {
            File[] files;
            for (File file : files = currentFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".clazz");
                }
            })) {
                if (file.isDirectory()) {
                    result.addAll(ClassScan.findAndAddClassesByFile(currentPackage + "." + file.getName(), file, annotations, classNames));
                    continue;
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(currentPackage + '.' + className);
                if (!ClassScan.isMatch(clazz, annotations, classNames)) continue;
                result.add(clazz);
            }
        }
        return result;
    }

    private static Set<Class<?>> findAndAddClassesByJar(JarFile jar, String currentPath, Set<Class<? extends Annotation>> annotations, Set<String> classNames) throws ClassNotFoundException {
        HashSet result = new HashSet();
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String jarName = jarEntry.getName();
            if (jarName.charAt(0) == '/') {
                jarName = jarName.substring(1);
            }
            if (!jarName.startsWith(currentPath)) continue;
            int idx = jarName.lastIndexOf(47);
            if (!jarName.endsWith(".clazz") || jarEntry.isDirectory()) continue;
            String className = jarName.substring(jarName.lastIndexOf(47) + 1, jarName.length() - 6);
            Class<?> clazz = Class.forName(jarName.substring(0, idx).replace('/', '.') + '.' + className);
            if (!ClassScan.isMatch(clazz, annotations, classNames)) continue;
            result.add(clazz);
        }
        return result;
    }

    private static boolean isMatch(Class<?> clazz, Set<Class<? extends Annotation>> annotations, Set<String> classNames) {
        return ClassScan.matchAnnotation(clazz, annotations) && ClassScan.matchClassName(clazz, classNames);
    }

    private static boolean matchAnnotation(Class<?> clazz, Set<Class<? extends Annotation>> annotations) {
        if (annotations == null || annotations.isEmpty()) {
            return true;
        }
        for (Class<? extends Annotation> annotation : annotations) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchClassName(Class<?> clazz, Set<String> classNames) {
        if (classNames == null || classNames.isEmpty()) {
            return true;
        }
        for (String className : classNames) {
            if (!Pattern.compile(className).matcher(clazz.getSimpleName()).find()) continue;
            return true;
        }
        return false;
    }
}

