/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.clazz;

import com.thoughtworks.paranamer.AdaptiveParanamer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;
import org.templateproject.lang.TP;
import org.templateproject.lang.support.lang.BlurObject;
import org.templateproject.lang.support.lang.PairObject;

public class ClassKit {
    private static final Log _LOG = LogFactory.getLog(ClassUtils.class);
    private static InnerClassLoader _INNER_CLASS_LOADER = new InnerClassLoader(new URL[0], ClassUtils.class.getClassLoader());

    public static ClassLoader getDefaultClassLoader() {
        return _INNER_CLASS_LOADER;
    }

    public static <T> T impl(String className, Class<T> interfaceClass, Class<?> callingClass) {
        if (StringUtils.isNotBlank((String)className)) {
            try {
                Class<?> implClass = ClassKit.loadClass(className, callingClass);
                if (interfaceClass == null || interfaceClass.isAssignableFrom(implClass)) {
                    return (T)implClass.newInstance();
                }
            }
            catch (Exception e) {
                _LOG.warn((Object)"", TP.runtime.unwrapThrow(e));
            }
        }
        return null;
    }

    public static <T> T impl(Class<?> implClass, Class<T> interfaceClass) {
        if (implClass != null && (interfaceClass == null || interfaceClass.isAssignableFrom(implClass))) {
            try {
                return (T)implClass.newInstance();
            }
            catch (Exception e) {
                _LOG.warn((Object)"", TP.runtime.unwrapThrow(e));
            }
        }
        return null;
    }

    public static Class<?> loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        Class<?> _targetClass = null;
        try {
            _targetClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                _targetClass = Class.forName(className, false, ClassUtils.class.getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                try {
                    _targetClass = _INNER_CLASS_LOADER.loadClass(className);
                }
                catch (ClassNotFoundException exc) {
                    _targetClass = callingClass.getClassLoader().loadClass(className);
                }
            }
        }
        return _targetClass;
    }

    public static boolean isSubclassOf(Class<?> clazz, Class<?> superClass) {
        Class<?> cc;
        boolean _flag = false;
        while ((cc = clazz.getSuperclass()) != null) {
            if (cc.equals(superClass)) {
                _flag = true;
                break;
            }
            if ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) continue;
        }
        return _flag;
    }

    public static boolean isInterfaceOf(Class<?> clazz, Class<?> interfaceClass) {
        boolean _flag = false;
        do {
            for (Class<?> cc : clazz.getInterfaces()) {
                if (!cc.equals(interfaceClass)) continue;
                _flag = true;
            }
            clazz = clazz.getSuperclass();
        } while (!_flag && clazz != null && clazz != Object.class);
        return _flag;
    }

    public static boolean isAnnotationOf(Object target, Class<? extends Annotation> annotationClass) {
        return target instanceof Field ? ((Field)target).isAnnotationPresent(annotationClass) : (target instanceof Method ? ((Method)target).isAnnotationPresent(annotationClass) : target instanceof Class && ((Class)target).isAnnotationPresent(annotationClass));
    }

    public static String[] getInterfaceNames(Class<?> clazz) {
        Class<?>[] interfaces = clazz.getInterfaces();
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> i : interfaces) {
            names.add(i.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public static List<Class<?>> getParameterizedTypes(Class<?> clazz) {
        ArrayList _clazzs = new ArrayList();
        Type _types = clazz.getGenericSuperclass();
        if (ParameterizedType.class.isAssignableFrom(_types.getClass())) {
            for (Type _type : ((ParameterizedType)_types).getActualTypeArguments()) {
                if (ParameterizedType.class.isAssignableFrom(_type.getClass())) {
                    _clazzs.add((Class)((ParameterizedType)_type).getRawType());
                    continue;
                }
                _clazzs.add((Class)_type);
            }
        } else {
            _clazzs.add((Class)_types);
        }
        return _clazzs;
    }

    public static List<Field> getFields(Class<?> clazz, boolean parent) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        Class<?> clazzin = clazz;
        while (clazzin != null) {
            fieldList.addAll(Arrays.asList(clazzin.getDeclaredFields()));
            if (parent) {
                clazzin = clazzin.getSuperclass();
                continue;
            }
            clazzin = null;
        }
        return fieldList;
    }

    public static <A extends Annotation> List<PairObject<Field, A>> getFieldAnnotations(Class<?> clazz, Class<A> annotationClazz) {
        ArrayList<PairObject<Field, A>> _annotations = new ArrayList<PairObject<Field, A>>();
        for (Field _field : ClassKit.getFields(clazz, true)) {
            A _annotation = _field.getAnnotation(annotationClazz);
            if (_annotation == null) continue;
            _annotations.add(new PairObject<Field, A>(_field, _annotation));
        }
        return _annotations;
    }

    public static <A extends Annotation> PairObject<Field, A> getFieldAnnotationFirst(Class<?> clazz, Class<A> annotationClazz) {
        PairObject<Field, A> _returnAnno = null;
        for (Field _field : ClassKit.getFields(clazz, true)) {
            A _annotation = _field.getAnnotation(annotationClazz);
            if (_annotation == null) continue;
            _returnAnno = new PairObject<Field, A>(_field, _annotation);
            break;
        }
        return _returnAnno;
    }

    public static String[] getMethodParamNames(Method method) {
        return new AdaptiveParanamer().lookupParameterNames((AccessibleObject)method, false);
    }

    public static Class<?> getArrayClassType(Class<?> clazz) {
        try {
            return Class.forName(StringUtils.substringBetween((String)clazz.getName(), (String)"[L", (String)";"));
        }
        catch (ClassNotFoundException e) {
            _LOG.warn((Object)"", TP.runtime.unwrapThrow(e));
            return null;
        }
    }

    public static <T> BeanWrapper<T> wrapper(Class<T> clazz) {
        try {
            return ClassKit.wrapper(clazz.newInstance());
        }
        catch (Exception e) {
            _LOG.warn((Object)"", TP.runtime.unwrapThrow(e));
            return null;
        }
    }

    public static <T> BeanWrapper<T> wrapper(T target) {
        return new BeanWrapper<T>(target);
    }

    public static class BeanWrapper<T> {
        private T target;
        private Map<String, Field> _fields;

        protected BeanWrapper(T target) {
            this.target = target;
            this._fields = new LinkedHashMap<String, Field>();
            for (Field _field : ClassKit.getFields(target.getClass(), true)) {
                if (Modifier.isStatic(_field.getModifiers())) continue;
                _field.setAccessible(true);
                this._fields.put(_field.getName(), _field);
            }
        }

        public T getTargetObject() {
            return this.target;
        }

        public Set<String> getFieldNames() {
            return this._fields.keySet();
        }

        public Annotation[] getFieldAnnotations(String fieldName) {
            return this._fields.get(fieldName).getAnnotations();
        }

        public Field getField(String fieldName) {
            return this._fields.get(fieldName);
        }

        public Class<?> getFieldType(String fieldName) {
            return this._fields.get(fieldName).getType();
        }

        public BeanWrapper<T> setValue(String fieldName, Object value) throws IllegalAccessException {
            this._fields.get(fieldName).set(this.target, value);
            return this;
        }

        public Object getValue(String fieldName) throws IllegalAccessException {
            return this._fields.get(fieldName).get(this.target);
        }

        public BeanWrapper<T> fromMap(Map<String, Object> map) {
            for (Map.Entry<String, Object> _entry : map.entrySet()) {
                try {
                    this.setValue(_entry.getKey(), _entry.getValue());
                }
                catch (Exception ignored) {}
            }
            return this;
        }

        public BeanWrapper<T> fromMap(Map<String, Object> map, IFieldValueFilter filter) {
            for (Map.Entry<String, Object> _entry : map.entrySet()) {
                try {
                    if (filter != null && filter.filter(_entry.getKey(), _entry.getValue())) continue;
                    this.setValue(_entry.getKey(), _entry.getValue());
                }
                catch (Exception ignored) {}
            }
            return this;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> _returnValues = new HashMap<String, Object>();
            for (Field _field : this._fields.values()) {
                try {
                    _returnValues.put(_field.getName(), this.getValue(_field.getName()));
                }
                catch (Exception ignored) {}
            }
            return _returnValues;
        }

        public Map<String, Object> toMap(IFieldValueFilter filter) {
            HashMap<String, Object> _returnValues = new HashMap<String, Object>();
            for (Field _field : this._fields.values()) {
                try {
                    Object _fValue = this.getValue(_field.getName());
                    if (filter != null && filter.filter(_field.getName(), _fValue)) continue;
                    _returnValues.put(_field.getName(), _fValue);
                }
                catch (Exception ignored) {}
            }
            return _returnValues;
        }

        public <D> D duplicate(D dist) {
            BeanWrapper<D> _wrapDist = ClassKit.wrapper(dist);
            for (String _fieldName : this.getFieldNames()) {
                if (!_wrapDist.getFieldNames().contains(_fieldName)) continue;
                Object _fValue = null;
                try {
                    _fValue = this.getValue(_fieldName);
                    _wrapDist.setValue(_fieldName, _fValue);
                }
                catch (Exception e) {
                    if (_fValue == null) continue;
                    try {
                        _wrapDist.setValue(_fieldName, BlurObject.bind(_fValue).toObjectValue(_wrapDist.getFieldType(_fieldName)));
                    }
                    catch (Exception ignored) {}
                }
            }
            return _wrapDist.getTargetObject();
        }

        public <D> D duplicate(D dist, IFieldValueFilter filter) {
            BeanWrapper<D> _wrapDist = ClassKit.wrapper(dist);
            for (String _fieldName : this.getFieldNames()) {
                if (!_wrapDist.getFieldNames().contains(_fieldName)) continue;
                Object _fValue = null;
                try {
                    _fValue = this.getValue(_fieldName);
                    if (filter != null && filter.filter(_fieldName, _fValue)) continue;
                    _wrapDist.setValue(_fieldName, _fValue);
                }
                catch (Exception e) {
                    if (_fValue == null) continue;
                    try {
                        _wrapDist.setValue(_fieldName, BlurObject.bind(_fValue).toObjectValue(_wrapDist.getFieldType(_fieldName)));
                    }
                    catch (Exception ignored) {}
                }
            }
            return _wrapDist.getTargetObject();
        }
    }

    public static interface IFieldValueFilter {
        public boolean filter(String var1, Object var2);
    }

    public static class InnerClassLoader
    extends URLClassLoader {
        public InnerClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }
    }
}

