/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.templateproject.lang.TP;
import org.templateproject.lang.support.utils.ExpressionUtils;

public class Runtime {
    private static final Map<String, String> SYSTEM_ENV_MAP = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSystemEnvironment() {
        Process p = null;
        BufferedReader br = null;
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                p = java.lang.Runtime.getRuntime().exec("cmd /c set");
            } else if (SystemUtils.IS_OS_UNIX) {
                p = java.lang.Runtime.getRuntime().exec("/bin/sh -c set");
            } else {
                System.out.println("Unknown os.name=" + SystemUtils.OS_NAME);
                SYSTEM_ENV_MAP.clear();
            }
            if (p != null) {
                String line;
                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = br.readLine()) != null) {
                    int i = line.indexOf(61);
                    if (i <= -1) continue;
                    String key = line.substring(0, i);
                    String value = line.substring(i + 1);
                    SYSTEM_ENV_MAP.put(key, value);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (p != null) {
                p.destroy();
            }
        }
    }

    public Map<String, String> getSystemEnvs() {
        if (SYSTEM_ENV_MAP.isEmpty()) {
            this.initSystemEnvironment();
        }
        return SYSTEM_ENV_MAP;
    }

    public String getSystemEnv(String envName) {
        if (StringUtils.isNotBlank((String)envName)) {
            if (SYSTEM_ENV_MAP.isEmpty()) {
                this.initSystemEnvironment();
            }
            return SYSTEM_ENV_MAP.get(envName);
        }
        return null;
    }

    public boolean isUnixOrLinux() {
        return SystemUtils.IS_OS_UNIX;
    }

    public boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public String getRootPath() {
        return this.getRootPath(true);
    }

    public String getRootPath(boolean safe) {
        String _rootPath = null;
        URL _rootURL = Runtime.class.getClassLoader().getResource("/");
        if (_rootURL == null) {
            _rootURL = Runtime.class.getClassLoader().getResource("");
            if (_rootURL != null) {
                _rootPath = _rootURL.getPath();
            }
        } else {
            _rootPath = StringUtils.removeEnd((String)StringUtils.substringBefore((String)_rootURL.getPath(), (String)(safe ? "classes/" : "WEB-INF/")), (String)"/");
        }
        if (_rootPath != null) {
            _rootPath = StringUtils.replace((String)_rootPath, (String)"%20", (String)" ");
            if (this.isWindows()) {
                _rootPath = StringUtils.removeStart((String)_rootPath, (String)"/");
            }
        }
        return StringUtils.trimToEmpty((String)_rootPath);
    }

    public String replaceEnvVariable(String origin) {
        if ((origin = StringUtils.trimToNull((String)origin)) != null) {
            String _defaultPath = this.getRootPath();
            if (StringUtils.startsWith((String)origin, (String)"${root}")) {
                origin = ExpressionUtils.bind(origin).set("root", _defaultPath).getResult();
            } else if (StringUtils.startsWith((String)origin, (String)"${user.dir}")) {
                origin = ExpressionUtils.bind(origin).set("user.dir", System.getProperty("user.dir", _defaultPath)).getResult();
            } else if (StringUtils.startsWith((String)origin, (String)"${user.home}")) {
                origin = ExpressionUtils.bind(origin).set("user.home", System.getProperty("user.home", _defaultPath)).getResult();
            }
        }
        return origin;
    }

    public RuntimeException makeRuntimeThrow(String format, Object ... args) {
        return new RuntimeException(String.format(format, args));
    }

    public RuntimeException wrapRuntimeThrow(Throwable e, String fmt, Object ... args) {
        return new RuntimeException(String.format(fmt, args), e);
    }

    public RuntimeException wrapRuntimeThrow(Throwable e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof InvocationTargetException) {
            return this.wrapRuntimeThrow(((InvocationTargetException)e).getTargetException());
        }
        return new RuntimeException(e);
    }

    public Throwable unwrapThrow(Throwable e) {
        InvocationTargetException itE;
        if (e == null) {
            return null;
        }
        if (e instanceof InvocationTargetException && (itE = (InvocationTargetException)e).getTargetException() != null) {
            return this.unwrapThrow(itE.getTargetException());
        }
        if (e.getCause() != null) {
            return this.unwrapThrow(e.getCause());
        }
        return e;
    }

    public long gc() {
        java.lang.Runtime rt = java.lang.Runtime.getRuntime();
        long lastUsed = rt.totalMemory() - rt.freeMemory();
        rt.gc();
        return lastUsed - rt.totalMemory() + rt.freeMemory();
    }

    static {
        TP.runtime.initSystemEnvironment();
    }
}

