/*
 * Decompiled with CFR 0.152.
 */
package org.templateproject.lang.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class Random {
    private static final String BASE_NUMBER = "0123456789";
    private static final String BASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final String BASE_CHAR_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";

    public int randomInt(int min, int max) {
        java.util.Random random = new java.util.Random();
        return random.nextInt(max - min) + min;
    }

    public int randomInt() {
        java.util.Random random = new java.util.Random();
        return random.nextInt();
    }

    public int randomInt(int limit) {
        java.util.Random random = new java.util.Random();
        return random.nextInt(limit);
    }

    public byte[] randomBytes(int length) {
        java.util.Random random = new java.util.Random();
        byte[] bytes = new byte[length];
        random.nextBytes(bytes);
        return bytes;
    }

    public <T> T randomEle(List<T> list) {
        return this.randomEle(list, list.size());
    }

    public <T> T randomEle(List<T> list, int limit) {
        return list.get(this.randomInt(limit));
    }

    public <T> List<T> randomEles(List<T> list, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        int limit = list.size();
        while (--count > 0) {
            result.add(this.randomEle(list, limit));
        }
        return result;
    }

    public <T> Set<T> randomEleSet(Collection<T> collection, int count) {
        ArrayList<T> source = new ArrayList<T>(new HashSet<T>(collection));
        if (count > source.size()) {
            throw new IllegalArgumentException("Count is larger than collection distinct size !");
        }
        HashSet<T> result = new HashSet<T>(count);
        int limit = collection.size();
        while (result.size() <= count) {
            result.add(this.randomEle(source, limit));
        }
        return result;
    }

    public String randomString(int length) {
        return this.randomString(BASE_CHAR_NUMBER, length);
    }

    public String randomNumbers(int length) {
        return this.randomString(BASE_NUMBER, length);
    }

    public String randomString(String baseString, int length) {
        java.util.Random random = new java.util.Random();
        StringBuffer sb = new StringBuffer();
        if (length < 1) {
            length = 1;
        }
        int baseLength = baseString.length();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(baseLength);
            sb.append(baseString.charAt(number));
        }
        return sb.toString();
    }

    public String randomUUID() {
        return UUID.randomUUID().toString();
    }
}

