/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.lang.config.xml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import me.wuwenbin.lang.support.exception.LangException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlW3c {
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";

    public Document readXML(File file) {
        if (file == null) {
            throw new NullPointerException("Xml file is null !");
        }
        if (!file.exists()) {
            throw new LangException("Files [" + file.getAbsolutePath() + "] not a exist!");
        }
        if (!file.isFile()) {
            throw new LangException("[" + file.getAbsolutePath() + "] not a file!");
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(file);
        }
        catch (Exception e) {
            throw new LangException("Parse xml file [" + file.getAbsolutePath() + "] error!", e);
        }
    }

    public Document readXML(String absoluteFilePath) {
        return this.readXML(new File(absoluteFilePath));
    }

    public List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        return this.transElements(element, nodeList);
    }

    public Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public String elementText(Element element, String tagName) {
        Element child = this.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public String elementText(Element element, String tagName, String defaultValue) {
        Element child = this.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public List<Element> transElements(NodeList nodeList) {
        return this.transElements(null, nodeList);
    }

    public List<Element> transElements(Element parentEle, NodeList nodeList) {
        ArrayList<Element> elements = new ArrayList<Element>();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }
}

