/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.lang.common;

import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.wuwenbin.lang.entrance.$;

public class StringHelper {
    public static final char C_SPACE = ' ';
    public static final char C_TAB = '\t';
    public static final char C_DOT = '.';
    public static final char C_SLASH = '/';
    public static final char C_BACKSLASH = '\\';
    public static final char C_CR = '\r';
    public static final char C_LF = '\n';
    public static final char C_UNDERLINE = '_';
    public static final char C_COMMA = ',';
    public static final char C_DELIMITER_START = '{';
    public static final char C_DELIMITER_END = '}';
    public static final char C_COLON = ':';
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final String DOT = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final String UNDERLINE = "_";
    public static final String COMMA = ",";
    public static final String DELEMITER_START = "{";
    public static final String DELIMITER_END = "}";
    public static final String COLON = ":";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";

    public boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isNotBlank(CharSequence str) {
        return false == this.isBlank(str);
    }

    public boolean hasBlank(CharSequence ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!this.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllBlank(CharSequence ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!this.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public boolean isNotEmpty(CharSequence str) {
        return false == this.isEmpty(str);
    }

    public String nullToEmpty(String str) {
        return this.nullToDefault(str, EMPTY);
    }

    public String nullToDefault(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public String emptyToNull(String str) {
        return this.isEmpty(str) ? null : str;
    }

    public boolean hasEmpty(CharSequence ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!this.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public boolean isAllEmpty(CharSequence ... strs) {
        if (strs == null || strs.length == 0) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!this.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public String trim(String str) {
        return null == str ? null : this.trim(str, 0);
    }

    public void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = str.trim();
        }
    }

    public String trimStart(String str) {
        return this.trim(str, -1);
    }

    public String trimEnd(String str) {
        return this.trim(str, 1);
    }

    public String trim(String str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.substring(start, end);
        }
        return str;
    }

    public boolean startWith(String str, String prefix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toLowerCase().startsWith(prefix.toLowerCase());
        }
        return str.startsWith(prefix);
    }

    public boolean startWithIgnoreCase(String str, String prefix) {
        return this.startWith(str, prefix, true);
    }

    public boolean endWith(String str, String suffix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toLowerCase().endsWith(suffix.toLowerCase());
        }
        return str.endsWith(suffix);
    }

    public boolean endWithIgnoreCase(String str, String suffix) {
        return this.endWith(str, suffix, true);
    }

    public boolean containsIgnoreCase(String str, String testStr) {
        if (null == str) {
            return null == testStr;
        }
        return str.toLowerCase().contains(testStr.toLowerCase());
    }

    public String removeAll(String str, CharSequence strToRemove) {
        return str.replace(strToRemove, EMPTY);
    }

    public String removePreAndLowerFirst(String str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str;
    }

    public String removePreAndLowerFirst(String str, String prefix) {
        return this.lowerFIrstLetter(this.removePrefix(str, prefix));
    }

    public String upperFirstLetterAndAddPre(String str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + this.upperFirstLetter(str);
    }

    public String upperFirstLetter(String str) {
        if (this.isBlank(str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + this.subSuf(str, 1);
    }

    public String lowerFIrstLetter(String str) {
        if (this.isBlank(str)) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + this.subSuf(str, 1);
    }

    public String removePrefix(String str, String prefix) {
        if (this.isEmpty(str) || this.isEmpty(prefix)) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return this.subSuf(str, prefix.length());
        }
        return str;
    }

    public String removePrefixIgnoreCase(String str, String prefix) {
        if (this.isEmpty(str) || this.isEmpty(prefix)) {
            return str;
        }
        if (str.toLowerCase().startsWith(prefix.toLowerCase())) {
            return this.subSuf(str, prefix.length());
        }
        return str;
    }

    public String removeSuffix(String str, String suffix) {
        if (this.isEmpty(str) || this.isEmpty(suffix)) {
            return str;
        }
        if (str.endsWith(suffix)) {
            return this.subPre(str, str.length() - suffix.length());
        }
        return str;
    }

    public String removeSufAndLowerFirst(String str, String suffix) {
        return this.lowerFIrstLetter(this.removeSuffix(str, suffix));
    }

    public String removeSuffixIgnoreCase(String str, String suffix) {
        if (this.isEmpty(str) || this.isEmpty(suffix)) {
            return str;
        }
        if (str.toLowerCase().endsWith(suffix.toLowerCase())) {
            return this.subPre(str, str.length() - suffix.length());
        }
        return str;
    }

    public String addPrefixIfNot(String str, String prefix) {
        if (this.isEmpty(str) || this.isEmpty(prefix)) {
            return str;
        }
        if (!str.startsWith(prefix)) {
            str = prefix + str;
        }
        return str;
    }

    public String addSuffixIfNot(String str, String suffix) {
        if (this.isEmpty(str) || this.isEmpty(suffix)) {
            return str;
        }
        if (!str.endsWith(suffix)) {
            str = str + suffix;
        }
        return str;
    }

    public String cleanBlank(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public String[] splitToArray(String str, char separator) {
        List<String> result = this.split(str, separator);
        return result.toArray(new String[result.size()]);
    }

    public List<String> split(String str, char separator) {
        return this.split(str, separator, 0);
    }

    public String[] splitToArray(String str, char separator, int limit) {
        List<String> result = this.split(str, separator, limit);
        return result.toArray(new String[result.size()]);
    }

    public List<String> split(String str, char separator, int limit) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(limit == 0 ? 16 : limit);
        if (limit == 1) {
            list.add(str);
            return list;
        }
        boolean isNotEnd = true;
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (isNotEnd && c == separator) {
                list.add(sb.toString());
                sb.delete(0, sb.length());
                if (limit == 0 || list.size() != limit - 1) continue;
                isNotEnd = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public String[] split(String str, String delimiter) {
        int i;
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return new String[]{str};
        }
        int dellen = delimiter.length();
        int maxparts = str.length() / dellen + 2;
        int[] positions = new int[maxparts];
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = str.indexOf(delimiter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = str.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = str.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public String[] split(String str, int len) {
        int partCount = str.length() / len;
        int lastPartCount = str.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str.substring(i * len, i * len + lastPartCount) : str.substring(i * len, i * len + len);
        }
        return strs;
    }

    public String sub(String string, int fromIndex, int toIndex) {
        int len = string.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        return string.substring(fromIndex, toIndex);
    }

    public String subPre(String string, int toIndex) {
        return this.sub(string, 0, toIndex);
    }

    public String subSuf(String string, int fromIndex) {
        if (this.isEmpty(string)) {
            return null;
        }
        return this.sub(string, fromIndex, string.length());
    }

    public boolean isSurround(String str, String prefix, String suffix) {
        if (this.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public boolean isSurround(CharSequence str, char prefix, char suffix) {
        if (this.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public String repeat(char c, int count) {
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public String repeat(String str, int count) {
        int n;
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public String indexedFormat(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    public String format(String template, Object ... params) {
        if (params == null || params.length == 0 || this.isBlank(template)) {
            return template;
        }
        return $.placeholder.format(template, params);
    }

    public String format(String template, Map<?, ?> map) {
        if (null == map || map.isEmpty()) {
            return template;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            template = template.replace(DELEMITER_START + entry.getKey() + DELIMITER_END, this.utf8Str(entry.getValue()));
        }
        return template;
    }

    public byte[] utf8Bytes(String str) {
        return this.bytes(str, StandardCharsets.UTF_8);
    }

    public byte[] bytes(String str) {
        return this.bytes(str, Charset.defaultCharset());
    }

    public byte[] bytes(String str, String charset) {
        return this.bytes(str, this.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public byte[] bytes(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.getBytes();
        }
        return str.getBytes(charset);
    }

    public String utf8Str(Object obj) {
        return this.str(obj, StandardCharsets.UTF_8);
    }

    public String str(Object obj, String charsetName) {
        return this.str(obj, Charset.forName(charsetName));
    }

    public String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return this.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return this.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return this.str((ByteBuffer)obj, charset);
        }
        if (obj.getClass().isArray()) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return Arrays.toString((long[])obj);
                    }
                    case "int": {
                        return Arrays.toString((int[])obj);
                    }
                    case "short": {
                        return Arrays.toString((short[])obj);
                    }
                    case "char": {
                        return Arrays.toString((char[])obj);
                    }
                    case "byte": {
                        return Arrays.toString((byte[])obj);
                    }
                    case "boolean": {
                        return Arrays.toString((boolean[])obj);
                    }
                    case "float": {
                        return Arrays.toString((float[])obj);
                    }
                    case "double": {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new RuntimeException(e);
            }
        }
        return obj.toString();
    }

    public String str(byte[] bytes, String charset) {
        return this.str(bytes, this.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public String str(Byte[] bytes, String charset) {
        return this.str(bytes, this.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return this.str(bytes, charset);
    }

    public String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return this.str(data, Charset.forName(charset));
    }

    public String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public ByteBuffer byteBuffer(String str, String charset) {
        return ByteBuffer.wrap(this.bytes(str, charset));
    }

    public String toUnderlineCase(String camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        int length = camelCaseStr.length();
        StringBuilder sb = new StringBuilder();
        boolean isPreUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = camelCaseStr.charAt(i);
            boolean isNextUpperCase = true;
            if (i < length - 1) {
                isNextUpperCase = Character.isUpperCase(camelCaseStr.charAt(i + 1));
            }
            if (Character.isUpperCase(c)) {
                if (!(isPreUpperCase && isNextUpperCase || i <= 0)) {
                    sb.append(UNDERLINE);
                }
                isPreUpperCase = true;
            } else {
                isPreUpperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public String toCamelCase(String name) {
        if (name == null) {
            return null;
        }
        if (name.contains(UNDERLINE)) {
            name = name.toLowerCase();
            StringBuilder sb = new StringBuilder(name.length());
            boolean upperCase = false;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return name;
    }

    public boolean isWrap(String str, String prefix, String suffix) {
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public boolean isWrap(String str, String wrapper) {
        return this.isWrap(str, wrapper, wrapper);
    }

    public boolean isWrap(String str, char wrapper) {
        return this.isWrap(str, wrapper, wrapper);
    }

    public boolean isWrap(String str, char prefixChar, char suffixChar) {
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public String padPre(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public String padEnd(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(str);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public StringBuilder builder() {
        return new StringBuilder();
    }

    public StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public StringBuilder builder(String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public StringReader getReader(String str) {
        return new StringReader(str);
    }

    public StringWriter getWriter() {
        return new StringWriter();
    }

    public int count(String content, String strForSearch) {
        if (this.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = content.indexOf(strForSearch, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public int count(String content, char charForSearch) {
        int count = 0;
        if (this.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }
}

