/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.lang.common;

import java.util.Collection;
import java.util.HashSet;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinYin {
    public Collection<String> getPinyin(String str) {
        if (str != null && !str.trim().equalsIgnoreCase("")) {
            char[] strChar = str.toCharArray();
            HanyuPinyinOutputFormat hanYuPinOutputFormat = new HanyuPinyinOutputFormat();
            hanYuPinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            hanYuPinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            hanYuPinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
            String[][] temp = new String[str.length()][];
            for (int i = 0; i < strChar.length; ++i) {
                char c = strChar[i];
                if (String.valueOf(c).matches("[\\u4E00-\\u9FA5]+")) {
                    try {
                        temp[i] = PinyinHelper.toHanyuPinyinStringArray((char)strChar[i], (HanyuPinyinOutputFormat)hanYuPinOutputFormat);
                    }
                    catch (BadHanyuPinyinOutputFormatCombination e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                temp[i] = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' ? new String[]{String.valueOf(strChar[i])} : new String[]{""};
            }
            String[] pingyinArray = this.Exchange(temp);
            HashSet<String> pinyinSet = new HashSet<String>();
            for (int i = 0; i < pingyinArray.length; ++i) {
                pinyinSet.add(pingyinArray[i]);
            }
            return pinyinSet;
        }
        return null;
    }

    private String[] Exchange(String[][] strJaggedArray) {
        String[][] temp = this.DoExchange(strJaggedArray);
        return temp[0];
    }

    private String[][] DoExchange(String[][] strJaggedArray) {
        int len = strJaggedArray.length;
        if (len >= 2) {
            int len1 = strJaggedArray[0].length;
            int len2 = strJaggedArray[1].length;
            int newlen = len1 * len2;
            String[] temp = new String[newlen];
            int Index = 0;
            for (int i = 0; i < len1; ++i) {
                for (int j = 0; j < len2; ++j) {
                    temp[Index] = strJaggedArray[0][i] + strJaggedArray[1][j];
                    ++Index;
                }
            }
            String[][] newArray = new String[len - 1][];
            for (int i = 2; i < len; ++i) {
                newArray[i - 1] = strJaggedArray[i];
            }
            newArray[0] = temp;
            return this.DoExchange(newArray);
        }
        return strJaggedArray;
    }

    public String getFirstSpell(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    pybf.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }
}

