/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.lang.common;

import java.util.regex.Pattern;

public class IDCard {
    private static int[] power = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};

    public boolean isValidatedAllIdcard(String idcard) {
        return this.isValidate18Idcard(idcard);
    }

    public boolean isValidate18Idcard(String idcard) {
        if (idcard.length() != 18) {
            return false;
        }
        String idcard17 = idcard.substring(0, 17);
        String idcard18Code = idcard.substring(17, 18);
        char[] c = null;
        String checkCode = "";
        if (!this.isDigital(idcard17)) {
            return false;
        }
        c = idcard17.toCharArray();
        if (null != c) {
            int[] bit = new int[idcard17.length()];
            bit = this.converCharToInt(c);
            int sum17 = 0;
            sum17 = this.getPowerSum(bit);
            checkCode = this.getCheckCodeBySum(sum17);
            if (null == checkCode) {
                return false;
            }
            if (!idcard18Code.equalsIgnoreCase(checkCode)) {
                return false;
            }
        }
        return true;
    }

    public boolean is18Idcard(String idcard) {
        return Pattern.matches("^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([\\d|x|X]{1})$", idcard);
    }

    private boolean isDigital(String str) {
        return str == null || "".equals(str) ? false : str.matches("^[0-9]*$");
    }

    private int getPowerSum(int[] bit) {
        int sum = 0;
        if (power.length != bit.length) {
            return sum;
        }
        for (int i = 0; i < bit.length; ++i) {
            for (int j = 0; j < power.length; ++j) {
                if (i != j) continue;
                sum += bit[i] * power[j];
            }
        }
        return sum;
    }

    private String getCheckCodeBySum(int sum17) {
        String checkCode = null;
        switch (sum17 % 11) {
            case 10: {
                checkCode = "2";
                break;
            }
            case 9: {
                checkCode = "3";
                break;
            }
            case 8: {
                checkCode = "4";
                break;
            }
            case 7: {
                checkCode = "5";
                break;
            }
            case 6: {
                checkCode = "6";
                break;
            }
            case 5: {
                checkCode = "7";
                break;
            }
            case 4: {
                checkCode = "8";
                break;
            }
            case 3: {
                checkCode = "9";
                break;
            }
            case 2: {
                checkCode = "x";
                break;
            }
            case 1: {
                checkCode = "0";
                break;
            }
            case 0: {
                checkCode = "1";
            }
        }
        return checkCode;
    }

    private int[] converCharToInt(char[] c) throws NumberFormatException {
        int[] a = new int[c.length];
        int k = 0;
        for (char temp : c) {
            a[k++] = Integer.parseInt(String.valueOf(temp));
        }
        return a;
    }

    public int getUserSex(String idno) {
        String sex = "1";
        if (idno != null && idno.length() > 15) {
            sex = idno.substring(16, 17);
        }
        return Integer.parseInt(sex) % 2 == 0 ? 0 : 1;
    }
}

