/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.util.hex;

import java.awt.Color;
import java.nio.charset.Charset;
import me.wuwenbin.tools.util.Util;

public class Hex {
    private final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public boolean isHexNumber(String value) {
        int index = value.startsWith("-") ? 1 : 0;
        return value.startsWith("0x", index) || value.startsWith("0X", index) || value.startsWith("#", index);
    }

    public char[] encodeHex(byte[] data) {
        return this.encodeHex(data, true);
    }

    public char[] encodeHex(String str, Charset charset) {
        return this.encodeHex(Util.stringX.bytes(str, charset), true);
    }

    public char[] encodeHex(byte[] data, boolean toLowerCase) {
        return this.encodeHex(data, toLowerCase ? this.DIGITS_LOWER : this.DIGITS_UPPER);
    }

    public String encodeHexStr(byte[] data) {
        return this.encodeHexStr(data, true);
    }

    public String encodeHexStr(String data, Charset charset) {
        return this.encodeHexStr(Util.stringX.bytes(data, charset), true);
    }

    public String encodeHexStr(String data) {
        return this.encodeHexStr(data, Charset.forName("UTF-8"));
    }

    public String encodeHexStr(byte[] data, boolean toLowerCase) {
        return this.encodeHexStr(data, toLowerCase ? this.DIGITS_LOWER : this.DIGITS_UPPER);
    }

    public String decodeHexStr(String hexStr) {
        return this.decodeHexStr(hexStr, Charset.forName("UTF-8"));
    }

    public String decodeHexStr(String hexStr, Charset charset) {
        if (Util.stringX.isEmpty(hexStr)) {
            return hexStr;
        }
        return this.decodeHexStr(hexStr.toCharArray(), charset);
    }

    public String decodeHexStr(char[] hexData, Charset charset) {
        return Util.stringX.str(this.decodeHex(hexData), charset);
    }

    public byte[] decodeHex(char[] hexData) {
        int len = hexData.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = this.toDigit(hexData[j], j) << 4;
            f |= this.toDigit(hexData[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public byte[] decodeHex(String hexStr) {
        if (Util.stringX.isEmpty(hexStr)) {
            return null;
        }
        return this.decodeHex(hexStr.toCharArray());
    }

    public String encodeColor(Color color) {
        return this.encodeColor(color, "#");
    }

    public String encodeColor(Color color, String prefix) {
        StringBuffer builder = new StringBuffer(prefix);
        String colorHex = Integer.toHexString(color.getRed());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getGreen());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        colorHex = Integer.toHexString(color.getBlue());
        if (1 == colorHex.length()) {
            builder.append('0');
        }
        builder.append(colorHex);
        return builder.toString();
    }

    public Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    private String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(this.encodeHex(data, toDigits));
    }

    private char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

