/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.util.lang;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import me.wuwenbin.tools.util.Util;
import me.wuwenbin.tools.util.exception.LangException;
import me.wuwenbin.tools.util.lang.constant.ArrayConst;

public class ArrayX
implements ArrayConst {
    public boolean isArray(Object obj) {
        if (null == obj) {
            throw new NullPointerException("Object check for isArray is null");
        }
        return obj.getClass().isArray();
    }

    public String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (Util.arrayX.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return Arrays.toString((long[])obj);
                    }
                    case "int": {
                        return Arrays.toString((int[])obj);
                    }
                    case "short": {
                        return Arrays.toString((short[])obj);
                    }
                    case "char": {
                        return Arrays.toString((char[])obj);
                    }
                    case "byte": {
                        return Arrays.toString((byte[])obj);
                    }
                    case "boolean": {
                        return Arrays.toString((boolean[])obj);
                    }
                    case "float": {
                        return Arrays.toString((float[])obj);
                    }
                    case "double": {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new LangException(e);
            }
        }
        return obj.toString();
    }

    public Map toMap(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length < 2) {
                    throw new IllegalArgumentException("Array element " + i + ", '" + object + "', has a length less than 2");
                }
                map.put(entry[0], entry[1]);
                continue;
            }
            throw new IllegalArgumentException("Array element " + i + ", '" + object + "', is neither of type Map.Entry nor an Array");
        }
        return map;
    }

    public Object[] clone(Object[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public long[] clone(long[] array) {
        if (array == null) {
            return null;
        }
        return (long[])array.clone();
    }

    public int[] clone(int[] array) {
        if (array == null) {
            return null;
        }
        return (int[])array.clone();
    }

    public short[] clone(short[] array) {
        if (array == null) {
            return null;
        }
        return (short[])array.clone();
    }

    public char[] clone(char[] array) {
        if (array == null) {
            return null;
        }
        return (char[])array.clone();
    }

    public byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }

    public double[] clone(double[] array) {
        if (array == null) {
            return null;
        }
        return (double[])array.clone();
    }

    public float[] clone(float[] array) {
        if (array == null) {
            return null;
        }
        return (float[])array.clone();
    }

    public boolean[] clone(boolean[] array) {
        if (array == null) {
            return null;
        }
        return (boolean[])array.clone();
    }

    public Object[] nullToEmpty(Object[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        return array;
    }

    public String[] nullToEmpty(String[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return array;
    }

    public long[] nullToEmpty(long[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        return array;
    }

    public int[] nullToEmpty(int[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        return array;
    }

    public short[] nullToEmpty(short[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        return array;
    }

    public char[] nullToEmpty(char[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        return array;
    }

    public byte[] nullToEmpty(byte[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return array;
    }

    public double[] nullToEmpty(double[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        return array;
    }

    public float[] nullToEmpty(float[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        return array;
    }

    public boolean[] nullToEmpty(boolean[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        return array;
    }

    public Long[] nullToEmpty(Long[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        return array;
    }

    public Integer[] nullToEmpty(Integer[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return array;
    }

    public Short[] nullToEmpty(Short[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        return array;
    }

    public Character[] nullToEmpty(Character[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return array;
    }

    public Byte[] nullToEmpty(Byte[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        return array;
    }

    public Double[] nullToEmpty(Double[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return array;
    }

    public Float[] nullToEmpty(Float[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return array;
    }

    public Boolean[] nullToEmpty(Boolean[] array) {
        if (array == null || array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        return array;
    }

    public Object[] subarray(Object[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] subareas = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public long[] subarray(long[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] subareas = new long[newSize];
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public int[] subarray(int[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] subareas = new int[newSize];
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public short[] subarray(short[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] subareas = new short[newSize];
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public char[] subarray(char[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] subareas = new char[newSize];
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public byte[] subarray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] subareas = new byte[newSize];
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public double[] subarray(double[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] subareas = new double[newSize];
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public float[] subarray(float[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] subareas = new float[newSize];
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public boolean[] subarray(boolean[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] subareas = new boolean[newSize];
        System.arraycopy(array, startIndexInclusive, subareas, 0, newSize);
        return subareas;
    }

    public boolean isSameLength(Object[] array1, Object[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public boolean isSameLength(long[] array1, long[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public boolean isSameLength(int[] array1, int[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public boolean isSameLength(short[] array1, short[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public boolean isSameLength(char[] array1, char[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public boolean isSameLength(byte[] array1, byte[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public boolean isSameLength(double[] array1, double[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public boolean isSameLength(float[] array1, float[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public boolean isSameLength(boolean[] array1, boolean[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0 || array1 != null && array2 != null && array1.length != array2.length);
    }

    public int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public boolean isSameType(Object array1, Object array2) {
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return array1.getClass().getName().equals(array2.getClass().getName());
    }

    public void reverse(Object[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public void reverse(long[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public void reverse(int[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public void reverse(short[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public void reverse(char[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public void reverse(double[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public void reverse(float[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public void reverse(boolean[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public int indexOf(Object[] array, Object objectToFind) {
        return this.indexOf(array, objectToFind, 0);
    }

    public int indexOf(Object[] array, Object objectToFind, int startIndex) {
        block5: {
            block4: {
                if (array == null) {
                    return -1;
                }
                if (startIndex < 0) {
                    startIndex = 0;
                }
                if (objectToFind != null) break block4;
                for (int i = startIndex; i < array.length; ++i) {
                    if (array[i] != null) continue;
                    return i;
                }
                break block5;
            }
            if (!array.getClass().getComponentType().isInstance(objectToFind)) break block5;
            for (int i = startIndex; i < array.length; ++i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object[] array, Object objectToFind) {
        return this.lastIndexOf(array, objectToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(Object[] array, Object objectToFind, int startIndex) {
        block6: {
            block5: {
                if (array == null) {
                    return -1;
                }
                if (startIndex < 0) {
                    return -1;
                }
                if (startIndex >= array.length) {
                    startIndex = array.length - 1;
                }
                if (objectToFind != null) break block5;
                for (int i = startIndex; i >= 0; --i) {
                    if (array[i] != null) continue;
                    return i;
                }
                break block6;
            }
            if (!array.getClass().getComponentType().isInstance(objectToFind)) break block6;
            for (int i = startIndex; i >= 0; --i) {
                if (!objectToFind.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean contains(Object[] array, Object objectToFind) {
        return this.indexOf(array, objectToFind) != -1;
    }

    public int indexOf(long[] array, long valueToFind) {
        return this.indexOf(array, valueToFind, 0);
    }

    public int indexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long[] array, long valueToFind) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(long[] array, long valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(long[] array, long valueToFind) {
        return this.indexOf(array, valueToFind) != -1;
    }

    public int indexOf(int[] array, int valueToFind) {
        return this.indexOf(array, valueToFind, 0);
    }

    public int indexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int[] array, int valueToFind) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(int[] array, int valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int[] array, int valueToFind) {
        return this.indexOf(array, valueToFind) != -1;
    }

    public int indexOf(short[] array, short valueToFind) {
        return this.indexOf(array, valueToFind, 0);
    }

    public int indexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short[] array, short valueToFind) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(short[] array, short valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(short[] array, short valueToFind) {
        return this.indexOf(array, valueToFind) != -1;
    }

    public int indexOf(char[] array, char valueToFind) {
        return this.indexOf(array, valueToFind, 0);
    }

    public int indexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char[] array, char valueToFind) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(char[] array, char valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(char[] array, char valueToFind) {
        return this.indexOf(array, valueToFind) != -1;
    }

    public int indexOf(byte[] array, byte valueToFind) {
        return this.indexOf(array, valueToFind, 0);
    }

    public int indexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte[] array, byte valueToFind) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(byte[] array, byte valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(byte[] array, byte valueToFind) {
        return this.indexOf(array, valueToFind) != -1;
    }

    public int indexOf(double[] array, double valueToFind) {
        return this.indexOf(array, valueToFind, 0);
    }

    public int indexOf(double[] array, double valueToFind, double tolerance) {
        return this.indexOf(array, valueToFind, 0, tolerance);
    }

    public int indexOf(double[] array, double valueToFind, int startIndex) {
        if (Util.arrayX.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (Util.arrayX.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double[] array, double valueToFind) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(double[] array, double valueToFind, double tolerance) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE, tolerance);
    }

    public int lastIndexOf(double[] array, double valueToFind, int startIndex) {
        if (Util.arrayX.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double[] array, double valueToFind, int startIndex, double tolerance) {
        if (Util.arrayX.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        double min = valueToFind - tolerance;
        double max = valueToFind + tolerance;
        for (int i = startIndex; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(double[] array, double valueToFind) {
        return this.indexOf(array, valueToFind) != -1;
    }

    public boolean contains(double[] array, double valueToFind, double tolerance) {
        return this.indexOf(array, valueToFind, 0, tolerance) != -1;
    }

    public int indexOf(float[] array, float valueToFind) {
        return this.indexOf(array, valueToFind, 0);
    }

    public int indexOf(float[] array, float valueToFind, int startIndex) {
        if (Util.arrayX.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float[] array, float valueToFind) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(float[] array, float valueToFind, int startIndex) {
        if (Util.arrayX.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(float[] array, float valueToFind) {
        return this.indexOf(array, valueToFind) != -1;
    }

    public int indexOf(boolean[] array, boolean valueToFind) {
        return this.indexOf(array, valueToFind, 0);
    }

    public int indexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (Util.arrayX.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(boolean[] array, boolean valueToFind) {
        return this.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public int lastIndexOf(boolean[] array, boolean valueToFind, int startIndex) {
        if (Util.arrayX.isEmpty(array)) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (valueToFind != array[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(boolean[] array, boolean valueToFind) {
        return this.indexOf(array, valueToFind) != -1;
    }

    public char[] toPrimitive(Character[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public char[] toPrimitive(Character[] array, char valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            Character b = array[i];
            result[i] = b == null ? valueForNull : b.charValue();
        }
        return result;
    }

    public Character[] toObject(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Character(array[i]);
        }
        return result;
    }

    public long[] toPrimitive(Long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public long[] toPrimitive(Long[] array, long valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            Long b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public Long[] toObject(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Long(array[i]);
        }
        return result;
    }

    public int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public int[] toPrimitive(Integer[] array, int valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            Integer b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public Integer[] toObject(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public short[] toPrimitive(Short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public short[] toPrimitive(Short[] array, short valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            Short b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public Short[] toObject(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public byte[] toPrimitive(Byte[] array, byte valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            Byte b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public Byte[] toObject(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public double[] toPrimitive(Double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public double[] toPrimitive(Double[] array, double valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            Double b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public Double[] toObject(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public float[] toPrimitive(Float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public float[] toPrimitive(Float[] array, float valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            Float b = array[i];
            result[i] = b == null ? valueForNull : b.floatValue();
        }
        return result;
    }

    public Float[] toObject(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public boolean[] toPrimitive(Boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public boolean[] toPrimitive(Boolean[] array, boolean valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            Boolean b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public Boolean[] toObject(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return result;
    }

    public boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public boolean isNotEmpty(Object[] array) {
        return array != null && array.length != 0;
    }

    public boolean isNotEmpty(long[] array) {
        return array != null && array.length != 0;
    }

    public boolean isNotEmpty(int[] array) {
        return array != null && array.length != 0;
    }

    public boolean isNotEmpty(short[] array) {
        return array != null && array.length != 0;
    }

    public boolean isNotEmpty(char[] array) {
        return array != null && array.length != 0;
    }

    public boolean isNotEmpty(byte[] array) {
        return array != null && array.length != 0;
    }

    public boolean isNotEmpty(double[] array) {
        return array != null && array.length != 0;
    }

    public boolean isNotEmpty(float[] array) {
        return array != null && array.length != 0;
    }

    public boolean isNotEmpty(boolean[] array) {
        return array != null && array.length != 0;
    }

    public Object[] addAll(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        try {
            System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        }
        catch (ArrayStoreException ase) {
            Class<?> type1 = array1.getClass().getComponentType();
            Class<?> type2 = array2.getClass().getComponentType();
            if (!type1.isAssignableFrom(type2)) {
                throw new IllegalArgumentException("Cannot store " + type2.getName() + " in an array of " + type1.getName());
            }
            throw ase;
        }
        return joinedArray;
    }

    public boolean[] addAll(boolean[] array1, boolean[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        boolean[] joinedArray = new boolean[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public char[] addAll(char[] array1, char[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        char[] joinedArray = new char[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public byte[] addAll(byte[] array1, byte[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public short[] addAll(short[] array1, short[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        short[] joinedArray = new short[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public int[] addAll(int[] array1, int[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        int[] joinedArray = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public long[] addAll(long[] array1, long[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        long[] joinedArray = new long[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public float[] addAll(float[] array1, float[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        float[] joinedArray = new float[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public double[] addAll(double[] array1, double[] array2) {
        if (array1 == null) {
            return this.clone(array2);
        }
        if (array2 == null) {
            return this.clone(array1);
        }
        double[] joinedArray = new double[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public Object[] add(Object[] array, Object element) {
        Class<Object> type = array != null ? array.getClass() : (element != null ? element.getClass() : Object.class);
        Object[] newArray = (Object[])this.copyArrayGrow1(array, type);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public boolean[] add(boolean[] array, boolean element) {
        boolean[] newArray = (boolean[])this.copyArrayGrow1(array, Boolean.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public byte[] add(byte[] array, byte element) {
        byte[] newArray = (byte[])this.copyArrayGrow1(array, Byte.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public char[] add(char[] array, char element) {
        char[] newArray = (char[])this.copyArrayGrow1(array, Character.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public double[] add(double[] array, double element) {
        double[] newArray = (double[])this.copyArrayGrow1(array, Double.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public float[] add(float[] array, float element) {
        float[] newArray = (float[])this.copyArrayGrow1(array, Float.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public int[] add(int[] array, int element) {
        int[] newArray = (int[])this.copyArrayGrow1(array, Integer.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public long[] add(long[] array, long element) {
        long[] newArray = (long[])this.copyArrayGrow1(array, Long.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public short[] add(short[] array, short element) {
        short[] newArray = (short[])this.copyArrayGrow1(array, Short.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    private Object copyArrayGrow1(Object array, Class newArrayComponentType) {
        if (array != null) {
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
            return newArray;
        }
        return Array.newInstance(newArrayComponentType, 1);
    }

    public Object[] add(Object[] array, int index, Object element) {
        Class<?> clss = null;
        if (array != null) {
            clss = array.getClass().getComponentType();
        } else if (element != null) {
            clss = element.getClass();
        } else {
            return new Object[]{null};
        }
        return (Object[])this.add(array, index, element, clss);
    }

    public <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        T[] result = this.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public char[] add(char[] array, int index, char element) {
        return (char[])this.add(array, index, Character.valueOf(element), Character.TYPE);
    }

    public byte[] add(byte[] array, int index, byte element) {
        return (byte[])this.add(array, index, element, Byte.TYPE);
    }

    public short[] add(short[] array, int index, short element) {
        return (short[])this.add(array, index, element, Short.TYPE);
    }

    public int[] add(int[] array, int index, int element) {
        return (int[])this.add(array, index, element, Integer.TYPE);
    }

    public long[] add(long[] array, int index, long element) {
        return (long[])this.add(array, index, element, Long.TYPE);
    }

    public float[] add(float[] array, int index, float element) {
        return (float[])this.add(array, index, Float.valueOf(element), Float.TYPE);
    }

    public double[] add(double[] array, int index, double element) {
        return (double[])this.add(array, index, new Double(element), Double.TYPE);
    }

    private Object add(Object array, int index, Object element, Class clss) {
        if (array == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Length: 0");
            }
            Object joinedArray = Array.newInstance(clss, 1);
            Array.set(joinedArray, 0, element);
            return joinedArray;
        }
        int length = Array.getLength(array);
        if (index > length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(clss, length + 1);
        System.arraycopy(array, 0, result, 0, index);
        Array.set(result, index, element);
        if (index < length) {
            System.arraycopy(array, index, result, index + 1, length - index);
        }
        return result;
    }

    public Object[] remove(Object[] array, int index) {
        return (Object[])this.remove((Object)array, index);
    }

    public Object[] removeElement(Object[] array, Object element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    public boolean[] remove(boolean[] array, int index) {
        return (boolean[])this.remove((Object)array, index);
    }

    public boolean[] removeElement(boolean[] array, boolean element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    public byte[] remove(byte[] array, int index) {
        return (byte[])this.remove((Object)array, index);
    }

    public byte[] removeElement(byte[] array, byte element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    public char[] remove(char[] array, int index) {
        return (char[])this.remove((Object)array, index);
    }

    public char[] removeElement(char[] array, char element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    public double[] remove(double[] array, int index) {
        return (double[])this.remove((Object)array, index);
    }

    public double[] removeElement(double[] array, double element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    public float[] remove(float[] array, int index) {
        return (float[])this.remove((Object)array, index);
    }

    public float[] removeElement(float[] array, float element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    public int[] remove(int[] array, int index) {
        return (int[])this.remove((Object)array, index);
    }

    public int[] removeElement(int[] array, int element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    public long[] remove(long[] array, int index) {
        return (long[])this.remove((Object)array, index);
    }

    public long[] removeElement(long[] array, long element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    public short[] remove(short[] array, int index) {
        return (short[])this.remove((Object)array, index);
    }

    public short[] removeElement(short[] array, short element) {
        int index = this.indexOf(array, element);
        if (index == -1) {
            return this.clone(array);
        }
        return this.remove(array, index);
    }

    private Object remove(Object array, int index) {
        int length = this.getLength(array);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }
}

