/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.util.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class Dom4jXml {
    public Document createEmptyXmlFile(String xmlPath) {
        if (xmlPath == null || xmlPath.equals("")) {
            return null;
        }
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        try {
            XMLWriter output = new XMLWriter((Writer)new FileWriter(xmlPath), format);
            output.write(document);
            output.close();
        }
        catch (IOException e) {
            return null;
        }
        return document;
    }

    public Document getDocument(String xmlPath) {
        if (xmlPath == null || xmlPath.equals("")) {
            return null;
        }
        File file = new File(xmlPath);
        if (!file.exists()) {
            return this.createEmptyXmlFile(xmlPath);
        }
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(xmlPath);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return document;
    }

    public Element getRootNode(Document document) {
        if (document == null) {
            return null;
        }
        return document.getRootElement();
    }

    public Element getRootNode(String xmlPath) {
        if (xmlPath == null || xmlPath.trim().equals("")) {
            return null;
        }
        Document document = this.getDocument(xmlPath);
        if (document == null) {
            return null;
        }
        return this.getRootNode(document);
    }

    public Iterator<Element> getIterator(Element parent) {
        if (parent == null) {
            return null;
        }
        return parent.elementIterator();
    }

    public List<Element> getChildElements(Element parent, String childName) {
        childName = childName.trim();
        if (parent == null) {
            return null;
        }
        childName = childName + "//";
        return parent.selectNodes(childName);
    }

    public List<Element> getChildList(Element node) {
        if (node == null) {
            return null;
        }
        Iterator<Element> itr = this.getIterator(node);
        if (itr == null) {
            return null;
        }
        ArrayList<Element> childList = new ArrayList<Element>();
        while (itr.hasNext()) {
            Element kidElement = itr.next();
            if (kidElement == null) continue;
            childList.add(kidElement);
        }
        return childList;
    }

    public Node getSingleNode(Element parent, String nodeNodeName) {
        nodeNodeName = nodeNodeName.trim();
        String xpath = "//";
        if (parent == null) {
            return null;
        }
        if (nodeNodeName.equals("")) {
            return null;
        }
        xpath = xpath + nodeNodeName;
        return parent.selectSingleNode(xpath);
    }

    public Element getChild(Element parent, String childName) {
        childName = childName.trim();
        if (parent == null) {
            return null;
        }
        if (childName.equals("")) {
            return null;
        }
        Element e = null;
        Iterator<Element> it = this.getIterator(parent);
        while (it != null && it.hasNext()) {
            Element k = it.next();
            if (k == null || !k.getName().equalsIgnoreCase(childName)) continue;
            e = k;
            break;
        }
        return e;
    }

    public boolean hasChild(Element e) {
        if (e == null) {
            return false;
        }
        return e.hasContent();
    }

    public Iterator<Attribute> getAttrIterator(Element e) {
        if (e == null) {
            return null;
        }
        return e.attributeIterator();
    }

    public List<Attribute> getAttributeList(Element e) {
        if (e == null) {
            return null;
        }
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        Iterator<Attribute> atrIterator = this.getAttrIterator(e);
        if (atrIterator == null) {
            return null;
        }
        while (atrIterator.hasNext()) {
            Attribute attribute = atrIterator.next();
            attributeList.add(attribute);
        }
        return attributeList;
    }

    public Attribute getAttribute(Element element, String attrName) {
        attrName = attrName.trim();
        if (element == null) {
            return null;
        }
        if (attrName.equals("")) {
            return null;
        }
        return element.attribute(attrName);
    }

    public String attrValue(Element e, String attrName) {
        attrName = attrName.trim();
        if (e == null) {
            return null;
        }
        if (attrName.equals("")) {
            return null;
        }
        return e.attributeValue(attrName);
    }

    public Map<String, String> getNodeAttrMap(Element e) {
        HashMap<String, String> attrMap = new HashMap<String, String>();
        if (e == null) {
            return null;
        }
        List<Attribute> attributes = this.getAttributeList(e);
        if (attributes == null) {
            return null;
        }
        for (Attribute attribute : attributes) {
            String attrValueString = this.attrValue(e, attribute.getName());
            attrMap.put(attribute.getName(), attrValueString);
        }
        return attrMap;
    }

    public Map<String, String> getSingleNodeText(Element e) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (e == null) {
            return null;
        }
        List<Element> kids = this.getChildList(e);
        for (Element e2 : kids) {
            if (e2.getTextTrim() == null) continue;
            map.put(e2.getName(), e2.getTextTrim());
        }
        return map;
    }

    public Map<String, String> getSingleNodeText(String xmlFilePath) {
        if ((xmlFilePath = xmlFilePath.trim()).equals("")) {
            return null;
        }
        Element rootElement = this.getRootNode(xmlFilePath);
        if (rootElement == null || !this.hasChild(rootElement)) {
            return null;
        }
        return this.getSingleNodeText(rootElement);
    }

    public <T> T getNameNode(String xmlFilePath, String tagName, Flag flag) {
        xmlFilePath = xmlFilePath.trim();
        tagName = tagName.trim();
        if (xmlFilePath.equals("") || tagName.equals("")) {
            return null;
        }
        Element rootElement = this.getRootNode(xmlFilePath);
        if (rootElement == null) {
            return null;
        }
        List<Element> tagElementList = this.getNameElement(rootElement, tagName);
        if (tagElementList == null) {
            return null;
        }
        switch (flag) {
            case one: {
                return (T)tagElementList.get(0);
            }
        }
        return (T)tagElementList;
    }

    public Map<Integer, Object> getNameNodeAllKidsAttributeMap(Element parent) {
        HashMap<Integer, Object> allAttrMap = new HashMap<Integer, Object>();
        if (parent == null) {
            return null;
        }
        List<Element> childlElements = this.getChildList(parent);
        if (childlElements == null) {
            return null;
        }
        for (int i = 0; i < childlElements.size(); ++i) {
            Element childElement = childlElements.get(i);
            Map<String, String> attrMap = this.getNodeAttrMap(childElement);
            allAttrMap.put(i, attrMap);
        }
        return allAttrMap;
    }

    public <T> T getNameNodeAllAttributeMap(String xmlFilePath, String nodeName, Flag flag) {
        nodeName = nodeName.trim();
        HashMap<Integer, Map<String, String>> mostKidsAllAttriMap = new HashMap<Integer, Map<String, String>>();
        if (xmlFilePath == null || xmlFilePath.equals("") || nodeName.equals("")) {
            return null;
        }
        switch (flag) {
            case one: {
                Element nameNode = (Element)this.getNameNode(xmlFilePath, nodeName, Flag.one);
                Map<String, String> allAttrMap = this.getNodeAttrMap(nameNode);
                return (T)allAttrMap;
            }
            case more: {
                List nameKidsElements = (List)this.getNameNode(xmlFilePath, nodeName, Flag.more);
                for (int i = 0; i < nameKidsElements.size(); ++i) {
                    Element kid = (Element)nameKidsElements.get(i);
                    Map<String, String> allAttrMap = this.getNodeAttrMap(kid);
                    mostKidsAllAttriMap.put(i, allAttrMap);
                }
                return (T)mostKidsAllAttriMap;
            }
        }
        return null;
    }

    public List<Element> ransack(Element element, List<Element> allkidsList) {
        if (element == null) {
            return null;
        }
        if (this.hasChild(element)) {
            List<Element> kids = this.getChildList(element);
            for (Element e : kids) {
                allkidsList.add(e);
                this.ransack(e, allkidsList);
            }
        }
        return allkidsList;
    }

    public List<Element> getNameElement(Element element, String nodeName) {
        nodeName = nodeName.trim();
        ArrayList<Element> kidsElements = new ArrayList<Element>();
        if (element == null) {
            return null;
        }
        if (nodeName.equals("")) {
            return null;
        }
        List<Element> allKids = this.ransack(element, new ArrayList<Element>());
        if (allKids == null) {
            return null;
        }
        for (Element kid : allKids) {
            if (!nodeName.equals(kid.getName())) continue;
            kidsElements.add(kid);
        }
        return kidsElements;
    }

    public int validateSingle(Element element) {
        int j = 1;
        if (element == null) {
            return j;
        }
        Element parent = element.getParent();
        List<Element> kids = this.getChildList(parent);
        for (Element kid : kids) {
            if (!element.equals(kid)) continue;
            ++j;
        }
        return j;
    }

    public static enum Flag {
        one,
        more;

    }
}

