/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.util.properties;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.wuwenbin.tools.util.Util;

public final class Properties {
    private static final String UTF_8 = "UTF-8";
    private static final ConcurrentMap<String, java.util.Properties> PROPS = new ConcurrentHashMap<String, java.util.Properties>();

    public String getProperty(String filePath, String name) {
        if (Util.stringX.isBlank(filePath) || Util.stringX.isBlank(name)) {
            throw new IllegalArgumentException("The parameters must not be null");
        }
        try {
            java.util.Properties prop = (java.util.Properties)PROPS.get(filePath);
            if (prop == null) {
                prop = new java.util.Properties();
                prop.load(new InputStreamReader(Properties.class.getResourceAsStream(filePath), UTF_8));
                PROPS.put(filePath, prop);
            }
            return prop.getProperty(name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getProperty(String filePath, String name, String defaultValue) {
        if (Util.stringX.isBlank(filePath) || Util.stringX.isBlank(name) || Util.stringX.isBlank(defaultValue)) {
            throw new IllegalArgumentException("The parameters must not be null");
        }
        try {
            String value;
            java.util.Properties prop = (java.util.Properties)PROPS.get(filePath);
            if (prop == null) {
                prop = new java.util.Properties();
                prop.load(new InputStreamReader(Properties.class.getResourceAsStream(filePath), UTF_8));
                PROPS.put(filePath, prop);
            }
            return Util.stringX.isBlank(value = prop.getProperty(name)) ? defaultValue : value;
        }
        catch (IOException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

