/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.util.lang;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import me.wuwenbin.tools.util.Util;
import me.wuwenbin.tools.util.exception.LangException;

public class NumberX {
    private final int DEFAULT_DIV_SCALE = 10;

    public double add(double v1, double v2) {
        return this.add(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public BigDecimal add(String v1, String v2) {
        return this.add(new BigDecimal(v1), new BigDecimal(v2));
    }

    public BigDecimal add(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.add(v2);
        }
        throw new LangException("2\u4e2a\u53c2\u6570\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public double sub(double v1, double v2) {
        return this.sub(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public BigDecimal sub(String v1, String v2) {
        return this.sub(new BigDecimal(v1), new BigDecimal(v2));
    }

    public BigDecimal sub(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.subtract(v2);
        }
        throw new LangException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public double mul(double v1, double v2) {
        return this.mul(Double.toString(v1), Double.toString(v2)).doubleValue();
    }

    public BigDecimal mul(String v1, String v2) {
        return this.mul(new BigDecimal(v1), new BigDecimal(v2));
    }

    public BigDecimal mul(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.multiply(v2);
        }
        throw new LangException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public double div(double v1, double v2) {
        return this.div(v1, v2, 10);
    }

    public BigDecimal div(String v1, String v2) {
        return this.div(v1, v2, 10);
    }

    public double div(double v1, double v2, int scale) {
        return this.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public BigDecimal div(String v1, String v2, int scale) {
        return this.div(v1, v2, scale, RoundingMode.HALF_UP);
    }

    public double div(double v1, double v2, int scale, RoundingMode roundingMode) {
        return this.div(Double.toString(v1), Double.toString(v2), scale, roundingMode).doubleValue();
    }

    public BigDecimal div(String v1, String v2, int scale, RoundingMode roundingMode) {
        return this.div(new BigDecimal(v1), new BigDecimal(v1), scale, roundingMode);
    }

    public BigDecimal div(BigDecimal v1, BigDecimal v2, int scale, RoundingMode roundingMode) {
        if (v1 != null && v2 != null) {
            if (scale < 0) {
                scale = -scale;
            }
            return v1.divide(v2, scale, roundingMode);
        }
        throw new LangException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public double round(double v, int scale) {
        return this.round(v, scale, RoundingMode.HALF_UP);
    }

    public double round(String numberStr, int scale) {
        return this.round(numberStr, scale, RoundingMode.HALF_UP);
    }

    public double round(double v, int scale, RoundingMode roundingMode) {
        return this.round(Double.toString(v), scale, roundingMode);
    }

    public double round(String numberStr, int scale, RoundingMode roundingMode) {
        BigDecimal b = new BigDecimal(numberStr);
        return b.setScale(scale, roundingMode).doubleValue();
    }

    public String roundStr(double number, int digit) {
        return String.format("%." + digit + 'f', number);
    }

    public String decimalFormat(String pattern, double value) {
        return new DecimalFormat(pattern).format(value);
    }

    public String decimalFormat(String pattern, long value) {
        return new DecimalFormat(pattern).format(value);
    }

    public String decimalFormatMoney(Double value) {
        return this.decimalFormat(",###", value);
    }

    public boolean isNumber(String str) {
        int i;
        int start;
        if (Util.stringX.isBlank(str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }

    public boolean isInteger(String s) {
        if (Util.stringX.isNotBlank(s)) {
            return s.matches("^\\d+$");
        }
        return false;
    }

    public boolean isDouble(String s) {
        try {
            Double.parseDouble(s);
            return s.contains(".");
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean isPrimes(int n) {
        int i = 2;
        while ((double)i <= Math.sqrt(n)) {
            if (n % i == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int[] generateRandomNumber(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new LangException("Size is larger than range between begin and end!");
        }
        int[] seed = new int[end - begin];
        for (int i = begin; i < end; ++i) {
            seed[i - begin] = i;
        }
        int[] ranArr = new int[size];
        Random ran = new Random();
        for (int i = 0; i < size; ++i) {
            int j = ran.nextInt(seed.length - i);
            ranArr[i] = seed[j];
            seed[j] = seed[seed.length - 1 - i];
        }
        return ranArr;
    }

    public Integer[] generateBySet(int begin, int end, int size) {
        if (begin > end) {
            int temp = begin;
            begin = end;
            end = temp;
        }
        if (end - begin < size) {
            throw new LangException("Size is larger than range between begin and end!");
        }
        Random ran = new Random();
        HashSet<Integer> set = new HashSet<Integer>();
        while (set.size() < size) {
            set.add(begin + ran.nextInt(end - begin));
        }
        Integer[] ranArr = set.toArray(new Integer[size]);
        return ranArr;
    }

    public int[] range(int start, int stop) {
        return this.range(start, stop, 1);
    }

    public int[] range(int start, int stop, int step) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            return new int[]{start};
        }
        int size = Math.abs((stop - start) / step) + 1;
        int[] values = new int[size];
        int index = 0;
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values[index] = i;
            ++index;
            i += step;
        }
        return values;
    }

    public Collection<Integer> appendRange(int start, int stop, Collection<Integer> values) {
        return this.appendRange(start, stop, 1, values);
    }

    public Collection<Integer> appendRange(int start, int stop, int step, Collection<Integer> values) {
        if (start < stop) {
            step = Math.abs(step);
        } else if (start > stop) {
            step = -Math.abs(step);
        } else {
            values.add(start);
            return values;
        }
        int i = start;
        while (step > 0 ? i <= stop : i >= stop) {
            values.add(i);
            i += step;
        }
        return values;
    }

    public int factorial(int n) {
        if (n == 1) {
            return 1;
        }
        return n * this.factorial(n - 1);
    }

    public long sqrt(long x) {
        long y = 0L;
        for (long b = 0x4000000000000000L; b > 0L; b >>= 2) {
            if (x >= y + b) {
                x -= y + b;
                y >>= 1;
                y += b;
                continue;
            }
            y >>= 1;
        }
        return y;
    }

    public int processMultiple(int selectNum, int minNum) {
        int result = this.mathSubnode(selectNum, minNum) / this.mathNode(selectNum - minNum);
        return result;
    }

    public int divisor(int m, int n) {
        while (m % n != 0) {
            int temp = m % n;
            m = n;
            n = temp;
        }
        return n;
    }

    public int multiple(int m, int n) {
        return m * n / this.divisor(m, n);
    }

    public String getBinaryStr(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public int binaryToInt(String binaryStr) {
        return Integer.parseInt(binaryStr, 2);
    }

    public long binaryToLong(String binaryStr) {
        return Long.parseLong(binaryStr, 2);
    }

    public int compare(char x, char y) {
        return x - y;
    }

    public int compare(double x, double y) {
        return Double.compare(x, y);
    }

    public int compare(int x, int y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public int compare(long x, long y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public int compare(short x, short y) {
        if (x == y) {
            return 0;
        }
        if (x < y) {
            return -1;
        }
        return 1;
    }

    public int compare(byte x, byte y) {
        return x - y;
    }

    public boolean isGreater(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 != null && bigNum2 != null) {
            return bigNum1.compareTo(bigNum2) > 0;
        }
        throw new LangException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public boolean isGreaterOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 != null && bigNum2 != null) {
            return bigNum1.compareTo(bigNum2) >= 0;
        }
        throw new LangException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public boolean isLess(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 != null && bigNum2 != null) {
            return bigNum1.compareTo(bigNum2) < 0;
        }
        throw new LangException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public boolean isLessOrEqual(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 != null && bigNum2 != null) {
            return bigNum1.compareTo(bigNum2) <= 0;
        }
        throw new LangException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public boolean equals(BigDecimal bigNum1, BigDecimal bigNum2) {
        if (bigNum1 != null && bigNum2 != null) {
            return bigNum1.equals(bigNum2);
        }
        throw new LangException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public boolean isBlankChar(char c) {
        return this.isBlankChar((int)c);
    }

    public boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    public int count(int total, int part) {
        return total % part == 0 ? total / part : total / part + 1;
    }

    public BigDecimal null2Zero(BigDecimal decimal) {
        return decimal == null ? BigDecimal.ZERO : decimal;
    }

    private int mathSubnode(int selectNum, int minNum) {
        if (selectNum == minNum) {
            return 1;
        }
        return selectNum * this.mathSubnode(selectNum - 1, minNum);
    }

    private int mathNode(int selectNum) {
        if (selectNum == 0) {
            return 1;
        }
        return selectNum * this.mathNode(selectNum - 1);
    }
}

