/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.http.apache.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class SSLx {
    private static final SSLHandler simpleVerifier = new SSLHandler();
    private static SSLSocketFactory sslFactory;
    private static SSLConnectionSocketFactory sslConnFactory;
    private static SSLIOSessionStrategy sslIOSessionStrategy;
    private static SSLx sslx;
    private SSLContext sc;

    public static SSLx getInstance() {
        return sslx;
    }

    public static SSLx custom() {
        return new SSLx();
    }

    public static HostnameVerifier getVerifier() {
        return simpleVerifier;
    }

    public synchronized SSLSocketFactory getSSLSF(SSLProtocolVersion sslProtocolVersion) throws Exception {
        if (sslFactory != null) {
            return sslFactory;
        }
        SSLContext sc = this.getSSLContext(sslProtocolVersion);
        sc.init(null, new TrustManager[]{simpleVerifier}, null);
        sslFactory = sc.getSocketFactory();
        return sslFactory;
    }

    public synchronized SSLConnectionSocketFactory getSSLCONNSF(SSLProtocolVersion sslProtocolVersion) throws Exception {
        if (sslConnFactory != null) {
            return sslConnFactory;
        }
        SSLContext sc = this.getSSLContext(sslProtocolVersion);
        sc.init(null, new TrustManager[]{simpleVerifier}, new SecureRandom());
        sslConnFactory = new SSLConnectionSocketFactory(sc, (HostnameVerifier)simpleVerifier);
        return sslConnFactory;
    }

    public synchronized SSLIOSessionStrategy getSSLIOSS(SSLProtocolVersion sslpv) throws Exception {
        if (sslIOSessionStrategy != null) {
            return sslIOSessionStrategy;
        }
        SSLContext sc = this.getSSLContext(sslpv);
        sc.init(null, new TrustManager[]{simpleVerifier}, new SecureRandom());
        sslIOSessionStrategy = new SSLIOSessionStrategy(sc, (HostnameVerifier)simpleVerifier);
        return sslIOSessionStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLx customSSL(String keyStorePath, String keyStorepass) throws Exception {
        try (FileInputStream inseam = null;){
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            inseam = new FileInputStream(new File(keyStorePath));
            trustStore.load(inseam, keyStorepass.toCharArray());
            this.sc = SSLContexts.custom().loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        return this;
    }

    public SSLContext getSSLContext(SSLProtocolVersion sslpv) throws NoSuchAlgorithmException {
        if (this.sc == null) {
            this.sc = SSLContext.getInstance(sslpv.getName());
        }
        return this.sc;
    }

    static {
        sslx = new SSLx();
    }

    public static enum SSLProtocolVersion {
        SSL("SSL"),
        SSLv3("SSLv3"),
        TLSv1("TLSv1"),
        TLSv1_1("TLSv1.1"),
        TLSv1_2("TLSv1.2");

        private String name;

        private SSLProtocolVersion(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SSLProtocolVersion find(String name) {
            for (SSLProtocolVersion pv : SSLProtocolVersion.values()) {
                if (!pv.getName().toUpperCase().equals(name.toUpperCase())) continue;
                return pv;
            }
            throw new RuntimeException("\u672a\u652f\u6301\u5f53\u524dssl\u7248\u672c\u53f7\uff1a" + name);
        }
    }

    private static class SSLHandler
    implements X509TrustManager,
    HostnameVerifier {
        private SSLHandler() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public boolean verify(String paramString, SSLSession paramSSLSession) {
            return true;
        }
    }
}

