/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.http.apache.config.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import me.wuwenbin.tools.http.apache.util.SSLx;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;

public class TemplateHttpClientBuilder
extends HttpClientBuilder {
    private boolean isSetPool = false;
    private SSLx.SSLProtocolVersion sslVersion = SSLx.SSLProtocolVersion.SSLv3;
    private SSLx sslx = SSLx.getInstance();

    private TemplateHttpClientBuilder() {
    }

    public static TemplateHttpClientBuilder init() {
        return new TemplateHttpClientBuilder();
    }

    public boolean isSetPool() {
        return this.isSetPool;
    }

    public void setSetPool(boolean setPool) {
        this.isSetPool = setPool;
    }

    public TemplateHttpClientBuilder timeout(int timeout) {
        return this.timeout(timeout, true);
    }

    public TemplateHttpClientBuilder timeout(int timeout, boolean redirectEnable) {
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).setRedirectsEnabled(redirectEnable).build();
        return (TemplateHttpClientBuilder)this.setDefaultRequestConfig(config);
    }

    public TemplateHttpClientBuilder ssl() throws Exception {
        return (TemplateHttpClientBuilder)this.setSSLSocketFactory((LayeredConnectionSocketFactory)this.sslx.getSSLCONNSF(this.sslVersion));
    }

    public TemplateHttpClientBuilder ssl(String keyStorePath) throws Exception {
        return this.ssl(keyStorePath, "nopassword");
    }

    public TemplateHttpClientBuilder ssl(String keyStorePath, String keyStorepass) throws Exception {
        this.sslx = SSLx.custom().customSSL(keyStorePath, keyStorepass);
        return this.ssl();
    }

    public TemplateHttpClientBuilder pool(int maxTotal, int defaultMaxPerRoute) throws Exception {
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)this.sslx.getSSLCONNSF(this.sslVersion)).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connManager.setMaxTotal(maxTotal);
        connManager.setDefaultMaxPerRoute(defaultMaxPerRoute);
        this.isSetPool = true;
        return (TemplateHttpClientBuilder)this.setConnectionManager((HttpClientConnectionManager)connManager);
    }

    public TemplateHttpClientBuilder proxy(String hostOrIP, int port) {
        HttpHost proxy = new HttpHost(hostOrIP, port, "http");
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        return (TemplateHttpClientBuilder)this.setRoutePlanner((HttpRoutePlanner)routePlanner);
    }

    public TemplateHttpClientBuilder retry(int tryTimes) {
        return this.retry(tryTimes, false);
    }

    public TemplateHttpClientBuilder retry(final int tryTimes, final boolean retryWhenInterruptedIO) {
        HttpRequestRetryHandler httpRequestRetryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= tryTimes) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return retryWhenInterruptedIO;
                }
                if (exception instanceof UnknownHostException) {
                    return true;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        this.setRetryHandler(httpRequestRetryHandler);
        return this;
    }

    public TemplateHttpClientBuilder sslpv(String s) {
        return this.sslpv(SSLx.SSLProtocolVersion.find(s));
    }

    public TemplateHttpClientBuilder sslpv(SSLx.SSLProtocolVersion sslProtocolVersion) {
        this.sslVersion = sslProtocolVersion;
        return this;
    }
}

