/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.http.apache.config;

import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import me.wuwenbin.tools.http.apache.config.method.HttpMethod;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;

public class HttpApacheConfig {
    private HttpClient client;
    private Header[] headers;
    private boolean isReturnRespHeaders;
    private HttpMethod method = HttpMethod.GET;
    private String methodName;
    private HttpContext context;
    private Map<String, Object> map;
    private String json;
    private String encoding = Charset.defaultCharset().displayName();
    private String inenc;
    private String outenc;
    private static final ThreadLocal<OutputStream> outs = new ThreadLocal();
    private static final ThreadLocal<String> urls = new ThreadLocal();

    private HttpApacheConfig() {
    }

    public static HttpApacheConfig init() {
        return new HttpApacheConfig();
    }

    public HttpApacheConfig client(HttpClient client) {
        this.client = client;
        return this;
    }

    public HttpApacheConfig url(String url) {
        urls.set(url);
        return this;
    }

    public HttpApacheConfig headers(Header[] headers) {
        this.headers = headers;
        return this;
    }

    public HttpApacheConfig headers(Header[] headers, boolean isReturnRespHeaders) {
        this.headers = headers;
        this.isReturnRespHeaders = isReturnRespHeaders;
        return this;
    }

    public HttpApacheConfig method(HttpMethod method) {
        this.method = method;
        return this;
    }

    public HttpApacheConfig methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public HttpApacheConfig context(HttpContext context) {
        this.context = context;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpApacheConfig params(Map<String, Object> map) {
        HttpApacheConfig httpApacheConfig = this;
        synchronized (httpApacheConfig) {
            if (this.map == null || map == null) {
                this.map = map;
            } else {
                this.map.putAll(map);
            }
        }
        return this;
    }

    public HttpApacheConfig json(String json) {
        this.json = json;
        this.map = new HashMap<String, Object>();
        this.map.put("$ENTITY_STRING$", json);
        return this;
    }

    public HttpApacheConfig files(String[] filePaths) {
        return this.files(filePaths, "file");
    }

    public HttpApacheConfig files(String[] filePaths, String inputName) {
        return this.files(filePaths, inputName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpApacheConfig files(String[] filePaths, String inputName, boolean forceRemoveContentTypeChraset) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (this.map == null) {
                this.map = new HashMap<String, Object>();
            }
        }
        this.map.put("$ENTITY_MULTIPART$", filePaths);
        this.map.put("$ENTITY_MULTIPART$.name", inputName);
        this.map.put("$ENTITY_MULTIPART$.rmCharset", forceRemoveContentTypeChraset);
        return this;
    }

    public HttpApacheConfig encoding(String encoding) {
        this.inenc(encoding);
        this.outenc(encoding);
        this.encoding = encoding;
        return this;
    }

    public HttpApacheConfig inenc(String inenc) {
        this.inenc = inenc;
        return this;
    }

    public HttpApacheConfig outenc(String outenc) {
        this.outenc = outenc;
        return this;
    }

    public HttpApacheConfig out(OutputStream out) {
        outs.set(out);
        return this;
    }

    public HttpClient client() {
        return this.client;
    }

    public Header[] headers() {
        return this.headers;
    }

    public boolean isReturnRespHeaders() {
        return this.isReturnRespHeaders;
    }

    public String url() {
        return urls.get();
    }

    public HttpMethod method() {
        return this.method;
    }

    public String methodName() {
        return this.methodName;
    }

    public HttpContext context() {
        return this.context;
    }

    public Map<String, Object> params() {
        return this.map;
    }

    public String json() {
        return this.json;
    }

    public String encoding() {
        return this.encoding;
    }

    public String inenc() {
        return this.inenc == null ? this.encoding : this.inenc;
    }

    public String outenc() {
        return this.outenc == null ? this.encoding : this.outenc;
    }

    public OutputStream out() {
        return outs.get();
    }
}

