/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.tools.http.apache;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import me.wuwenbin.tools.http.apache.config.HttpApacheConfig;
import me.wuwenbin.tools.http.apache.config.client.TemplateHttpClientBuilder;
import me.wuwenbin.tools.http.apache.config.method.HttpMethod;
import me.wuwenbin.tools.http.apache.util.ApacheHttpUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class ApacheHttp {
    private static HttpClient client4HTTP;
    private static HttpClient client4HTTPS;

    private void create(HttpApacheConfig config) throws Exception {
        if (config.client() == null) {
            if (config.url().toLowerCase().startsWith("https://")) {
                config.client(client4HTTPS);
            } else {
                config.client(client4HTTP);
            }
        }
    }

    public String get(String url) throws Exception {
        return this.get(HttpApacheConfig.init().url(url));
    }

    public String get(String url, Header[] headers) throws Exception {
        return this.get(HttpApacheConfig.init().url(url).headers(headers));
    }

    public String get(String url, Map<String, Object> paramMap) throws Exception {
        return this.get(HttpApacheConfig.init().url(url).params(paramMap));
    }

    public String get(String url, Header[] headers, Map<String, Object> paramMap) throws Exception {
        return this.get(HttpApacheConfig.init().url(url).headers(headers).params(paramMap));
    }

    public String get(String url, Map<String, Object> paramMap, String encoding) throws Exception {
        return this.get(HttpApacheConfig.init().url(url).params(paramMap).encoding(encoding));
    }

    public String get(String url, Header[] headers, Map<String, Object> paramMap, String encoding) throws Exception {
        return this.get(HttpApacheConfig.init().url(url).headers(headers).params(paramMap).encoding(encoding));
    }

    public String get(String url, String encoding) throws Exception {
        return this.get(HttpApacheConfig.init().url(url).encoding(encoding));
    }

    public String get(String url, Header[] headers, String encoding) throws Exception {
        return this.get(HttpApacheConfig.init().url(url).headers(headers).encoding(encoding));
    }

    public String get(HttpClient client, String url, Header[] headers, Map<String, Object> paramMap, HttpContext context, String encoding) throws Exception {
        return this.get(HttpApacheConfig.init().client(client).url(url).headers(headers).params(paramMap).context(context).encoding(encoding));
    }

    public String get(HttpApacheConfig config) throws Exception {
        return this.send(config.method(HttpMethod.GET));
    }

    public String post(String url) throws Exception {
        return this.post(HttpApacheConfig.init().url(url));
    }

    public String post(String url, Header[] headers) throws Exception {
        return this.post(HttpApacheConfig.init().url(url).headers(headers));
    }

    public String post(String url, Map<String, Object> paramMap) throws Exception {
        return this.post(HttpApacheConfig.init().url(url).params(paramMap));
    }

    public String post(String url, Header[] headers, Map<String, Object> paramMap) throws Exception {
        return this.post(HttpApacheConfig.init().url(url).headers(headers).params(paramMap));
    }

    public String post(String url, Map<String, Object> paramMap, String encoding) throws Exception {
        return this.post(HttpApacheConfig.init().url(url).params(paramMap).encoding(encoding));
    }

    public String post(String url, Header[] headers, Map<String, Object> paramMap, String encoding) throws Exception {
        return this.post(HttpApacheConfig.init().url(url).headers(headers).params(paramMap).encoding(encoding));
    }

    public String post(String url, String encoding) throws Exception {
        return this.post(HttpApacheConfig.init().url(url).encoding(encoding));
    }

    public String post(String url, Header[] headers, String encoding) throws Exception {
        return this.post(HttpApacheConfig.init().url(url).headers(headers).encoding(encoding));
    }

    public String post(HttpClient client, String url, Header[] headers, Map<String, Object> paramMap, HttpContext context, String encoding) throws Exception {
        return this.post(HttpApacheConfig.init().client(client).url(url).headers(headers).params(paramMap).context(context).encoding(encoding));
    }

    public String post(HttpApacheConfig config) throws Exception {
        return this.send(config.method(HttpMethod.POST));
    }

    public String put(HttpClient client, String url, Map<String, Object> parasMap, Header[] headers, HttpContext context, String encoding) throws Exception {
        return this.put(HttpApacheConfig.init().client(client).url(url).headers(headers).params(parasMap).context(context).encoding(encoding));
    }

    public String put(HttpApacheConfig config) throws Exception {
        return this.send(config.method(HttpMethod.PUT));
    }

    public String delete(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws Exception {
        return this.delete(HttpApacheConfig.init().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public String delete(HttpApacheConfig config) throws Exception {
        return this.send(config.method(HttpMethod.DELETE));
    }

    public String patch(HttpClient client, String url, Map<String, Object> parasMap, Header[] headers, HttpContext context, String encoding) throws Exception {
        return this.patch(HttpApacheConfig.init().client(client).url(url).headers(headers).params(parasMap).context(context).encoding(encoding));
    }

    public String patch(HttpApacheConfig config) throws Exception {
        return this.send(config.method(HttpMethod.PATCH));
    }

    public String head(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws Exception {
        return this.head(HttpApacheConfig.init().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public String head(HttpApacheConfig config) throws Exception {
        return this.send(config.method(HttpMethod.HEAD));
    }

    public String options(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws Exception {
        return this.options(HttpApacheConfig.init().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public String options(HttpApacheConfig config) throws Exception {
        return this.send(config.method(HttpMethod.OPTIONS));
    }

    public String trace(HttpClient client, String url, Header[] headers, HttpContext context, String encoding) throws Exception {
        return this.trace(HttpApacheConfig.init().client(client).url(url).headers(headers).context(context).encoding(encoding));
    }

    public String trace(HttpApacheConfig config) throws Exception {
        return this.send(config.method(HttpMethod.TRACE));
    }

    public OutputStream down(HttpClient client, String url, Header[] headers, HttpContext context, OutputStream out) throws Exception {
        return this.down(HttpApacheConfig.init().client(client).url(url).headers(headers).context(context).out(out));
    }

    public OutputStream down(HttpApacheConfig config) throws Exception {
        return ApacheHttp.resp2Stream(this.execute(config.method(HttpMethod.GET)), config.out());
    }

    public String upload(HttpClient client, String url, Header[] headers, HttpContext context) throws Exception {
        return this.upload(HttpApacheConfig.init().client(client).url(url).headers(headers).context(context));
    }

    public String upload(HttpApacheConfig config) throws Exception {
        if (config.method() != HttpMethod.POST && config.method() != HttpMethod.PUT) {
            config.method(HttpMethod.POST);
        }
        return this.send(config);
    }

    public int status(HttpClient client, String url, Header[] headers, HttpContext context, HttpMethod method) throws Exception {
        return this.status(HttpApacheConfig.init().client(client).url(url).headers(headers).context(context).method(method));
    }

    public int status(HttpApacheConfig config) throws Exception {
        return ApacheHttp.resp2Int(this.execute(config));
    }

    public String send(HttpApacheConfig config) throws Exception {
        return ApacheHttp.resp2String(this.execute(config), config.outenc());
    }

    private HttpResponse execute(HttpApacheConfig config) throws Exception {
        this.create(config);
        try {
            HttpResponse resp;
            HttpRequestBase request = ApacheHttp.getRequest(config.url(), config.method());
            request.setHeaders(config.headers());
            if (HttpEntityEnclosingRequestBase.class.isAssignableFrom(request.getClass())) {
                ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
                config.url(ApacheHttpUtils.checkHasParas(config.url(), nvps, config.inenc()));
                HttpEntity entity = ApacheHttpUtils.map2HttpEntity(nvps, config.params(), config.inenc());
                ((HttpEntityEnclosingRequestBase)request).setEntity(entity);
                ApacheHttpUtils.info("\u8bf7\u6c42\u5730\u5740\uff1a" + config.url());
                if (nvps.size() > 0) {
                    ApacheHttpUtils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + ((Object)nvps).toString());
                }
                if (config.json() != null) {
                    ApacheHttpUtils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + config.json());
                }
            } else {
                int idx = config.url().indexOf("?");
                ApacheHttpUtils.info("\u8bf7\u6c42\u5730\u5740\uff1a" + config.url().substring(0, idx > 0 ? idx : config.url().length()));
                if (idx > 0) {
                    ApacheHttpUtils.info("\u8bf7\u6c42\u53c2\u6570\uff1a" + config.url().substring(idx + 1));
                }
            }
            HttpResponse httpResponse = resp = config.context() == null ? config.client().execute((HttpUriRequest)request) : config.client().execute((HttpUriRequest)request, config.context());
            if (config.isReturnRespHeaders()) {
                config.headers(resp.getAllHeaders());
            }
            return resp;
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    private static String resp2String(HttpResponse resp, String encoding) throws Exception {
        String body;
        try {
            if (resp.getEntity() != null) {
                body = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)encoding);
                ApacheHttpUtils.info(body);
            } else {
                body = resp.getStatusLine().toString();
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            ApacheHttp.close(resp);
        }
        return body;
    }

    private static int resp2Int(HttpResponse resp) throws Exception {
        int statusCode;
        try {
            statusCode = resp.getStatusLine().getStatusCode();
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            ApacheHttp.close(resp);
        }
        return statusCode;
    }

    public static OutputStream resp2Stream(HttpResponse resp, OutputStream out) throws Exception {
        try {
            resp.getEntity().writeTo(out);
            EntityUtils.consume((HttpEntity)resp.getEntity());
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            ApacheHttp.close(resp);
        }
        return out;
    }

    private static HttpRequestBase getRequest(String url, HttpMethod method) {
        HttpGet request;
        switch (method.getCode()) {
            case 0: {
                request = new HttpGet(url);
                break;
            }
            case 1: {
                request = new HttpPost(url);
                break;
            }
            case 2: {
                request = new HttpHead(url);
                break;
            }
            case 3: {
                request = new HttpPut(url);
                break;
            }
            case 4: {
                request = new HttpDelete(url);
                break;
            }
            case 5: {
                request = new HttpTrace(url);
                break;
            }
            case 6: {
                request = new HttpPatch(url);
                break;
            }
            case 7: {
                request = new HttpOptions(url);
                break;
            }
            default: {
                request = new HttpPost(url);
            }
        }
        return request;
    }

    private static void close(HttpResponse resp) {
        try {
            if (resp == null) {
                return;
            }
            if (CloseableHttpResponse.class.isAssignableFrom(resp.getClass())) {
                ((CloseableHttpResponse)resp).close();
            }
        }
        catch (IOException e) {
            ApacheHttpUtils.exception(e);
        }
    }

    static {
        try {
            client4HTTP = TemplateHttpClientBuilder.init().build();
            client4HTTPS = TemplateHttpClientBuilder.init().ssl().build();
        }
        catch (Exception e) {
            ApacheHttpUtils.errorException("\u521b\u5efahttps\u534f\u8bae\u7684HttpClient\u5bf9\u8c61\u51fa\u9519\uff1a{}", e);
        }
    }
}

