/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.sql.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLDefineUtils {
    private static String camelToUnderline(String param) {
        if (param != null && !"".equals(param.trim())) {
            int len = param.length();
            StringBuilder sb = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                char c = param.charAt(i);
                if (!Character.isUpperCase(c)) {
                    sb.append(c);
                    continue;
                }
                sb.append('_').append(Character.toLowerCase(c));
            }
            return sb.toString();
        }
        return "";
    }

    public static String underline2Camel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        StringBuilder sb = new StringBuilder(param);
        Matcher mc = Pattern.compile("_").matcher(param);
        int i = 0;
        while (mc.find()) {
            int position = mc.end() - i++;
            sb.replace(position - 1, position + 1, sb.substring(position, position + 1).toUpperCase());
        }
        return sb.toString();
    }

    public static String java2SQL(String charName, String fieldName) {
        if (charName == null || "".equals(charName)) {
            String newName = SQLDefineUtils.camelToUnderline(fieldName);
            if (!"_".equals(newName.substring(0, 1))) {
                return newName;
            }
            return newName.substring(1, newName.length());
        }
        return charName;
    }
}

