/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.sql.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import me.wuwenbin.modules.sql.annotation.MappedSuper;
import me.wuwenbin.modules.sql.annotation.SQLColumn;
import me.wuwenbin.modules.sql.annotation.SQLTable;
import me.wuwenbin.modules.sql.annotation.not.NotInsert;
import me.wuwenbin.modules.sql.annotation.not.NotSelect;
import me.wuwenbin.modules.sql.annotation.not.NotUpdate;

public class SQLBuilderUtils {
    private static final String SINGLE_SPACE = " ";
    private static final String DOUBLE_SPACE = "  ";
    private static final String AND = "AND";
    private static final String ANDSPACE = "AND ";
    private static final String COMMA = ",";
    private static final String COMMASPACE = ", ";

    public static String dealSQL(String sql) {
        sql = sql.replace(", FROM ", " FROM ").replace(",  FROM ", " FROM ");
        sql = sql.replace(", WHERE ", " WHERE ").replace(",  WHERE ", " WHERE ");
        sql = sql.replace(", )", ")");
        if ((sql = sql.replace(DOUBLE_SPACE, SINGLE_SPACE)).endsWith(AND)) {
            sql = sql.substring(0, sql.length() - 3);
        }
        if (sql.endsWith(ANDSPACE)) {
            sql = sql.substring(0, sql.length() - 4);
        }
        if (sql.endsWith(COMMA)) {
            sql = sql.substring(0, sql.length() - 1);
        }
        if (sql.endsWith(COMMASPACE)) {
            sql = sql.substring(0, sql.length() - 2);
        }
        return sql;
    }

    public static boolean SQLTableIsExist(Class<?> beanClass) {
        return beanClass.isAnnotationPresent(SQLTable.class);
    }

    public static boolean fieldRoutersInParamRouters(int[] filedRouters, int[] paramRouters) {
        ArrayList<Integer> paramRouterList = new ArrayList<Integer>();
        for (int paramRouter : paramRouters) {
            paramRouterList.add(paramRouter);
        }
        for (int filedRouter : filedRouters) {
            if (!paramRouterList.contains(filedRouter)) continue;
            return true;
        }
        return false;
    }

    public static Field[] getAllFieldsExceptObject(Class<?> clazz) {
        Vector<Field> fields = new Vector<Field>();
        Class<?> tempClass = clazz;
        while (tempClass != Object.class) {
            fields.addAll(Arrays.asList(tempClass.getDeclaredFields()));
            for (tempClass = tempClass.getSuperclass(); !SQLBuilderUtils.isMappedSuperClass(tempClass) && tempClass != Object.class; tempClass = tempClass.getSuperclass()) {
            }
        }
        Field[] newField = new Field[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field;
            newField[i] = field = (Field)fields.get(i);
        }
        return newField;
    }

    public static boolean routerIsNotEmpty(int ... routers) {
        return routers != null && routers.length > 0;
    }

    private static boolean isMappedSuperClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(MappedSuper.class) && clazz.getAnnotation(MappedSuper.class).value();
    }

    public static boolean hasNoSelectField(Field[] fields) {
        for (Field field : fields) {
            if (SQLBuilderUtils.canBeSelect(field)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNoInsertField(Field[] fields) {
        for (Field field : fields) {
            if (SQLBuilderUtils.canBeInsert(field)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNoUpdateField(Field[] fields) {
        for (Field field : fields) {
            if (SQLBuilderUtils.canBeUpdate(field)) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeSelect(Field field) {
        return !field.isAnnotationPresent(NotSelect.class) && (!field.isAnnotationPresent(SQLColumn.class) || field.getAnnotation(SQLColumn.class).select());
    }

    public static boolean canBeInsert(Field field) {
        return !field.isAnnotationPresent(NotInsert.class) && (!field.isAnnotationPresent(SQLColumn.class) || field.getAnnotation(SQLColumn.class).insert());
    }

    public static boolean canBeUpdate(Field field) {
        return !field.isAnnotationPresent(NotUpdate.class) && (!field.isAnnotationPresent(SQLColumn.class) || field.getAnnotation(SQLColumn.class).update());
    }

    public static int[] getRouterInField(Field field) {
        if (field.isAnnotationPresent(SQLColumn.class)) {
            return field.getAnnotation(SQLColumn.class).routers();
        }
        return new int[]{Integer.MIN_VALUE};
    }

    public static List<Field> getFieldsByRouters(Class<?> clazz, int ... routers) {
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(clazz);
        return Arrays.stream(fields).filter(f -> {
            if (f.isAnnotationPresent(SQLColumn.class)) {
                int[] fieldRouters = f.getAnnotation(SQLColumn.class).routers();
                return SQLBuilderUtils.fieldRoutersInParamRouters(fieldRouters, routers);
            }
            return SQLBuilderUtils.fieldRoutersInParamRouters(new int[]{Integer.MIN_VALUE}, routers);
        }).collect(Collectors.toList());
    }
}

