/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.sql.factory;

import me.wuwenbin.modules.sql.exception.DeleteSQLConditionsNullException;
import me.wuwenbin.modules.sql.exception.InsertColumnNullException;
import me.wuwenbin.modules.sql.exception.TableNameNullException;
import me.wuwenbin.modules.sql.exception.UpdateColumnNullException;
import me.wuwenbin.modules.sql.util.SQLBuilderUtils;

public class SQLTextBuilder {
    private final String SPACE = " ";
    private final String FROM = " FROM ";
    private final String AND = " AND ";
    private final String WHERE = " WHERE ";
    private final String selectPre = "SELECT ";
    private final String insertPre = "INSERT INTO ";

    public String countAll(String tableName) throws TableNameNullException {
        return this.countAndByColumns(tableName, new String[0]);
    }

    public String countAndByColumns(String tableName, String ... columns) throws TableNameNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName);
        if (columns != null && columns.length > 0) {
            sb.append(" WHERE ").append("1=1");
            for (String column : columns) {
                sb.append(" AND ").append(column).append(" = ?");
            }
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String countOrByColumns(String tableName, String ... columns) throws TableNameNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName);
        if (columns != null && columns.length > 0) {
            sb.append(" WHERE ").append("1<>1");
            String OR = " OR ";
            for (String column : columns) {
                sb.append(OR).append(column).append(" = ?");
            }
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String selectPartByColumnsAnd(String tableName, String[] selectColumns, String ... conditionColumns) throws TableNameNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        if (selectColumns != null && selectColumns.length > 0) {
            for (int i = 0; i < selectColumns.length; ++i) {
                String selectColumn = selectColumns[i];
                sb.append(tableName).append(".").append(selectColumn).append(", ");
            }
        } else {
            sb.append(tableName).append(".* ");
        }
        sb.append(" FROM ").append(tableName);
        this.assembleConditionSQL(tableName, sb, conditionColumns);
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String selectAllByColumns(String tableName, String ... columns) throws TableNameNullException {
        return this.selectPartByColumnsAnd(tableName, null, columns);
    }

    public String selectAll(String tableName) throws TableNameNullException {
        return this.selectAllByColumns(tableName, new String[0]);
    }

    public String insertAll(String tableName, int columnCount) throws TableNameNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tableName).append(" VALUES(");
        columnCount = columnCount <= 0 ? 1 : columnCount;
        for (int i = 0; i < columnCount; ++i) {
            sb.append("?, ");
        }
        sb.append(")");
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String insertColumns(String tableName, String ... columns) throws TableNameNullException, InsertColumnNullException {
        StringBuilder values;
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append(tableName);
        if (columns != null && columns.length > 0) {
            sb.append("(");
            values = new StringBuilder("(");
            for (String column : columns) {
                sb.append(column).append(", ");
                values.append("?, ");
            }
        } else {
            throw new InsertColumnNullException();
        }
        sb.append(") ").append(" VALUES").append((CharSequence)values).append(")");
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String updateColumnsByColumnArray(String tableName, String[] updateColumns, String[] conditionColumns) throws TableNameNullException, UpdateColumnNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        String updatePre = "UPDATE ";
        StringBuilder sb = new StringBuilder(updatePre);
        sb.append(tableName);
        if (updateColumns != null && updateColumns.length > 0) {
            sb.append(" SET ");
            for (String updateColumn : updateColumns) {
                sb.append(updateColumn).append(" = ?, ");
            }
        } else {
            throw new UpdateColumnNullException();
        }
        if (conditionColumns != null && conditionColumns.length > 0) {
            sb.append(" WHERE ");
            for (String conditionColumn : conditionColumns) {
                sb.append(conditionColumn).append(" = ?").append(" AND ");
            }
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String deleteByColumns(String tableName, String ... columns) throws TableNameNullException, DeleteSQLConditionsNullException {
        if (tableName == null || "".equals(tableName)) {
            throw new TableNameNullException();
        }
        String deletePre = "DELETE FROM ";
        StringBuilder sb = new StringBuilder(deletePre);
        sb.append(tableName);
        if (columns != null && columns.length > 0) {
            sb.append(" WHERE ");
            for (String column : columns) {
                sb.append(column).append(" = ?").append(" AND ");
            }
        } else {
            throw new DeleteSQLConditionsNullException();
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    private void assembleConditionSQL(String tableName, StringBuilder sb, String[] column) {
        if (column != null && column.length > 0) {
            sb.append(" WHERE ").append("1=1");
            for (String conditionColumn : column) {
                sb.append(" AND ").append(tableName).append(".").append(conditionColumn).append(" = ?");
            }
        }
    }
}

