/*
 * Decompiled with CFR 0.152.
 */
package me.wuwenbin.modules.sql.factory;

import java.lang.reflect.Field;
import me.wuwenbin.modules.sql.annotation.SQLColumn;
import me.wuwenbin.modules.sql.annotation.SQLTable;
import me.wuwenbin.modules.sql.annotation.support.Condition;
import me.wuwenbin.modules.sql.exception.DeletePkNotExistException;
import me.wuwenbin.modules.sql.exception.DeleteSQLConditionsNullException;
import me.wuwenbin.modules.sql.exception.NotSetPrimaryKeyException;
import me.wuwenbin.modules.sql.exception.PkFieldNotFoundException;
import me.wuwenbin.modules.sql.exception.SQLTableNotFoundException;
import me.wuwenbin.modules.sql.exception.UpdateColumnNullException;
import me.wuwenbin.modules.sql.exception.UpdatePkNotExistException;
import me.wuwenbin.modules.sql.support.Symbol;
import me.wuwenbin.modules.sql.util.SQLBuilderUtils;
import me.wuwenbin.modules.sql.util.SQLDefineUtils;

public final class SQLBeanBuilder {
    private Class<?> beanClass;
    private Class<SQLTable> sqlTableClass = SQLTable.class;
    private Class<SQLColumn> sqlColumnClass = SQLColumn.class;
    private final String SPACE = " ";
    private final String FROM = " FROM ";
    private final String WHERE = " WHERE ";
    private final String AND = " AND ";
    private final String selectPre = "SELECT ";
    private final String updatePre = "UPDATE ";
    private final String deletePre = "DELETE FROM ";

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public SQLBeanBuilder(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public String getTableName() {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        return SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
    }

    public Field getPkField() {
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        Field pkField = null;
        int sum = 0;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(this.sqlColumnClass) || !field.getAnnotation(this.sqlColumnClass).pk()) continue;
            ++sum;
            pkField = field;
        }
        if (sum > 0) {
            return pkField;
        }
        throw new PkFieldNotFoundException();
    }

    public Field[] getAllFieldExceptObject() {
        return SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
    }

    public String countAll() {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        return SQLBuilderUtils.dealSQL("SELECT COUNT(*) FROM " + tableName);
    }

    public String countAndByRouters(Symbol symbol, int ... routers) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName);
        if (SQLBuilderUtils.routerIsNotEmpty(routers)) {
            sb.append(" WHERE ").append("1=1");
            Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
            this.assembleCountSQL(sb, fields, " AND ", tableName, symbol, routers);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String countOrByRouters(Symbol symbol, int ... routers) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append("COUNT(*)").append(" FROM ").append(tableName);
        if (SQLBuilderUtils.routerIsNotEmpty(routers)) {
            sb.append(" WHERE ").append("1<>1");
            Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
            this.assembleCountSQL(sb, fields, " OR ", tableName, symbol, routers);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String selectPartByRoutersAnd(Symbol symbol, int[] selectColumnsRouters, int ... conditionRouters) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        StringBuilder sb = new StringBuilder("SELECT ");
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        this.assembleSelectSQL(selectColumnsRouters, tableName, sb, fields);
        sb.append(" FROM ").append(tableName);
        if (SQLBuilderUtils.routerIsNotEmpty(conditionRouters)) {
            sb.append(" WHERE ").append("1=1");
            this.assembleCountSQL(sb, fields, " AND ", tableName, symbol, conditionRouters);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String selectAllByRoutersAnd(Symbol symbol, int ... routers) {
        return this.selectPartByRoutersAnd(symbol, null, routers);
    }

    public String selectAll() {
        return this.selectAllByRoutersAnd(Symbol.QUESTION_MARK, new int[0]);
    }

    public String selectAllByPk(Symbol symbol) {
        return this.selectPartByPk(symbol, new int[0]);
    }

    public String selectPartByPk(Symbol symbol, int ... routers) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        this.assembleSelectSQL(routers, tableName, sb, fields);
        sb.append(" FROM ").append(tableName);
        boolean hasSetPk = false;
        for (Field field : fields) {
            if (!field.isAnnotationPresent(this.sqlColumnClass) || !field.getAnnotation(this.sqlColumnClass).pk()) continue;
            hasSetPk = true;
            String column = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
            sb.append(" WHERE ").append(tableName).append(".").append(column);
            if (symbol.equals((Object)Symbol.COLON)) {
                sb.append(" = :").append(field.getName());
                continue;
            }
            sb.append(" = ?");
        }
        if (!hasSetPk) {
            throw new NotSetPrimaryKeyException(this.beanClass);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    private String insertRoutersPk(boolean insertPk, Symbol symbol, int ... routers) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        sb.append(tableName);
        StringBuilder values = new StringBuilder("(");
        if (SQLBuilderUtils.routerIsNotEmpty(routers)) {
            sb.append("(");
            for (Field field : fields) {
                if (!field.isAnnotationPresent(this.sqlColumnClass)) continue;
                if (insertPk && field.getAnnotation(this.sqlColumnClass).pk()) {
                    String pkColumn = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
                    if (symbol.equals((Object)Symbol.COLON)) {
                        values.append(":").append(field.getName()).append(", ");
                    } else {
                        values.append("?").append(", ");
                    }
                    sb.append(pkColumn).append(", ");
                }
                if (!SQLBuilderUtils.canBeInsert(field)) continue;
                boolean isSqlColumnAnnotationPresent = field.isAnnotationPresent(SQLColumn.class);
                if (!SQLBuilderUtils.fieldRoutersInParamRouters(SQLBuilderUtils.getRouterInField(field), routers) || isSqlColumnAnnotationPresent && field.getAnnotation(this.sqlColumnClass).pk()) continue;
                String column = SQLDefineUtils.java2SQL(isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).value() : "", field.getName());
                if (symbol.equals((Object)Symbol.COLON)) {
                    values.append(":").append(field.getName()).append(", ");
                } else {
                    values.append("?").append(", ");
                }
                sb.append(column).append(", ");
            }
            sb.append(") VALUES").append((CharSequence)values).append(")");
        } else {
            sb.append("(");
            for (Field field : fields) {
                if (field.isAnnotationPresent(this.sqlColumnClass) && field.getAnnotation(this.sqlColumnClass).pk() && !insertPk || !SQLBuilderUtils.canBeInsert(field)) continue;
                boolean isSqlColumnAnnotationPresent = field.isAnnotationPresent(SQLColumn.class);
                String pkColumn = SQLDefineUtils.java2SQL(isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).value() : "", field.getName());
                if (symbol.equals((Object)Symbol.COLON)) {
                    values.append(":").append(field.getName()).append(", ");
                } else {
                    values.append("?").append(", ");
                }
                sb.append(pkColumn).append(", ");
            }
            sb.append(") VALUES").append((CharSequence)values).append(")");
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    @Deprecated
    public String insertAllPk(Symbol symbol, boolean insertPk) {
        return this.insertRoutersPk(insertPk, symbol, new int[0]);
    }

    @Deprecated
    public String insertAll(Symbol symbol, boolean insertPk) {
        return this.insertRoutersPk(insertPk, symbol, new int[0]);
    }

    public String insertAllWithPk(Symbol symbol) {
        return this.insertRoutersPk(true, symbol, new int[0]);
    }

    public String insertAllWithoutPk(Symbol symbol) {
        return this.insertRoutersPk(false, symbol, new int[0]);
    }

    public String insertRoutersWithPk(Symbol symbol, int ... routers) {
        return this.insertRoutersPk(true, symbol, routers);
    }

    public String insertRoutersWithoutPk(Symbol symbol, int ... routers) {
        return this.insertRoutersPk(false, symbol, routers);
    }

    public String updateRoutersByRouterArray(Symbol symbol, int[] updateRouters, int[] conditionRouters) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        StringBuilder sb = new StringBuilder("UPDATE ").append(tableName);
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        if (SQLBuilderUtils.routerIsNotEmpty(updateRouters)) {
            sb.append(" SET ");
            for (Field field : fields) {
                this.updateField(sb, field, symbol, updateRouters);
            }
        } else {
            throw new UpdateColumnNullException();
        }
        if (SQLBuilderUtils.routerIsNotEmpty(conditionRouters)) {
            sb.append(" WHERE ");
            this.assembleWhereSQL(sb, fields, symbol, conditionRouters);
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String updateRoutersByRouters(Symbol symbol, int[] updateRouters, int ... conditionRouters) {
        return this.updateRoutersByRouterArray(symbol, updateRouters, conditionRouters);
    }

    public String updateRoutersByPk(Symbol symbol, int ... updateRouters) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        StringBuilder sb = new StringBuilder("UPDATE ").append(tableName);
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        String pkColumn = null;
        String pkField = null;
        if (SQLBuilderUtils.routerIsNotEmpty(updateRouters)) {
            sb.append(" SET ");
            for (Field field : fields) {
                if (field.isAnnotationPresent(this.sqlColumnClass) && field.getAnnotation(this.sqlColumnClass).pk()) {
                    pkField = field.getName();
                    pkColumn = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), pkField);
                }
                this.updateField(sb, field, symbol, updateRouters);
            }
        } else {
            throw new UpdateColumnNullException();
        }
        sb.replace(sb.length() - 2, sb.length(), "");
        if (pkColumn == null || pkField == null) {
            throw new UpdatePkNotExistException();
        }
        if (symbol.equals((Object)Symbol.COLON)) {
            sb.append(" WHERE ").append(pkColumn).append(" = :").append(pkField);
        } else {
            sb.append(" WHERE ").append(pkColumn).append(" = ?");
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    private void updateField(StringBuilder sb, Field field, Symbol symbol, int[] updateRouters) {
        if (SQLBuilderUtils.canBeUpdate(field)) {
            boolean isSqlColumnAnnotationPresent = field.isAnnotationPresent(this.sqlColumnClass);
            if (SQLBuilderUtils.fieldRoutersInParamRouters(SQLBuilderUtils.getRouterInField(field), updateRouters)) {
                String column = SQLDefineUtils.java2SQL(isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).value() : "", field.getName());
                String cnd = isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).condition().getCnd() : Condition.EQ.getCnd();
                sb.append(column).append(" ").append(cnd);
                if (symbol.equals((Object)Symbol.COLON)) {
                    sb.append(" :").append(field.getName()).append(", ");
                } else {
                    sb.append(" ?, ");
                }
            }
        }
    }

    public String deleteByPk(Symbol symbol) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(tableName);
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        boolean hasPk = false;
        sb.append(" WHERE ");
        for (Field field : fields) {
            if (!field.isAnnotationPresent(this.sqlColumnClass) || !field.getAnnotation(this.sqlColumnClass).pk()) continue;
            hasPk = true;
            String pkColumn = SQLDefineUtils.java2SQL(field.getAnnotation(this.sqlColumnClass).value(), field.getName());
            boolean isSqlColumnAnnotationPresent = field.isAnnotationPresent(this.sqlColumnClass);
            String cnd = isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).condition().getCnd() : Condition.EQ.getCnd();
            sb.append(pkColumn).append(" ").append(cnd);
            if (symbol.equals((Object)Symbol.COLON)) {
                sb.append(" :").append(field.getName()).append(" AND ");
                continue;
            }
            sb.append(" ?").append(" AND ");
        }
        if (!hasPk) {
            throw new DeletePkNotExistException();
        }
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    public String deleteByRouters(Symbol symbol, int ... routers) {
        if (!SQLBuilderUtils.SQLTableIsExist(this.beanClass)) {
            throw new SQLTableNotFoundException(this.beanClass);
        }
        String tableName = SQLDefineUtils.java2SQL(this.beanClass.getAnnotation(this.sqlTableClass).value(), this.beanClass.getSimpleName());
        StringBuilder sb = new StringBuilder("DELETE FROM ").append(tableName);
        Field[] fields = SQLBuilderUtils.getAllFieldsExceptObject(this.beanClass);
        if (!SQLBuilderUtils.routerIsNotEmpty(routers)) {
            throw new DeleteSQLConditionsNullException();
        }
        sb.append(" WHERE ");
        this.assembleWhereSQL(sb, fields, symbol, routers);
        return SQLBuilderUtils.dealSQL(sb.toString());
    }

    private void assembleCountSQL(StringBuilder sb, Field[] fields, String andOr, String tableName, Symbol symbol, int ... routers) {
        if (SQLBuilderUtils.routerIsNotEmpty(routers)) {
            for (Field field : fields) {
                boolean isSqlColumnAnnotationPresent = field.isAnnotationPresent(this.sqlColumnClass);
                if (!SQLBuilderUtils.fieldRoutersInParamRouters(SQLBuilderUtils.getRouterInField(field), routers)) continue;
                String column = SQLDefineUtils.java2SQL(isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).value() : "", field.getName());
                String cnd = isSqlColumnAnnotationPresent ? field.getAnnotation(SQLColumn.class).condition().getCnd() : Condition.EQ.getCnd();
                sb.append(andOr).append(tableName).append(".").append(column).append(" ").append(cnd);
                if (symbol.equals((Object)Symbol.COLON)) {
                    sb.append(":").append(field.getName());
                    continue;
                }
                sb.append("?");
            }
        }
    }

    private void assembleSelectSQL(int[] selectColumnsRouters, String tableName, StringBuilder sb, Field[] fields) {
        if (SQLBuilderUtils.routerIsNotEmpty(selectColumnsRouters)) {
            for (Field field : fields) {
                if (!SQLBuilderUtils.canBeSelect(field)) continue;
                boolean isSqlColumnAnnotationPresent = field.isAnnotationPresent(this.sqlColumnClass);
                if (!SQLBuilderUtils.fieldRoutersInParamRouters(SQLBuilderUtils.getRouterInField(field), selectColumnsRouters)) continue;
                String column = SQLDefineUtils.java2SQL(isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).value() : "", field.getName());
                sb.append(tableName).append(".").append(column).append(", ");
            }
        } else if (!SQLBuilderUtils.hasNoSelectField(fields)) {
            sb.append(tableName).append(".").append("*");
        } else {
            for (Field field : fields) {
                if (!SQLBuilderUtils.canBeSelect(field)) continue;
                boolean isSqlColumnAnnotationPresent = field.isAnnotationPresent(this.sqlColumnClass);
                String column = SQLDefineUtils.java2SQL(isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).value() : "", field.getName());
                sb.append(tableName).append(".").append(column).append(", ");
            }
        }
    }

    private void assembleWhereSQL(StringBuilder sb, Field[] fields, Symbol symbol, int[] routers) {
        if (SQLBuilderUtils.routerIsNotEmpty(routers)) {
            for (Field field : fields) {
                boolean isSqlColumnAnnotationPresent = field.isAnnotationPresent(this.sqlColumnClass);
                if (!SQLBuilderUtils.fieldRoutersInParamRouters(SQLBuilderUtils.getRouterInField(field), routers)) continue;
                String column = SQLDefineUtils.java2SQL(isSqlColumnAnnotationPresent ? field.getAnnotation(this.sqlColumnClass).value() : "", field.getName());
                String cnd = isSqlColumnAnnotationPresent ? field.getAnnotation(SQLColumn.class).condition().getCnd() : Condition.EQ.getCnd();
                sb.append(column).append(" ").append(cnd);
                if (symbol.equals((Object)Symbol.COLON)) {
                    sb.append(" :").append(field.getName()).append(" AND ");
                    continue;
                }
                sb.append(" ?").append(" AND ");
            }
        }
    }
}

