/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.ParserUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public abstract class UntisCommonParser
extends BaseParser {
    private static final String[] EXCLUDED_CLASS_NAMES = new String[]{"-----"};

    public UntisCommonParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    static String findLastChange(Element doc, SubstitutionScheduleData scheduleData) {
        String lastChange = null;
        if (doc.select("table.mon_head").size() > 0) {
            Element monHead = doc.select("table.mon_head").first();
            lastChange = UntisCommonParser.findLastChangeFromMonHeadTable(monHead);
        } else if (scheduleData != null && scheduleData.getData().optBoolean("stand_links", false)) {
            lastChange = doc.select("body").html().substring(0, doc.select("body").html().indexOf("<p>") - 1);
        } else {
            List childNodes = doc instanceof Document ? ((Document)doc).body().childNodes() : doc.childNodes();
            for (Node node : childNodes) {
                Comment comment;
                if (!(node instanceof Comment) || !(comment = (Comment)node).getData().contains("<table class=\"mon_head\">")) continue;
                Document commentedDoc = Jsoup.parse((String)comment.getData());
                Element monHead = commentedDoc.select("table.mon_head").first();
                lastChange = UntisCommonParser.findLastChangeFromMonHeadTable(monHead);
                break;
            }
        }
        return lastChange;
    }

    private static String findLastChangeFromMonHeadTable(Element monHead) {
        if (monHead.select("td[align=right]").size() == 0) {
            return null;
        }
        String lastChange = null;
        Pattern pattern = Pattern.compile("\\d\\d\\.\\d\\d\\.\\d\\d\\d\\d \\d\\d:\\d\\d");
        Matcher matcher = pattern.matcher(monHead.select("td[align=right]").first().text());
        if (matcher.find()) {
            lastChange = matcher.group();
        } else if (monHead.text().contains("Stand: ")) {
            lastChange = monHead.text().substring(monHead.text().indexOf("Stand:") + "Stand:".length()).trim();
        }
        return lastChange;
    }

    private static boolean equalsOrNull(String a, String b) {
        return a == null || b == null || a.equals(b);
    }

    /*
     * WARNING - void declaration
     */
    protected void parseVertretungsplanTable(Element table, JSONObject data, SubstitutionScheduleDay day) throws JSONException {
        if (data.optBoolean("class_in_extra_line")) {
            for (Element element : table.select("td.inline_header")) {
                String className = this.getClassName(element.text(), data);
                if (!this.isValidClass(className)) continue;
                Element zeile = null;
                try {
                    zeile = element.parent().nextElementSibling();
                    if (zeile.select("td") == null) {
                        zeile = zeile.nextElementSibling();
                    }
                    int skipLines = 0;
                    while (zeile != null && !zeile.select("td").attr("class").equals("list inline_header")) {
                        if (skipLines > 0) {
                            --skipLines;
                            zeile = zeile.nextElementSibling();
                            continue;
                        }
                        Substitution v = new Substitution();
                        int i = 0;
                        for (Element spalte : zeile.select("td")) {
                            String type;
                            String text = spalte.text();
                            if (this.isEmpty(text)) {
                                ++i;
                                continue;
                            }
                            int skipLinesForThisColumn = 0;
                            Element nextLine = zeile.nextElementSibling();
                            boolean bl = true;
                            while (bl) {
                                if (nextLine != null && nextLine.children().size() == zeile.children().size()) {
                                    Element columnInNextLine = nextLine.child(spalte.elementSiblingIndex().intValue());
                                    if (columnInNextLine.text().replaceAll("\u00a0", "").trim().equals(nextLine.text().replaceAll("\u00a0", "").trim())) {
                                        text = text + " " + columnInNextLine.text();
                                        ++skipLinesForThisColumn;
                                        nextLine = nextLine.nextElementSibling();
                                        continue;
                                    }
                                    bl = false;
                                    continue;
                                }
                                bl = false;
                            }
                            if (skipLinesForThisColumn > skipLines) {
                                skipLines = skipLinesForThisColumn;
                            }
                            switch (type = data.getJSONArray("columns").getString(i)) {
                                case "lesson": {
                                    v.setLesson(text);
                                    break;
                                }
                                case "subject": {
                                    this.handleSubject(v, spalte);
                                    break;
                                }
                                case "previousSubject": {
                                    v.setPreviousSubject(text);
                                    break;
                                }
                                case "type": {
                                    v.setType(text);
                                    v.setColor(this.colorProvider.getColor(text));
                                    break;
                                }
                                case "type-entfall": {
                                    if (text.equals("x")) {
                                        v.setType("Entfall");
                                        v.setColor(this.colorProvider.getColor("Entfall"));
                                        break;
                                    }
                                    v.setType("Vertretung");
                                    v.setColor(this.colorProvider.getColor("Vertretung"));
                                    break;
                                }
                                case "room": {
                                    this.handleRoom(v, spalte);
                                    break;
                                }
                                case "teacher": {
                                    this.handleTeacher(v, spalte);
                                    break;
                                }
                                case "previousTeacher": {
                                    v.setPreviousTeacher(text);
                                    break;
                                }
                                case "desc": {
                                    v.setDesc(text);
                                    break;
                                }
                                case "desc-type": {
                                    v.setDesc(text);
                                    String recognizedType = UntisCommonParser.recognizeType(text);
                                    v.setType(recognizedType);
                                    v.setColor(this.colorProvider.getColor(recognizedType));
                                    break;
                                }
                                case "previousRoom": {
                                    v.setPreviousRoom(text);
                                    break;
                                }
                                case "substitutionFrom": {
                                    v.setSubstitutionFrom(text);
                                    break;
                                }
                                case "teacherTo": {
                                    v.setTeacherTo(text);
                                }
                            }
                            ++i;
                        }
                        if (v.getType() == null) {
                            v.setType("Vertretung");
                            v.setColor(this.colorProvider.getColor("Vertretung"));
                        }
                        v.getClasses().add(className);
                        if (v.getLesson() != null && !v.getLesson().equals("")) {
                            day.addSubstitution(v);
                        }
                        zeile = zeile.nextElementSibling();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        } else {
            boolean hasType = false;
            for (int i = 0; i < data.getJSONArray("columns").length(); ++i) {
                if (!data.getJSONArray("columns").getString(i).equals("type")) continue;
                hasType = true;
            }
            Substitution previousSubstitution = null;
            int skipLines = 0;
            for (Element zeile : table.select("tr.list.odd:not(:has(td.inline_header)), tr.list.even:not(:has(td.inline_header)), tr:has(td[align=center]):gt(0)")) {
                List<Object> affectedClasses;
                Pattern pattern;
                Matcher matcher;
                if (skipLines > 0) {
                    --skipLines;
                    continue;
                }
                Substitution v = new Substitution();
                String klassen = "";
                int i = 0;
                for (Element spalte : zeile.select("td")) {
                    String type;
                    String text = spalte.text();
                    if (this.isEmpty(text)) {
                        ++i;
                        continue;
                    }
                    int skipLinesForThisColumn = 0;
                    Element element = zeile.nextElementSibling();
                    boolean continueSkippingLines = true;
                    while (continueSkippingLines) {
                        void var16_38;
                        if (var16_38 != null && var16_38.children().size() == zeile.children().size()) {
                            Element columnInNextLine = var16_38.child(spalte.elementSiblingIndex().intValue());
                            if (columnInNextLine.text().replaceAll("\u00a0", "").trim().equals(var16_38.text().replaceAll("\u00a0", "").trim())) {
                                text = text + " " + columnInNextLine.text();
                                ++skipLinesForThisColumn;
                                Element element2 = var16_38.nextElementSibling();
                                continue;
                            }
                            continueSkippingLines = false;
                            continue;
                        }
                        continueSkippingLines = false;
                    }
                    if (skipLinesForThisColumn > skipLines) {
                        skipLines = skipLinesForThisColumn;
                    }
                    switch (type = data.getJSONArray("columns").getString(i)) {
                        case "lesson": {
                            v.setLesson(text);
                            break;
                        }
                        case "subject": {
                            this.handleSubject(v, spalte);
                            break;
                        }
                        case "previousSubject": {
                            v.setPreviousSubject(text);
                            break;
                        }
                        case "type": {
                            v.setType(text);
                            v.setColor(this.colorProvider.getColor(text));
                            break;
                        }
                        case "type-entfall": {
                            if (text.equals("x")) {
                                v.setType("Entfall");
                                v.setColor(this.colorProvider.getColor("Entfall"));
                                break;
                            }
                            if (hasType) break;
                            v.setType("Vertretung");
                            v.setColor(this.colorProvider.getColor("Vertretung"));
                            break;
                        }
                        case "room": {
                            this.handleRoom(v, spalte);
                            break;
                        }
                        case "previousRoom": {
                            v.setPreviousRoom(text);
                            break;
                        }
                        case "desc": {
                            v.setDesc(text);
                            break;
                        }
                        case "desc-type": {
                            v.setDesc(text);
                            String recognizedType = UntisCommonParser.recognizeType(text);
                            v.setType(recognizedType);
                            v.setColor(this.colorProvider.getColor(recognizedType));
                            break;
                        }
                        case "teacher": {
                            this.handleTeacher(v, spalte);
                            break;
                        }
                        case "previousTeacher": {
                            v.setPreviousTeacher(text);
                            break;
                        }
                        case "substitutionFrom": {
                            v.setSubstitutionFrom(text);
                            break;
                        }
                        case "teacherTo": {
                            v.setTeacherTo(text);
                            break;
                        }
                        case "class": {
                            klassen = this.getClassName(text, data);
                        }
                    }
                    ++i;
                }
                if (v.getLesson() == null || v.getLesson().equals("")) continue;
                if (v.getType() == null) {
                    if (zeile.select("strike").size() > 0 && UntisCommonParser.equalsOrNull(v.getSubject(), v.getPreviousSubject()) && UntisCommonParser.equalsOrNull(v.getTeacher(), v.getPreviousTeacher()) || v.getSubject() == null && v.getRoom() == null && v.getTeacher() == null && v.getPreviousSubject() != null) {
                        v.setType("Entfall");
                        v.setColor(this.colorProvider.getColor("Entfall"));
                    } else {
                        v.setType("Vertretung");
                        v.setColor(this.colorProvider.getColor("Vertretung"));
                    }
                }
                if ((matcher = (pattern = Pattern.compile("(\\d+) ?- ?(\\d+)")).matcher(klassen)).find()) {
                    affectedClasses = new ArrayList();
                    int min = Integer.parseInt(matcher.group(1));
                    int n = Integer.parseInt(matcher.group(2));
                    try {
                        for (String klasse : this.getAllClasses()) {
                            int num;
                            Pattern pattern2 = Pattern.compile("\\d+");
                            Matcher matcher2 = pattern2.matcher(klasse);
                            if (!matcher2.find() || min > (num = Integer.parseInt(matcher2.group())) || num > n) continue;
                            affectedClasses.add(klasse);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (data.optBoolean("classes_separated", true)) {
                    affectedClasses = Arrays.asList(klassen.split(", "));
                } else {
                    affectedClasses = new ArrayList();
                    try {
                        for (String string : this.getAllClasses()) {
                            StringBuilder regex = new StringBuilder();
                            for (char character : string.toCharArray()) {
                                regex.append(character);
                                regex.append(".*");
                            }
                            if (!klassen.matches(regex.toString())) continue;
                            affectedClasses.add(string);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                for (String string : affectedClasses) {
                    if (!this.isValidClass(string)) continue;
                    v.getClasses().add(string);
                }
                day.addSubstitution(v);
                previousSubstitution = v;
            }
        }
    }

    private void handleTeacher(Substitution subst, Element cell) {
        if (cell.select("s").size() > 0) {
            subst.setPreviousTeacher(cell.select("s").text());
            if (cell.ownText().length() > 0) {
                subst.setTeacher(cell.ownText().replaceFirst("^\\?", ""));
            }
        } else {
            subst.setTeacher(cell.text());
        }
    }

    private void handleRoom(Substitution subst, Element cell) {
        if (cell.select("s").size() > 0) {
            subst.setPreviousRoom(cell.select("s").text());
            if (cell.ownText().length() > 0) {
                subst.setRoom(cell.ownText().replaceFirst("^\\?", ""));
            }
        } else {
            subst.setRoom(cell.text());
        }
    }

    private void handleSubject(Substitution subst, Element cell) {
        if (cell.select("s").size() > 0) {
            subst.setPreviousSubject(cell.select("s").text());
            if (cell.ownText().length() > 0) {
                subst.setSubject(cell.ownText().replaceFirst("^\\?", ""));
            }
        } else {
            subst.setSubject(cell.text());
        }
    }

    private boolean isEmpty(String text) {
        return text.trim().equals("") || text.trim().equals("---");
    }

    protected void parseMessages(Element table, SubstitutionScheduleDay day) {
        Elements zeilen = table.select("tr:not(:contains(Nachrichten zum Tag))");
        for (Element i : zeilen) {
            Elements spalten = i.select("td");
            String info = "";
            for (Element b : spalten) {
                info = info + "\n" + TextNode.createFromEncoded((String)b.html(), null).getWholeText();
            }
            info = info.substring(1);
            day.addMessage(info);
        }
    }

    protected SubstitutionScheduleDay parseMonitorVertretungsplanTag(Element doc, JSONObject data) throws JSONException {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        String date = doc.select(".mon_title").first().text().replaceAll(" \\(Seite \\d+ / \\d+\\)", "");
        day.setDateString(date);
        day.setDate(ParserUtils.parseDate(date));
        if (!this.scheduleData.getData().has("lastChangeSelector")) {
            String lastChange = UntisCommonParser.findLastChange(doc, this.scheduleData);
            day.setLastChangeString(lastChange);
            day.setLastChange(ParserUtils.parseDateTime(lastChange));
        }
        if (doc.select("table.info").size() > 0) {
            this.parseMessages(doc.select("table.info").first(), day);
        }
        if (doc.select("table:has(tr.list)").size() > 0) {
            this.parseVertretungsplanTable(doc.select("table:has(tr.list)").first(), data, day);
        }
        return day;
    }

    private boolean isValidClass(String klasse) throws JSONException {
        return klasse != null && !Arrays.asList(EXCLUDED_CLASS_NAMES).contains(klasse) && (!this.scheduleData.getData().has("exclude_classes") || !this.contains(this.scheduleData.getData().getJSONArray("exclude_classes"), klasse));
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        return this.getClassesFromJson();
    }

    protected void parseDay(SubstitutionScheduleDay day, Element next, SubstitutionSchedule v) throws JSONException {
        if (next.className().equals("subst")) {
            if (next.text().contains("Vertretungen sind nicht freigegeben")) {
                return;
            }
            this.parseVertretungsplanTable(next, this.scheduleData.getData(), day);
        } else {
            this.parseMessages(next, day);
            next = next.nextElementSibling().nextElementSibling();
            this.parseVertretungsplanTable(next, this.scheduleData.getData(), day);
        }
        v.addDay(day);
    }
}

