/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.credential.Credential;
import me.vertretungsplan.objects.credential.PasswordCredential;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.CookieProvider;
import org.apache.http.client.CookieStore;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.cookie.Cookie;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

class LoginHandler {
    private SubstitutionScheduleData scheduleData;
    private Credential auth;
    private CookieProvider cookieProvider;

    LoginHandler(SubstitutionScheduleData scheduleData, Credential auth, @Nullable CookieProvider cookieProvider) {
        this.scheduleData = scheduleData;
        this.auth = auth;
        this.cookieProvider = cookieProvider;
    }

    void handleLogin(Executor executor, CookieStore cookieStore) throws JSONException, IOException, CredentialInvalidException {
        this.handleLogin(executor, cookieStore, false);
    }

    String handleLoginWithResponse(Executor executor, CookieStore cookieStore) throws JSONException, IOException, CredentialInvalidException {
        return this.handleLogin(executor, cookieStore, true);
    }

    private String handleLogin(Executor executor, CookieStore cookieStore, boolean needsResponse) throws JSONException, IOException, CredentialInvalidException {
        String type;
        String password;
        String login;
        if (this.auth == null) {
            return null;
        }
        if (!(this.auth instanceof UserPasswordCredential) && !(this.auth instanceof PasswordCredential)) {
            throw new IllegalArgumentException("Wrong authentication type");
        }
        if (this.auth instanceof UserPasswordCredential) {
            login = ((UserPasswordCredential)this.auth).getUsername();
            password = ((UserPasswordCredential)this.auth).getPassword();
        } else {
            login = null;
            password = ((PasswordCredential)this.auth).getPassword();
        }
        JSONObject data = this.scheduleData.getData();
        switch (type = data.getJSONObject("login").optString("type", "post")) {
            case "post": {
                String response;
                List<Cookie> cookieList;
                List<Cookie> list = cookieList = this.cookieProvider != null ? this.cookieProvider.getCookies(this.auth) : null;
                if (cookieList != null && !needsResponse) {
                    for (Cookie cookie : cookieList) {
                        cookieStore.addCookie(cookie);
                    }
                    break;
                }
                executor.clearCookies();
                Document preDoc = null;
                if (data.getJSONObject("login").has("preUrl")) {
                    String preUrl = data.getJSONObject("login").getString("preUrl");
                    String preHtml = executor.execute(Request.Get((String)preUrl)).returnContent().asString();
                    preDoc = Jsoup.parse((String)preHtml);
                }
                String url = data.getJSONObject("login").getString("url");
                JSONObject loginData = data.getJSONObject("login").getJSONObject("data");
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (String name : JSONObject.getNames((JSONObject)loginData)) {
                    String value = loginData.getString(name);
                    if (name.equals("_hiddeninputs")) {
                        for (Element hidden : preDoc.select(value + " input[type=hidden]")) {
                            nvps.add(new BasicNameValuePair(hidden.attr("name"), hidden.attr("value")));
                        }
                        continue;
                    }
                    if (value.equals("_login")) {
                        value = login;
                    } else if (value.equals("_password")) {
                        value = password;
                    }
                    nvps.add(new BasicNameValuePair(name, value));
                }
                String html = executor.execute(Request.Post((String)url).bodyForm(nvps, Charset.forName("UTF-8"))).returnContent().asString();
                if (this.cookieProvider != null) {
                    this.cookieProvider.saveCookies(this.auth, cookieStore.getCookies());
                }
                String checkUrl = data.getJSONObject("login").optString("checkUrl", null);
                String checkText = data.getJSONObject("login").optString("checkText", null);
                if (checkUrl != null && checkText != null && (response = executor.execute(Request.Get((String)checkUrl)).returnContent().asString()).contains(checkText)) {
                    throw new CredentialInvalidException();
                }
                return html;
            }
            case "basic": {
                String url;
                if (login == null) {
                    throw new IOException("wrong auth type");
                }
                executor.auth(login, password);
                if (!data.getJSONObject("login").has("url") || executor.execute(Request.Get((String)(url = data.getJSONObject("login").getString("url")))).returnResponse().getStatusLine().getStatusCode() == 200) break;
                throw new IOException("wrong login/password");
            }
            case "fixed": {
                String loginFixed = data.getJSONObject("login").optString("login", null);
                String passwordFixed = data.getJSONObject("login").getString("password");
                if (Objects.equals(loginFixed, login) && Objects.equals(passwordFixed, password)) break;
                throw new IOException("wrong login/password");
            }
        }
        return null;
    }
}

