/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.AdditionalInfo;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.authentication.SchoolNumberPasswordAuthenticationData;
import me.vertretungsplan.objects.credential.SchoolNumberPasswordCredential;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.DaVinciParser;
import me.vertretungsplan.parser.ParserUtils;
import me.vertretungsplan.parser.UntisCommonParser;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class DSBMobileParser
extends UntisCommonParser {
    private static final String URL = "https://app.dsbcontrol.de/JsonHandlerWeb.ashx/GetData";
    private static final String ENCODING = "UTF-8";
    private JSONObject data;

    public DSBMobileParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    private static String decode(String input) throws IOException {
        byte[] inputBytes = Base64.decodeBase64((String)input);
        GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(inputBytes));
        return IOUtils.toString((InputStream)is, (String)ENCODING);
    }

    private static String encode(String input) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        GZIPOutputStream gzipOs = new GZIPOutputStream(os);
        ((OutputStream)gzipOs).write(input.getBytes(ENCODING));
        ((OutputStream)gzipOs).close();
        byte[] outputBytes = os.toByteArray();
        return Base64.encodeBase64String((byte[])outputBytes);
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        String password;
        if (this.credential == null || !(this.credential instanceof SchoolNumberPasswordCredential) || ((SchoolNumberPasswordCredential)this.credential).getPassword() == null || ((SchoolNumberPasswordCredential)this.credential).getPassword().isEmpty()) {
            throw new IOException("no login");
        }
        String login = ((SchoolNumberPasswordAuthenticationData)this.scheduleData.getAuthenticationData()).getSchoolNumber();
        JSONObject data = this.getDataFromApi(login, password = ((SchoolNumberPasswordCredential)this.credential).getPassword());
        int resultcode = data.getInt("Resultcode");
        if (resultcode == 1) {
            throw new CredentialInvalidException();
        }
        if (resultcode != 0) {
            throw new IOException("Resultcode " + resultcode);
        }
        JSONObject timetablePage = this.getPageByType(data, "timetable");
        if (timetablePage == null) {
            throw new IOException("no timetable page found");
        }
        JSONArray timetableModules = timetablePage.getJSONObject("Root").getJSONArray("Childs");
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        ArrayList<String> usedUrls = new ArrayList<String>();
        for (int i = 0; i < timetableModules.length(); ++i) {
            JSONArray timetableParts = timetableModules.getJSONObject(i).getJSONArray("Childs");
            for (int j = 0; j < timetableParts.length(); ++j) {
                JSONObject timetablePart = timetableParts.getJSONObject(j);
                if (timetablePart.getInt("ConType") != 6) continue;
                String url = timetablePart.getString("Detail");
                this.loadScheduleFromUrl(v, url, usedUrls);
                if (!timetablePart.has("Date") || v.getLastChangeString() != null) continue;
                v.setLastChange(DateTimeFormat.forPattern((String)"dd.MM.yyyy HH:mm").parseLocalDateTime(timetablePart.getString("Date")));
            }
        }
        JSONObject newsPage = this.getPageByType(data, "news");
        if (newsPage != null) {
            JSONArray newsItems = newsPage.getJSONObject("Root").getJSONArray("Childs");
            ArrayList<AdditionalInfo> infos = new ArrayList<AdditionalInfo>(newsItems.length());
            for (int i = 0; i < newsItems.length(); ++i) {
                JSONObject newsItem = newsItems.getJSONObject(i);
                if (newsItem.getString("Id").equals("00000000-0000-0000-0000-000000000000")) continue;
                AdditionalInfo info = new AdditionalInfo();
                info.setHasInformation(false);
                info.setTitle(newsItem.getString("Title") + " (" + newsItem.getString("Date") + ")");
                String message = newsItem.getString("Detail");
                message = message.replaceAll("-+\\s*\\n+\\s*-+", "");
                info.setText(message);
                infos.add(info);
            }
            v.getAdditionalInfos().addAll(infos);
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        v.setWebsite("http://mobile.dsbcontrol.de/");
        return v;
    }

    private JSONObject getPageByType(JSONObject data, String type) throws JSONException {
        JSONArray resultMenuItems = data.getJSONArray("ResultMenuItems");
        JSONArray content = resultMenuItems.getJSONObject(0).getJSONArray("Childs");
        for (int i = 0; i < content.length(); ++i) {
            JSONObject child = content.getJSONObject(i);
            if (!child.getString("MethodName").equals(type)) continue;
            return child;
        }
        return null;
    }

    private JSONObject getDataFromApi(String login, String password) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        json.put("AppId", (Object)"");
        json.put("PushId", (Object)"");
        json.put("UserId", (Object)login);
        json.put("UserPw", (Object)password);
        json.put("AppVersion", (Object)"0.8");
        json.put("Device", (Object)"WebApp");
        json.put("OsVersion", (Object)"Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2490.71 Safari/537.36");
        json.put("Language", (Object)"de");
        json.put("Date", (Object)ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now()));
        json.put("LastUpdate", (Object)ISODateTimeFormat.dateTime().print((ReadableInstant)DateTime.now()));
        json.put("BundleId", (Object)"de.heinekingmedia.inhouse.dsbmobile.web");
        JSONObject payload = new JSONObject();
        JSONObject req = new JSONObject();
        req.put("Data", (Object)DSBMobileParser.encode(json.toString()));
        req.put("DataType", 1);
        payload.put("req", (Object)req);
        JSONObject responseJson = new JSONObject(this.httpPost(URL, ENCODING, payload.toString(), ContentType.APPLICATION_JSON));
        String data = DSBMobileParser.decode(responseJson.getString("d"));
        return new JSONObject(data);
    }

    private void loadScheduleFromUrl(SubstitutionSchedule v, String url, List<String> usedUrls) throws IOException, JSONException {
        usedUrls.add(url);
        String html = this.httpGet(url, this.data.has("encoding") ? this.data.getString("encoding") : ENCODING);
        Document doc = Jsoup.parse((String)html);
        if (doc.title().toLowerCase().contains("untis") || doc.html().toLowerCase().contains("untis")) {
            if (doc.select(".mon_head").size() > 1) {
                for (int j = 0; j < doc.select(".mon_head").size(); ++j) {
                    Document doc2 = Document.createShell((String)doc.baseUri());
                    doc2.body().appendChild((Node)((Element)doc.select(".mon_head").get(j)).clone());
                    Element next = ((Element)doc.select(".mon_head").get(j)).nextElementSibling();
                    if (next != null && next.tagName().equals("center")) {
                        doc2.body().appendChild((Node)next.select(".mon_title").first().clone());
                        if (next.select("table:has(tr.list)").size() > 0) {
                            doc2.body().appendChild((Node)next.select("table:has(tr.list)").first());
                        }
                        if (next.select("table.info").size() > 0) {
                            doc2.body().appendChild((Node)next.select("table.info").first());
                        }
                    } else {
                        doc2.body().appendChild((Node)((Element)doc.select(".mon_title").get(j)).clone());
                        doc2.body().appendChild((Node)((Element)doc.select("table:has(tr.list)").get(j)).clone());
                    }
                    SubstitutionScheduleDay day = this.parseMonitorVertretungsplanTag((Element)doc2, this.data);
                    v.addDay(day);
                }
            } else {
                SubstitutionScheduleDay day = this.parseMonitorVertretungsplanTag((Element)doc, this.data);
                v.addDay(day);
            }
        } else if (doc.html().toLowerCase().contains("created by davinci")) {
            Elements titles = doc.select("h2");
            Elements tables = doc.select("h2 + p + table");
            if (titles.size() != tables.size()) {
                throw new IOException("Anzahl \u00dcberschriften != Anzahl Tabellen");
            }
            for (int i = 0; i < titles.size(); ++i) {
                SubstitutionScheduleDay day = new SubstitutionScheduleDay();
                String date = ((Element)titles.get(i)).text();
                day.setDateString(date);
                day.setDate(ParserUtils.parseDate(date));
                DaVinciParser.parseDaVinciTable((Element)tables.get(i), day, this.colorProvider);
                v.addDay(day);
            }
        } else {
            throw new IOException("Kein Untis- oder DaVinci-Vertretungsplan?");
        }
        if (doc.select("meta[http-equiv=refresh]").size() > 0) {
            Element meta = doc.select("meta[http-equiv=refresh]").first();
            String attr = meta.attr("content").toLowerCase();
            String redirectUrl = url.substring(0, url.lastIndexOf("/") + 1) + attr.substring(attr.indexOf("url=") + 4);
            if (!usedUrls.contains(redirectUrl)) {
                this.loadScheduleFromUrl(v, redirectUrl, usedUrls);
            }
        }
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

