/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.credential.UserPasswordCredential;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.UntisCommonParser;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class DSBLightParser
extends UntisCommonParser {
    private static final String BASE_URL = "https://light.dsbcontrol.de/DSBlightWebsite/Homepage/";
    private static final String ENCODING = "UTF-8";
    private JSONObject data;

    public DSBLightParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        String id = this.data.getString("id");
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        HashMap<String, String> referer = new HashMap<String, String>();
        referer.put("Referer", "https://light.dsbcontrol.de/DSBlightWebsite/Homepage//Player.aspx?ID=" + id);
        String response = this.httpGet("https://light.dsbcontrol.de/DSBlightWebsite/Homepage//Player.aspx?ID=" + id, ENCODING, referer);
        Document doc = Jsoup.parse((String)response);
        String iframeUrl = doc.select("iframe").first().attr("src");
        response = this.httpGet(iframeUrl, ENCODING, referer);
        doc = Jsoup.parse((String)response);
        if (this.data.has("login") && this.data.getBoolean("login")) {
            if (!(this.credential instanceof UserPasswordCredential)) {
                throw new IllegalArgumentException("no login");
            }
            String username = ((UserPasswordCredential)this.credential).getUsername();
            String password = ((UserPasswordCredential)this.credential).getPassword();
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add((NameValuePair)new BasicNameValuePair("__VIEWSTATE", doc.select("#__VIEWSTATE").attr("value")));
            params.add((NameValuePair)new BasicNameValuePair("__VIEWSTATEGENERATOR", doc.select("#__VIEWSTATEGENERATOR").attr("value")));
            params.add((NameValuePair)new BasicNameValuePair("__EVENTVALIDATION", doc.select("#__EVENTVALIDATION").attr("value")));
            params.add((NameValuePair)new BasicNameValuePair("ctl02$txtBenutzername", username));
            params.add((NameValuePair)new BasicNameValuePair("ctl02$txtPasswort", password));
            params.add((NameValuePair)new BasicNameValuePair("ctl02$btnLogin", "weiter"));
            response = this.httpPost(iframeUrl, ENCODING, params, referer);
            doc = Jsoup.parse((String)response);
            if (doc.select("#ctl02_lblLoginFehlgeschlagen").size() > 0) {
                throw new CredentialInvalidException();
            }
        }
        Pattern regex = Pattern.compile("location\\.href=\"([^\"]*)\"");
        for (Element iframe : doc.select("iframe")) {
            String response2 = this.httpGet(iframe.attr("src"), ENCODING, referer);
            Matcher matcher = regex.matcher(response2);
            if (matcher.find()) {
                String url = matcher.group(1);
                this.parseProgram(url, v, referer);
                continue;
            }
            throw new IOException("URL nicht gefunden");
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        v.setWebsite("https://light.dsbcontrol.de/DSBlightWebsite/Homepage//Player.aspx?ID=" + id);
        return v;
    }

    private void parseProgram(String url, SubstitutionSchedule schedule, Map<String, String> referer) throws IOException, JSONException {
        this.parseProgram(url, schedule, referer, null);
    }

    private void parseProgram(String url, SubstitutionSchedule schedule, Map<String, String> referer, String firstUrl) throws IOException, JSONException {
        String response = this.httpGet(url, ENCODING, referer);
        Document doc = Jsoup.parse((String)response, (String)url);
        if (doc.select("iframe").attr("src").equals(firstUrl)) {
            return;
        }
        for (Element iframe : doc.select("iframe")) {
            this.parseDay(iframe.attr("src"), referer, schedule, iframe.attr("src"));
        }
        if (doc.select("#hlNext").size() > 0) {
            String nextUrl = doc.select("#hlNext").first().attr("abs:href");
            if (firstUrl == null) {
                this.parseProgram(nextUrl, schedule, referer, doc.select("iframe").attr("src"));
            } else {
                this.parseProgram(nextUrl, schedule, referer, firstUrl);
            }
        }
    }

    private void parseDay(String url, Map<String, String> referer, SubstitutionSchedule schedule, String startUrl) throws IOException, JSONException {
        String html = this.httpGet(url, this.data.getString("encoding"), referer);
        Document doc = Jsoup.parse((String)html);
        if (doc.title().toLowerCase().contains("untis") || doc.html().toLowerCase().contains("untis") || doc.select(".mon_list").size() > 0) {
            schedule.addDay(this.parseMonitorVertretungsplanTag((Element)doc, this.data));
            if (doc.select("meta[http-equiv=refresh]").size() > 0) {
                Element meta = doc.select("meta[http-equiv=refresh]").first();
                String attr = meta.attr("content").toLowerCase();
                String redirectUrl = url.substring(0, url.lastIndexOf("/") + 1) + attr.substring(attr.indexOf("url=") + 4);
                if (!redirectUrl.equals(startUrl)) {
                    this.parseDay(redirectUrl, referer, schedule, startUrl);
                }
            }
        }
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        JSONArray classesJson = this.data.getJSONArray("classes");
        ArrayList<String> classes = new ArrayList<String>();
        for (int i = 0; i < classesJson.length(); ++i) {
            classes.add(classesJson.getString(i));
        }
        return classes;
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

