/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import me.vertretungsplan.parser.UntisCommonParser;
import org.apache.http.client.HttpResponseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class UntisInfoParser
extends UntisCommonParser {
    private static final String PARAM_BASEURL = "baseurl";
    private static final String PARAM_ENCODING = "encoding";
    private static final String PARAM_CLASS_SELECT_REGEX = "classSelectRegex";
    private static final String PARAM_REMOVE_NON_MATCHING_CLASSES = "removeNonMatchingClasses";
    private static final String PARAM_SINGLE_CLASSES = "singleClasses";
    private static final String PARAM_W_AFTER_NUMBER = "wAfterNumber";
    private String baseUrl;
    private JSONObject data;
    private String navbarDoc;

    public UntisInfoParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        try {
            this.data = scheduleData.getData();
            this.baseUrl = this.data.getString(PARAM_BASEURL);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private String getNavbarDoc() throws JSONException, IOException {
        if (this.navbarDoc == null) {
            String navbarUrl = this.baseUrl + "/frames/navbar.htm";
            this.navbarDoc = this.httpGet(navbarUrl, this.data.getString(PARAM_ENCODING));
        }
        return this.navbarDoc;
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        String lastChange;
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        Document navbarDoc = Jsoup.parse((String)this.getNavbarDoc().replace("&nbsp;", ""));
        Element select = navbarDoc.select("select[name=week]").first();
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        String info = navbarDoc.select(".description").text();
        try {
            lastChange = info.substring(info.indexOf("Stand:"));
        }
        catch (Exception e) {
            try {
                String infoHtml = this.httpGet(this.baseUrl + "/frames/title.htm", this.data.getString(PARAM_ENCODING));
                Document infoDoc = Jsoup.parse((String)infoHtml);
                String info2 = infoDoc.select(".description").text();
                lastChange = info2.substring(info2.indexOf("Stand:"));
            }
            catch (Exception e1) {
                lastChange = "";
            }
        }
        for (Element option : select.children()) {
            String week = option.attr("value");
            String letter = this.data.optString("letter", "w");
            if (this.data.optBoolean(PARAM_SINGLE_CLASSES, this.data.optBoolean("single_classes", false))) {
                int classNumber = 1;
                for (String klasse : this.getAllClasses()) {
                    String paddedNumber = String.format("%05d", classNumber);
                    String url = this.data.optBoolean(PARAM_W_AFTER_NUMBER, this.data.optBoolean("w_after_number", false)) ? this.baseUrl + "/" + week + "/" + letter + "/" + letter + paddedNumber + ".htm" : this.baseUrl + "/" + letter + "/" + week + "/" + letter + paddedNumber + ".htm";
                    try {
                        Document doc = Jsoup.parse((String)this.httpGet(url, this.data.getString(PARAM_ENCODING)));
                        this.parseDays(v, lastChange, doc, klasse);
                    }
                    catch (HttpResponseException e) {
                        if (e.getStatusCode() == 500) {
                            ++classNumber;
                            continue;
                        }
                        throw e;
                    }
                    ++classNumber;
                }
                continue;
            }
            String url = this.data.optBoolean(PARAM_W_AFTER_NUMBER, this.data.optBoolean("w_after_number", false)) ? this.baseUrl + "/" + week + "/" + letter + "/" + letter + "00000.htm" : this.baseUrl + "/" + letter + "/" + week + "/" + letter + "00000.htm";
            Document doc = Jsoup.parse((String)this.httpGet(url, this.data.getString(PARAM_ENCODING)));
            this.parseDays(v, lastChange, doc, null);
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        v.setWebsite(this.baseUrl + "/default.htm");
        return v;
    }

    private void parseDays(SubstitutionSchedule v, String lastChange, Document doc, String klasse) throws JSONException {
        Elements days = doc.select("#vertretung > p > b, #vertretung > b");
        for (Element dayElem : days) {
            SubstitutionScheduleDay day = new SubstitutionScheduleDay();
            day.setLastChangeString(lastChange);
            day.setLastChange(ParserUtils.parseDateTime(lastChange));
            String date = dayElem.text();
            day.setDateString(date);
            day.setDate(ParserUtils.parseDate(date));
            Element next = dayElem.parent().tagName().equals("p") ? dayElem.parent().nextElementSibling().nextElementSibling() : dayElem.parent().select("p").first().nextElementSibling();
            this.parseDay(day, next, v, klasse);
        }
    }

    @Override
    public List<String> getAllClasses() throws JSONException, IOException {
        if (super.getAllClasses() != null) {
            return super.getAllClasses();
        }
        String js = this.getNavbarDoc();
        Pattern pattern = Pattern.compile("var classes = (\\[[^\\]]*\\]);");
        Matcher matcher = pattern.matcher(js);
        if (matcher.find()) {
            JSONArray classesJson = new JSONArray(matcher.group(1));
            ArrayList<String> classes = new ArrayList<String>();
            for (int i = 0; i < classesJson.length(); ++i) {
                String className = classesJson.getString(i);
                if (this.data.optString(PARAM_CLASS_SELECT_REGEX, null) != null) {
                    Pattern classNamePattern = Pattern.compile(this.data.getString(PARAM_CLASS_SELECT_REGEX));
                    Matcher classNameMatcher = classNamePattern.matcher(className);
                    if (classNameMatcher.find()) {
                        if (classNameMatcher.groupCount() > 0) {
                            StringBuilder builder = new StringBuilder();
                            for (int j = 1; j <= classNameMatcher.groupCount(); ++j) {
                                if (classNameMatcher.group(j) == null) continue;
                                builder.append(classNameMatcher.group(j));
                            }
                            className = builder.toString();
                        } else {
                            className = classNameMatcher.group();
                        }
                    } else if (this.data.optBoolean(PARAM_REMOVE_NON_MATCHING_CLASSES, false)) continue;
                }
                classes.add(className);
            }
            return classes;
        }
        throw new IOException();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

