/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class SVPlanParser
extends BaseParser {
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_ENCODING = "encoding";
    private JSONObject data;

    public SVPlanParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        JSONArray urls = this.data.getJSONArray(PARAM_URLS);
        String encoding = this.data.getString(PARAM_ENCODING);
        ArrayList<Document> docs = new ArrayList<Document>();
        for (int i = 0; i < urls.length(); ++i) {
            String url = urls.get(i) instanceof JSONObject ? urls.getJSONObject(i).getString("url") : urls.getString(i);
            this.loadUrl(url, encoding, docs);
        }
        SubstitutionSchedule v = this.parseSVPlanSchedule(docs);
        return v;
    }

    @NotNull
    SubstitutionSchedule parseSVPlanSchedule(List<Document> docs) throws IOException, JSONException {
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        for (Document doc : docs) {
            if (doc.select(".svp").size() > 0) {
                for (Element svp : doc.select(".svp")) {
                    this.parseSvPlanDay(v, svp, doc);
                }
                continue;
            }
            this.parseSvPlanDay(v, (Element)doc, doc);
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    private void parseSvPlanDay(SubstitutionSchedule v, Element svp, Document doc) throws IOException {
        SubstitutionScheduleDay day;
        if (svp.select(".svp-tabelle, table:has(.Klasse)").size() > 0) {
            day = new SubstitutionScheduleDay();
            String date = "Unbekanntes Datum";
            if (svp.select(".svp-plandatum-heute, .svp-plandatum-morgen, .Titel").size() > 0) {
                date = svp.select(".svp-plandatum-heute, .svp-plandatum-morgen, .Titel").text().trim();
            } else if (doc.title().startsWith("Vertretungsplan f\u00fcr ")) {
                date = doc.title().substring("Vertretungsplan f\u00fcr ".length());
            }
            date = date.replaceAll("\\s+", " ");
            day.setDateString(date);
            day.setDate(ParserUtils.parseDate(date));
            if (svp.select(".svp-uploaddatum, .Stand").size() > 0) {
                String lastChange = svp.select(".svp-uploaddatum, .Stand").text().replace("Aktualisierung: ", "").replace("Stand: ", "");
                day.setLastChangeString(lastChange);
                day.setLastChange(ParserUtils.parseDateTime(lastChange));
            }
            Elements rows = svp.select(".svp-tabelle tr, table:has(.Klasse) tr");
            String lastLesson = "";
            for (Element row : rows) {
                if (row.hasClass("svp-header") || row.parent().select(".gerade").size() > 0 && row.select(".ungerade").size() == 0) continue;
                Substitution substitution = new Substitution();
                ArrayList affectedClasses = new ArrayList();
                for (Element column : row.select("td")) {
                    if (!this.hasData(column.text())) continue;
                    String type = column.className();
                    if (type.startsWith("svp-stunde") || type.startsWith("Stunde")) {
                        substitution.setLesson(column.text());
                        lastLesson = column.text();
                    } else if (type.startsWith("svp-klasse") || type.startsWith("Klasse")) {
                        substitution.getClasses().addAll(Arrays.asList(column.text().split(", ")));
                    } else if (type.startsWith("svp-esfehlt") || type.startsWith("Lehrer")) {
                        substitution.setPreviousTeacher(column.text());
                    } else if (type.startsWith("svp-esvertritt") || type.startsWith("Vertretung")) {
                        substitution.setTeacher(column.text());
                    } else if (type.startsWith("svp-fach") || type.startsWith("Fach")) {
                        substitution.setSubject(column.text());
                    } else if (type.startsWith("svp-bemerkung") || type.startsWith("Anmerkung")) {
                        substitution.setDesc(column.text());
                        String recognizedType = SVPlanParser.recognizeType(column.text());
                        substitution.setType(recognizedType);
                        substitution.setColor(this.colorProvider.getColor(recognizedType));
                    } else if (type.startsWith("svp-raum") || type.startsWith("Raum")) {
                        substitution.setRoom(column.text());
                    }
                    if (substitution.getLesson() != null) continue;
                    substitution.setLesson(lastLesson);
                }
                if (substitution.getType() == null) {
                    substitution.setType("Vertretung");
                    substitution.setColor(this.colorProvider.getColor("Vertretung"));
                }
                day.addSubstitution(substitution);
            }
            if (svp.select("h2:contains(Mitteilungen)").size() > 0) {
                Element h2 = svp.select("h2:contains(Mitteilungen)").first();
                for (Element sibling = h2.nextElementSibling(); sibling != null && sibling.tagName().equals("p"); sibling = sibling.nextElementSibling()) {
                    for (String nachricht : TextNode.createFromEncoded((String)sibling.html(), null).getWholeText().split("<br />\\s*<br />")) {
                        if (!this.hasData(nachricht)) continue;
                        day.addMessage(nachricht);
                    }
                }
            }
        } else {
            throw new IOException("keine SVPlan-Tabelle gefunden");
        }
        v.addDay(day);
    }

    private void loadUrl(String url, String encoding, List<Document> docs) throws IOException {
        String html = this.httpGet(url, encoding).replace("&nbsp;", "");
        Document doc = Jsoup.parse((String)html);
        docs.add(doc);
    }

    @Override
    public List<String> getAllClasses() throws JSONException {
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }

    private boolean hasData(String text) {
        return !text.trim().equals("") && !text.trim().equals("---");
    }
}

