/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;

public class IndiwareParser
extends BaseParser {
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_ENCODING = "encoding";
    protected JSONObject data;
    private static final int MAX_DAYS = 7;
    static final Pattern substitutionPattern = Pattern.compile("f\u00fcr ([^\\s]+) ((?:(?! ,).)+) ?,? ?(.*)");
    static final Pattern cancelPattern = Pattern.compile("([^\\s]+) (.+) f\u00e4llt (:?leider )?aus");
    static final Pattern delayPattern = Pattern.compile("([^\\s]+) (.+) (verlegt nach .*)");
    static final Pattern selfPattern = Pattern.compile("selbst\\. ?,? ?(.*)");
    static final Pattern coursePattern = Pattern.compile("(.*)/ (.*)");
    static final Pattern bracesPattern = Pattern.compile("^\\((.*)\\)$");

    public IndiwareParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        JSONArray urls = this.data.getJSONArray(PARAM_URLS);
        String encoding = this.data.getString(PARAM_ENCODING);
        ArrayList<Document> docs = new ArrayList<Document>();
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        Pattern dateFormatPattern = Pattern.compile("\\{date\\(([^)]+)\\)\\}");
        for (int i = 0; i < urls.length(); ++i) {
            String url = urls.getString(i);
            Matcher matcher = dateFormatPattern.matcher(url);
            if (matcher.find()) {
                String pattern = matcher.group(1);
                for (int j = 0; j < 7; ++j) {
                    LocalDate date = LocalDate.now().plusDays(j);
                    String dateStr = DateTimeFormat.forPattern((String)pattern).print((ReadablePartial)date);
                    String urlWithDate = matcher.replaceFirst(dateStr);
                    try {
                        String xml = this.httpGet(urlWithDate, encoding);
                        docs.add(Jsoup.parse((String)xml, (String)url, (Parser)Parser.xmlParser()));
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                continue;
            }
            String xml = this.httpGet(url, encoding);
            docs.add(Jsoup.parse((String)xml, (String)url, (Parser)Parser.xmlParser()));
        }
        for (Document doc : docs) {
            v.addDay(this.parseIndiwareDay(doc));
        }
        v.setWebsite(urls.getString(0));
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    SubstitutionScheduleDay parseIndiwareDay(Document doc) {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        Element vp = doc.select("vp").first();
        Element kopf = vp.select("kopf").first();
        String date = kopf.select("titel").text().replaceAll("\\(\\w-Woche\\)", "").trim();
        day.setDate(DateTimeFormat.forPattern((String)"EEEE, dd. MMMM yyyy").withLocale(Locale.GERMAN).parseLocalDate(date));
        String lastChange = kopf.select("datum").text();
        day.setLastChange(DateTimeFormat.forPattern((String)"dd.MM.yyyy, HH:mm").withLocale(Locale.GERMAN).parseLocalDateTime(lastChange));
        if (kopf.select("kopfinfo").size() > 0) {
            for (Element kopfinfo : kopf.select("kopfinfo").first().children()) {
                String title = IndiwareParser.kopfinfoTitle(kopfinfo.tagName());
                StringBuilder message = new StringBuilder();
                if (title != null) {
                    message.append("<b>").append(title).append(":").append("</b>").append(" ");
                }
                message.append(kopfinfo.text());
                day.addMessage(message.toString());
            }
        }
        if (vp.select("fuss").size() > 0) {
            Element fuss = vp.select("fuss").first();
            StringBuilder message = new StringBuilder();
            boolean first = true;
            for (Element fusszeile : fuss.select("fusszeile")) {
                if (first) {
                    first = false;
                } else {
                    message.append("\n");
                }
                message.append(fusszeile.select("fussinfo").text());
            }
            day.addMessage(message.toString());
        }
        Element haupt = vp.select("haupt").first();
        for (Element aktion : haupt.select("aktion")) {
            Substitution substitution = new Substitution();
            String type = "Vertretung";
            String course = null;
            for (Element info : aktion.children()) {
                String value = info.text();
                if (value.equals("---")) continue;
                switch (info.tagName()) {
                    case "klasse": {
                        HashSet<String> classes = new HashSet<String>();
                        for (String klasse : value.split(",")) {
                            Matcher courseMatcher = coursePattern.matcher(klasse);
                            if (courseMatcher.matches()) {
                                classes.add(courseMatcher.group(1));
                                course = courseMatcher.group(2);
                                continue;
                            }
                            classes.add(klasse);
                        }
                        substitution.setClasses(classes);
                        break;
                    }
                    case "stunde": {
                        substitution.setLesson(value);
                        break;
                    }
                    case "fach": {
                        StringBuilder subject = new StringBuilder();
                        subject.append(value);
                        if (course != null) {
                            subject.append(" ").append(course);
                        }
                        substitution.setSubject(subject.toString());
                        break;
                    }
                    case "lehrer": {
                        Matcher bracesMatcher = bracesPattern.matcher(value);
                        if (bracesMatcher.matches()) {
                            value = bracesMatcher.group(1);
                        }
                        substitution.setTeacher(value);
                        break;
                    }
                    case "raum": {
                        substitution.setRoom(value);
                        break;
                    }
                    case "info": {
                        Matcher substitutionMatcher = substitutionPattern.matcher(value);
                        Matcher cancelMatcher = cancelPattern.matcher(value);
                        Matcher delayMatcher = delayPattern.matcher(value);
                        Matcher selfMatcher = selfPattern.matcher(value);
                        if (substitutionMatcher.matches()) {
                            substitution.setPreviousSubject(substitutionMatcher.group(1));
                            substitution.setPreviousTeacher(substitutionMatcher.group(2));
                            if (substitutionMatcher.group(3).isEmpty()) break;
                            substitution.setDesc(substitutionMatcher.group(3));
                            break;
                        }
                        if (cancelMatcher.matches()) {
                            type = "Entfall";
                            substitution.setPreviousSubject(cancelMatcher.group(1));
                            substitution.setPreviousTeacher(cancelMatcher.group(2));
                            break;
                        }
                        if (delayMatcher.matches()) {
                            type = "Verlegung";
                            substitution.setPreviousSubject(delayMatcher.group(1));
                            substitution.setPreviousTeacher(delayMatcher.group(2));
                            substitution.setDesc(delayMatcher.group(3));
                            break;
                        }
                        if (selfMatcher.matches()) {
                            type = "selbst.";
                            if (selfMatcher.group(1).isEmpty()) break;
                            substitution.setDesc(selfMatcher.group(1));
                            break;
                        }
                        substitution.setDesc(value);
                    }
                }
            }
            substitution.setType(type);
            substitution.setColor(this.colorProvider.getColor(substitution.getType()));
            if (course != null && substitution.getSubject() == null) {
                substitution.setSubject(course);
            }
            day.addSubstitution(substitution);
        }
        return day;
    }

    private static String kopfinfoTitle(String type) {
        switch (type) {
            case "abwesendl": {
                return "Abwesende Lehrer";
            }
            case "abwesendk": {
                return "Abwesende Klassen";
            }
            case "abwesendr": {
                return "Nicht verf\u00fcgbare R\u00e4ume";
            }
            case "aenderungl": {
                return "Lehrer mit \u00c4nderung";
            }
            case "aenderungk": {
                return "Klassen mit \u00c4nderung";
            }
        }
        return null;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException {
        return null;
    }
}

