/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.objects.authentication.NoAuthenticationData;
import me.vertretungsplan.objects.authentication.PasswordAuthenticationData;
import me.vertretungsplan.objects.credential.PasswordCredential;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.ParserUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class ESchoolParser
extends BaseParser {
    private static final String BASE_URL = "http://eschool.topackt.com/";
    private static final String ENCODING = "ISO-8859-1";
    public static final String PARAM_ID = "id";

    public ESchoolParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        if (!(this.scheduleData.getAuthenticationData() instanceof NoAuthenticationData || this.credential != null && this.credential instanceof PasswordCredential && ((PasswordCredential)this.credential).getPassword() != null && !((PasswordCredential)this.credential).getPassword().isEmpty())) {
            throw new IOException("no login");
        }
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("wp", this.scheduleData.getData().getString(PARAM_ID)));
        nvps.add(new BasicNameValuePair("go", "vplan"));
        nvps.add(new BasicNameValuePair("content", "x14"));
        nvps.add(new BasicNameValuePair("sortby", "S"));
        String url = "http://eschool.topackt.com/?" + URLEncodedUtils.format(nvps, (String)"UTF-8");
        Document doc = Jsoup.parse((String)this.httpGet(url, ENCODING));
        if (doc.select("form[name=loginform]").size() > 0 && this.scheduleData.getAuthenticationData() instanceof PasswordAuthenticationData) {
            ArrayList<NameValuePair> formParams = new ArrayList<NameValuePair>();
            formParams.add((NameValuePair)new BasicNameValuePair("password", ((PasswordCredential)this.credential).getPassword()));
            formParams.add((NameValuePair)new BasicNameValuePair("login", ""));
            doc = Jsoup.parse((String)this.httpPost(url, ENCODING, formParams));
            if (doc.select("font[color=red]").text().contains("fehlgeschlagen")) {
                throw new CredentialInvalidException();
            }
        }
        SubstitutionSchedule schedule = this.parseESchoolSchedule(doc);
        return schedule;
    }

    @NotNull
    SubstitutionSchedule parseESchoolSchedule(Document doc) throws IOException, JSONException {
        SubstitutionSchedule schedule = SubstitutionSchedule.fromData(this.scheduleData);
        String infoString = ((Element)doc.select("#Content table").first().select("td").get(1)).ownText();
        Pattern pattern = Pattern.compile("Letzte Aktualisierung:\u00a0(\\d{2}.\\d{2}.\\d{4} - \\d{2}:\\d{2})");
        Matcher matcher = pattern.matcher(infoString);
        if (matcher.find()) {
            LocalDateTime lastChange = DateTimeFormat.forPattern((String)"dd.MM.yyyy - HH:mm").parseLocalDateTime(matcher.group(1));
            schedule.setLastChange(lastChange);
        }
        Elements titles = doc.select("center b");
        Elements tables = doc.select("table#DATA");
        if (!((Element)tables.get(0)).text().contains("Keine Daten verf\u00fcgbar")) {
            if (titles.size() != tables.size()) {
                throw new IOException("Anzahl \u00dcberschriften != Anzahl Tabellen");
            }
            for (int i = 0; i < titles.size(); ++i) {
                SubstitutionScheduleDay day = new SubstitutionScheduleDay();
                day.setDate(ParserUtils.parseDate(((Element)titles.get(i)).text()));
                this.parseTable((Element)tables.get(i), day);
                schedule.addDay(day);
            }
        }
        schedule.setClasses(this.getAllClasses());
        schedule.setTeachers(this.getAllTeachers());
        return schedule;
    }

    private void parseTable(Element table, SubstitutionScheduleDay day) {
        for (Element th : table.select("th[colspan=10]")) {
            Pattern pattern = Pattern.compile("(\\d+)\\. Stunde");
            Matcher matcher = pattern.matcher(th.text());
            String lesson = matcher.find() ? matcher.group(1) : th.text();
            for (Element row = th.parent().nextElementSibling().nextElementSibling(); row != null && row.select("th").size() == 0; row = row.nextElementSibling()) {
                Substitution subst = new Substitution();
                subst.setLesson(lesson);
                Elements columns = row.select("td");
                String[] classes = ((Element)columns.get(0)).text().split(", ");
                subst.setClasses(new HashSet<String>(Arrays.asList(classes)));
                subst.setPreviousTeacher(this.getPreviousValue((Element)columns.get(1)));
                subst.setTeacher(this.getNewValue((Element)columns.get(1)));
                subst.setPreviousSubject(this.getPreviousValue((Element)columns.get(2)));
                subst.setSubject(this.getNewValue((Element)columns.get(2)));
                subst.setPreviousRoom(this.getPreviousValue((Element)columns.get(3)));
                subst.setRoom(this.getNewValue((Element)columns.get(3)));
                if (((Element)columns.get(4)).text().isEmpty()) {
                    subst.setType("Vertretung");
                    subst.setColor(this.colorProvider.getColor("Vertretung"));
                } else {
                    String desc = ((Element)columns.get(4)).text();
                    subst.setDesc(desc);
                    String recognizedType = ESchoolParser.recognizeType(desc);
                    if (recognizedType == null) {
                        recognizedType = "Vertretung";
                    }
                    subst.setType(recognizedType);
                    subst.setColor(this.colorProvider.getColor(recognizedType));
                }
                day.addSubstitution(subst);
            }
        }
    }

    private String getNewValue(Element cell) {
        List textNodes = cell.textNodes();
        if (textNodes.size() == 1) {
            return ((TextNode)textNodes.get(0)).text().trim();
        }
        if (textNodes.size() == 2) {
            return ((TextNode)textNodes.get(1)).text().trim();
        }
        return null;
    }

    private String getPreviousValue(Element cell) {
        List textNodes = cell.textNodes();
        if (textNodes.size() == 1) {
            return null;
        }
        if (textNodes.size() == 2) {
            return ((TextNode)textNodes.get(0)).text().trim();
        }
        return null;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

