/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.ColorProvider;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class DaVinciParser
extends BaseParser {
    private static final String ENCODING = "UTF-8";
    private static final String PARAM_URL = "url";
    private static final String PARAM_CLASSES_SOURCE = "classesSource";
    public static final String PARAM_EMBEDDED_CONTENT_SELECTOR = "embeddedContentSelector";

    public DaVinciParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    static void parseDaVinciTable(Element table, SubstitutionScheduleDay day, ColorProvider colorProvider) {
        DaVinciParser.parseDaVinciTable(table, day, null, colorProvider);
    }

    static void parseDaVinciTable(Element table, SubstitutionScheduleDay day, String klasse, ColorProvider colorProvider) {
        ArrayList<String> headers = new ArrayList<String>();
        for (Element header : table.select("thead tr th, tr td[bgcolor=#9999FF]")) {
            headers.add(header.text());
        }
        HashSet<String> classes = new HashSet<String>();
        String lesson = null;
        Pattern previousCurrentPattern = Pattern.compile("\\+([^\\s]+) \\(([^)]+)\\)");
        Pattern previousPattern = Pattern.compile("\\(([^)]+)\\)");
        for (Element row : table.select("tr:not(thead tr, tr:has(td[bgcolor=#9999FF]))")) {
            Substitution subst = new Substitution();
            Elements columns = row.select("td");
            block36: for (int i = 0; i < headers.size(); ++i) {
                String value = ((Element)columns.get(i)).text().replace("\u00a0", "");
                String header = (String)headers.get(i);
                if (value.isEmpty()) {
                    if (header.equals("Klasse")) {
                        subst.setClasses(classes);
                    }
                    if (header.equals("Pos") || header.equals("Stunde") || header.equals("Std.")) {
                        subst.setLesson(lesson);
                    }
                    if (!header.equals("Art") && !header.equals("Merkmal")) continue;
                    subst.setType("Vertretung");
                    continue;
                }
                Matcher previousCurrentMatcher = previousCurrentPattern.matcher(value);
                Matcher previousMatcher = previousPattern.matcher(value);
                switch (header) {
                    case "Klasse": {
                        classes = new HashSet<String>(Arrays.asList(value.split(", ")));
                        subst.setClasses(classes);
                        continue block36;
                    }
                    case "Pos": 
                    case "Stunde": 
                    case "Std.": {
                        lesson = value;
                        subst.setLesson(lesson);
                        continue block36;
                    }
                    case "VLehrer K\u00fcrzel": 
                    case "VLehrer": 
                    case "Vertreter": {
                        if (value.startsWith("*")) continue block36;
                        if (value.equals("Raum\u00e4nderung")) {
                            subst.setType(value);
                            continue block36;
                        }
                        subst.setTeacher(value);
                        continue block36;
                    }
                    case "Lehrer": 
                    case "Lehrer K\u00fcrzel": 
                    case "Lehrer Name": {
                        if (previousCurrentMatcher.find()) {
                            subst.setTeacher(previousCurrentMatcher.group(1));
                            subst.setPreviousTeacher(previousCurrentMatcher.group(2));
                            continue block36;
                        }
                        if (previousMatcher.find()) {
                            subst.setPreviousTeacher(previousMatcher.group(1));
                            continue block36;
                        }
                        subst.setPreviousTeacher(value);
                        continue block36;
                    }
                    case "VFach": {
                        subst.setSubject(value);
                        continue block36;
                    }
                    case "Fach": 
                    case "Original Fach": {
                        if (previousCurrentMatcher.find()) {
                            subst.setSubject(previousCurrentMatcher.group(1));
                            subst.setPreviousSubject(previousCurrentMatcher.group(2));
                            continue block36;
                        }
                        subst.setPreviousSubject(value);
                        continue block36;
                    }
                    case "VRaum": {
                        subst.setRoom(value);
                        continue block36;
                    }
                    case "Raum": 
                    case "Original Raum": {
                        if (previousCurrentMatcher.find()) {
                            subst.setRoom(previousCurrentMatcher.group(1));
                            subst.setPreviousRoom(previousCurrentMatcher.group(2));
                            continue block36;
                        }
                        subst.setPreviousRoom(value);
                        continue block36;
                    }
                    case "Art": 
                    case "Merkmal": {
                        subst.setType(value);
                        continue block36;
                    }
                    case "Info": 
                    case "Mitteilung": {
                        subst.setDesc(value);
                        if (!headers.contains("Art") && headers.contains("Merkmal")) continue block36;
                    }
                }
            }
            if (klasse != null) {
                HashSet<String> fixedClasses = new HashSet<String>();
                fixedClasses.add(klasse);
                subst.setClasses(fixedClasses);
            }
            if (subst.getType() == null) {
                String recognizedType = null;
                if (subst.getDesc() != null) {
                    recognizedType = DaVinciParser.recognizeType(subst.getDesc());
                }
                subst.setType(recognizedType != null ? recognizedType : "Vertretung");
            }
            subst.setColor(colorProvider.getColor(subst.getType()));
            day.addSubstitution(subst);
        }
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        SubstitutionSchedule schedule = SubstitutionSchedule.fromData(this.scheduleData);
        String url = this.scheduleData.getData().getString(PARAM_URL);
        Document doc = Jsoup.parse((String)this.httpGet(url, ENCODING));
        List<String> dayUrls = DaVinciParser.getDayUrls(url, doc);
        if (this.scheduleData.getData().has(PARAM_EMBEDDED_CONTENT_SELECTOR)) {
            for (Element el : doc.select(this.scheduleData.getData().getString(PARAM_EMBEDDED_CONTENT_SELECTOR))) {
                schedule.addDay(this.parseDay(el));
            }
        } else {
            for (String dayUrl : dayUrls) {
                Document dayDoc = dayUrl.equals(url) ? doc : Jsoup.parse((String)this.httpGet(dayUrl, ENCODING));
                schedule.addDay(this.parseDay((Element)dayDoc));
            }
        }
        schedule.setWebsite(url);
        schedule.setClasses(this.getAllClasses());
        schedule.setTeachers(this.getAllTeachers());
        return schedule;
    }

    @NotNull
    static List<String> getDayUrls(String url, Document doc) throws IOException {
        ArrayList<String> dayUrls = new ArrayList<String>();
        if (doc.select("ul.classes").size() > 0) {
            Elements classes = doc.select("ul.classes li a");
            for (Element klasse : classes) {
                dayUrls.add(new URL(new URL(url), klasse.attr("href")).toString());
            }
        } else if (doc.select("ul.month").size() > 0) {
            Elements days = doc.select("ul.month li input[onclick]");
            for (Element day : days) {
                String urlFromOnclick = DaVinciParser.urlFromOnclick(day.attr("onclick"));
                if (urlFromOnclick == null) continue;
                dayUrls.add(new URL(new URL(url), urlFromOnclick).toString());
            }
        } else if (doc.select("ul.day-index").size() > 0) {
            Elements days = doc.select("ul.day-index li a");
            for (Element day : days) {
                dayUrls.add(new URL(new URL(url), day.attr("href")).toString());
            }
        } else {
            dayUrls.add(url);
        }
        return dayUrls;
    }

    private static String urlFromOnclick(String onclick) {
        Pattern pattern = Pattern.compile("window\\.location\\.href='([^']+)'");
        Matcher matcher = pattern.matcher(onclick);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @NotNull
    SubstitutionScheduleDay parseDay(Element doc) throws IOException {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        String title = doc.select("h1.list-table-caption").first().text();
        String klasse = null;
        if (title.matches("\\w+ \\d+\\.\\d+.\\d{4}")) {
            day.setDateString(title);
            day.setDate(ParserUtils.parseDate(title));
        } else {
            klasse = title;
            String nextText = doc.select("h1.list-table-caption").first().nextElementSibling().text();
            if (nextText.matches("\\w+ \\d+\\.\\d+.\\d{4}")) {
                day.setDateString(nextText);
                day.setDate(ParserUtils.parseDate(nextText));
            } else {
                throw new IOException("Could not find date");
            }
        }
        for (Element p : doc.select(".row:has(h1.list-table-caption) p")) {
            for (TextNode node : p.textNodes()) {
                if (node.text().trim().isEmpty()) continue;
                day.addMessage(node.text().trim());
            }
        }
        for (Element message : doc.select(".callout")) {
            for (TextNode node : message.textNodes()) {
                if (node.text().trim().isEmpty()) continue;
                day.addMessage(node.text().trim());
            }
        }
        String lastChange = doc.select(".row.copyright div").first().ownText();
        Pattern pattern = Pattern.compile("(\\d{2}-\\d{2}-\\d{4} \\d{2}:\\d{2}) \\|");
        Matcher matcher = pattern.matcher(lastChange);
        if (matcher.find()) {
            LocalDateTime lastChangeTime = DateTimeFormat.forPattern((String)"dd-MM-yyyy HH:mm").parseLocalDateTime(matcher.group(1));
            day.setLastChange(lastChangeTime);
        }
        if (doc.select(".list-table").size() > 0 || !doc.select(".callout").text().contains("Es liegen keine")) {
            Element table = doc.select(".list-table").first();
            DaVinciParser.parseDaVinciTable(table, day, klasse, this.colorProvider);
        }
        return day;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        if (this.scheduleData.getData().has(PARAM_CLASSES_SOURCE)) {
            Document doc = Jsoup.parse((String)this.httpGet(this.scheduleData.getData().getString(PARAM_CLASSES_SOURCE), ENCODING));
            ArrayList<String> classes = new ArrayList<String>();
            for (Element li : doc.select("li.Class")) {
                classes.add(li.text());
            }
            return classes;
        }
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

