/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.ColorProvider;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class DaVinciParser
extends BaseParser {
    private static final String ENCODING = "UTF-8";
    private static final String PARAM_URL = "url";
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_CLASSES_SOURCE = "classesSource";
    private static final String PARAM_EMBEDDED_CONTENT_SELECTOR = "embeddedContentSelector";
    private static final String PARAM_WEBSITE = "website";

    public DaVinciParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    static void parseDaVinciTable(Element table, SubstitutionSchedule v, ColorProvider colorProvider) throws IOException {
        DaVinciParser.parseDaVinciTable(table, v, null, null, colorProvider);
    }

    static void parseDaVinciTable(Element table, SubstitutionSchedule v, SubstitutionScheduleDay day, ColorProvider colorProvider) throws IOException {
        DaVinciParser.parseDaVinciTable(table, v, null, day, colorProvider);
    }

    static void parseDaVinciTable(Element table, SubstitutionSchedule v, String klasse, SubstitutionScheduleDay day, ColorProvider colorProvider) throws IOException {
        boolean skipRow = false;
        ArrayList<String> headers = new ArrayList<String>();
        for (Element header : table.select("thead tr th")) {
            headers.add(header.text());
        }
        if (headers.size() == 0) {
            skipRow = true;
            for (Element header : table.select(" tr:first-child td")) {
                headers.add(header.text());
            }
        }
        HashSet<String> classes = new HashSet();
        String lesson = null;
        LocalDate currentDate = null;
        Pattern previousCurrentPattern = Pattern.compile("\\+([^\\s]+) \\(([^)]+)\\)");
        Pattern previousPattern = Pattern.compile("\\(([^)]+)\\)");
        for (Element row : table.select("tr:not(thead tr)")) {
            if (skipRow) {
                skipRow = false;
                continue;
            }
            Substitution subst = new Substitution();
            LocalDate substDate = null;
            Elements columns = row.select("td");
            block49: for (int i = 0; i < headers.size(); ++i) {
                String value = ((Element)columns.get(i)).text().replace("\u00a0", "");
                String header = (String)headers.get(i);
                if (value.isEmpty()) {
                    if (header.equals("Klasse")) {
                        subst.setClasses(new HashSet<String>(classes));
                    }
                    if (header.equals("Pos") || header.equals("Stunde") || header.equals("Std.") || header.equals("Dstd.") || header.equals("UE")) {
                        subst.setLesson(lesson);
                    }
                    if (header.equals("Art") || header.equals("Merkmal")) {
                        subst.setType("Vertretung");
                    }
                    if (!header.equals("Datum")) continue;
                    substDate = currentDate;
                    continue;
                }
                Matcher previousCurrentMatcher = previousCurrentPattern.matcher(value);
                Matcher previousMatcher = previousPattern.matcher(value);
                switch (header) {
                    case "Klasse": {
                        String classesStr = value;
                        if (previousMatcher.find()) {
                            classesStr = previousMatcher.group(1);
                        }
                        classes = new HashSet<String>(Arrays.asList(classesStr.split(", ")));
                        subst.setClasses(classes);
                        continue block49;
                    }
                    case "Pos": 
                    case "Stunde": 
                    case "Std.": 
                    case "Dstd.": 
                    case "UE": {
                        lesson = value;
                        subst.setLesson(lesson);
                        continue block49;
                    }
                    case "VLehrer": 
                    case "VLehrer K\u00fcrzel": 
                    case "VLehrer Name": 
                    case "Vertreter": 
                    case "Vertretungslehrkraft": {
                        if (!value.startsWith("*")) {
                            subst.setTeacher(value);
                            continue block49;
                        }
                        subst.setType(value.substring(1));
                        continue block49;
                    }
                    case "Lehrer": 
                    case "Lehrer K\u00fcrzel": 
                    case "Lehrer Name": 
                    case "Lehrkraft": {
                        if (previousCurrentMatcher.find()) {
                            subst.setTeacher(previousCurrentMatcher.group(1));
                            subst.setPreviousTeacher(previousCurrentMatcher.group(2));
                            continue block49;
                        }
                        if (previousMatcher.find()) {
                            subst.setPreviousTeacher(previousMatcher.group(1));
                            continue block49;
                        }
                        subst.setPreviousTeacher(value);
                        continue block49;
                    }
                    case "VFach": 
                    case "V Fach": {
                        subst.setSubject(value);
                        continue block49;
                    }
                    case "Fach": 
                    case "Original Fach": {
                        if (previousCurrentMatcher.find()) {
                            subst.setSubject(previousCurrentMatcher.group(1));
                            subst.setPreviousSubject(previousCurrentMatcher.group(2));
                            continue block49;
                        }
                        subst.setPreviousSubject(value);
                        continue block49;
                    }
                    case "VRaum": 
                    case "V Raum": 
                    case "Vertretungs Raum": {
                        subst.setRoom(value);
                        continue block49;
                    }
                    case "Raum": 
                    case "Original Raum": {
                        if (previousCurrentMatcher.find()) {
                            subst.setRoom(previousCurrentMatcher.group(1));
                            subst.setPreviousRoom(previousCurrentMatcher.group(2));
                            continue block49;
                        }
                        subst.setPreviousRoom(value);
                        continue block49;
                    }
                    case "Art": 
                    case "Merkmal": 
                    case "Information": {
                        subst.setType(value);
                        continue block49;
                    }
                    case "Info": 
                    case "Mitteilung": 
                    case "Bemerkung": {
                        subst.setDesc(value);
                        continue block49;
                    }
                    case "Datum": {
                        currentDate = substDate = ParserUtils.parseDate(value);
                    }
                }
            }
            if (klasse != null) {
                HashSet<String> fixedClasses = new HashSet<String>();
                fixedClasses.add(klasse);
                subst.setClasses(fixedClasses);
            }
            if (subst.getType() == null) {
                String recognizedType = null;
                if (subst.getDesc() != null) {
                    recognizedType = DaVinciParser.recognizeType(subst.getDesc());
                }
                subst.setType(recognizedType != null ? recognizedType : "Vertretung");
            }
            subst.setColor(colorProvider.getColor(subst.getType()));
            if (substDate == null && day == null) continue;
            if (day == null || substDate != null && !substDate.equals((Object)day.getDate())) {
                day = null;
                for (SubstitutionScheduleDay d : v.getDays()) {
                    if (!d.getDate().equals(substDate)) continue;
                    day = d;
                }
                if (day == null) {
                    day = new SubstitutionScheduleDay();
                    day.setDate(substDate);
                    v.addDay(day);
                }
            }
            day.addSubstitution(subst);
        }
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        SubstitutionSchedule schedule = SubstitutionSchedule.fromData(this.scheduleData);
        ArrayList<String> urls = new ArrayList<String>();
        if (this.scheduleData.getData().has(PARAM_URLS)) {
            JSONArray urlsArray = this.scheduleData.getData().getJSONArray(PARAM_URLS);
            for (int i = 0; i < urlsArray.length(); ++i) {
                urls.add(urlsArray.getString(i));
            }
        } else {
            urls.add(this.scheduleData.getData().getString(PARAM_URL));
        }
        int successfulSchedules = 0;
        IOException lastException = null;
        for (String url : urls) {
            try {
                Document doc = Jsoup.parse((String)this.httpGet(url, ENCODING));
                List<String> dayUrls = DaVinciParser.getDayUrls(url, doc);
                if (this.scheduleData.getData().has(PARAM_EMBEDDED_CONTENT_SELECTOR)) {
                    for (Element el : doc.select(this.scheduleData.getData().getString(PARAM_EMBEDDED_CONTENT_SELECTOR))) {
                        DaVinciParser.parsePage(el, schedule, this.colorProvider);
                    }
                } else {
                    for (String dayUrl : dayUrls) {
                        Document dayDoc = dayUrl.equals(url) ? doc : Jsoup.parse((String)this.httpGet(dayUrl, ENCODING));
                        DaVinciParser.parsePage((Element)dayDoc, schedule, this.colorProvider);
                    }
                }
                ++successfulSchedules;
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (successfulSchedules == 0 && lastException != null) {
            throw lastException;
        }
        if (this.scheduleData.getData().has(PARAM_WEBSITE)) {
            schedule.setWebsite(this.scheduleData.getData().getString(PARAM_WEBSITE));
        } else {
            schedule.setWebsite((String)urls.get(0));
        }
        schedule.setClasses(this.getAllClasses());
        schedule.setTeachers(this.getAllTeachers());
        return schedule;
    }

    @NotNull
    static List<String> getDayUrls(String url, Document doc) throws IOException {
        ArrayList<String> dayUrls = new ArrayList<String>();
        if (doc.select("ul.classes").size() > 0) {
            Elements classes = doc.select("ul.classes li a");
            for (Element klasse : classes) {
                dayUrls.add(new URL(new URL(url), klasse.attr("href")).toString());
            }
        } else if (doc.select("ul.month").size() > 0) {
            Elements days = doc.select("ul.month li input[onclick]");
            for (Element day : days) {
                String urlFromOnclick = DaVinciParser.urlFromOnclick(day.attr("onclick"));
                if (urlFromOnclick == null) continue;
                dayUrls.add(new URL(new URL(url), urlFromOnclick).toString());
            }
        } else if (doc.select("ul.day-index").size() > 0) {
            Elements days = doc.select("ul.day-index li a");
            for (Element day : days) {
                dayUrls.add(new URL(new URL(url), day.attr("href")).toString());
            }
        } else if (doc.select("table td[align=left] a").size() > 0) {
            Elements classes = doc.select("table td[align=left] a");
            for (Element klasse : classes) {
                dayUrls.add(new URL(new URL(url), klasse.attr("href")).toString());
            }
        } else {
            dayUrls.add(url);
        }
        return dayUrls;
    }

    private static String urlFromOnclick(String onclick) {
        Pattern pattern = Pattern.compile("window\\.location\\.href='([^']+)'");
        Matcher matcher = pattern.matcher(onclick);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @NotNull
    static void parsePage(Element doc, SubstitutionSchedule schedule, ColorProvider colorProvider) throws IOException {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        Element titleElem = doc.select("h1.list-table-caption").size() > 0 ? doc.select("h1.list-table-caption").first() : doc.select("h2").first();
        String title = titleElem.text();
        String klasse = null;
        Pattern datePattern = Pattern.compile("\\d+\\.\\d+.\\d{4}");
        Matcher dateMatcher = datePattern.matcher(title);
        if (dateMatcher.find()) {
            day.setDateString(dateMatcher.group());
            day.setDate(ParserUtils.parseDate(dateMatcher.group()));
        } else {
            klasse = title;
            String nextText = titleElem.nextElementSibling().text();
            if (nextText.matches("\\w+ \\d+\\.\\d+.\\d{4}")) {
                day.setDateString(nextText);
                day.setDate(ParserUtils.parseDate(nextText));
            } else {
                day = null;
            }
        }
        ArrayList<String> messages = new ArrayList<String>();
        for (Element p : doc.select(".row:has(h1.list-table-caption) p, .callout")) {
            for (TextNode node : p.textNodes()) {
                String msg = node.text().trim();
                if (msg.isEmpty()) continue;
                if (day != null) {
                    day.addMessage(msg);
                    continue;
                }
                messages.add(msg);
            }
        }
        Element lastChangeElem = doc.select(".row.copyright div").first();
        if (lastChangeElem == null) {
            lastChangeElem = doc.select("h1").first();
        }
        if (lastChangeElem != null) {
            String lastChange = lastChangeElem.ownText();
            Pattern pattern = Pattern.compile("(\\d{2}-\\d{2}-\\d{4} \\d{2}:\\d{2}) \\|");
            Matcher matcher = pattern.matcher(lastChange);
            if (matcher.find()) {
                LocalDateTime lastChangeTime = DateTimeFormat.forPattern((String)"dd-MM-yyyy HH:mm").parseLocalDateTime(matcher.group(1));
                if (day != null) {
                    day.setLastChange(lastChangeTime);
                } else {
                    schedule.setLastChange(lastChangeTime);
                }
            } else {
                Pattern pattern2 = Pattern.compile("(\\d{2}.\\d{2}.\\d{4} \\| \\d+:\\d{2})");
                Matcher matcher2 = pattern2.matcher(lastChange);
                if (matcher2.find()) {
                    LocalDateTime lastChangeTime = DateTimeFormat.forPattern((String)"dd.MM.yyyy | HH:mm").parseLocalDateTime(matcher2.group(1));
                    if (day != null) {
                        day.setLastChange(lastChangeTime);
                    } else {
                        schedule.setLastChange(lastChangeTime);
                    }
                }
            }
        } else {
            Pattern pattern = Pattern.compile("<!-- Created by daVinci 5 \\| (\\d+\\.\\d+\\.\\d+ \\| \\d+:\\d+) \\| www.stueber.de -->");
            Matcher matcher = pattern.matcher(doc.html());
            if (matcher.find()) {
                String str = matcher.group(1);
                LocalDateTime date = DateTimeFormat.forPattern((String)"dd.MM.yyyy | HH:mm").parseLocalDateTime(str);
                if (day != null) {
                    day.setLastChange(date);
                } else {
                    schedule.setLastChange(date);
                }
            }
        }
        if (doc.select(".list-table").size() > 0 || !doc.select(".callout").text().contains("Es liegen keine")) {
            Element table = doc.select(".list-table, table").first();
            DaVinciParser.parseDaVinciTable(table, schedule, klasse, day, colorProvider);
        }
        if (day != null) {
            for (String msg : messages) {
                day.addMessage(msg);
            }
            schedule.addDay(day);
        }
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException {
        if (this.scheduleData.getData().has(PARAM_CLASSES_SOURCE)) {
            Document doc = Jsoup.parse((String)this.httpGet(this.scheduleData.getData().getString(PARAM_CLASSES_SOURCE), ENCODING));
            ArrayList<String> classes = new ArrayList<String>();
            Elements elems = doc.select("li.Class");
            if (elems.size() == 0) {
                elems = doc.select("td[align=left] a");
            }
            for (Element li : elems) {
                classes.add(li.text());
            }
            return classes;
        }
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

