/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.additionalinfo;

import biweekly.Biweekly;
import biweekly.ICalendar;
import biweekly.component.VEvent;
import biweekly.io.TimezoneAssignment;
import biweekly.io.TimezoneInfo;
import biweekly.property.ICalProperty;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import me.vertretungsplan.additionalinfo.BaseAdditionalInfoParser;
import me.vertretungsplan.objects.AdditionalInfo;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class BaseIcalParser
extends BaseAdditionalInfoParser {
    protected abstract String getIcalUrl();

    protected String getTitle() {
        return "Termine";
    }

    protected int getMaxItemsCount() {
        return 4;
    }

    @Override
    public AdditionalInfo getAdditionalInfo() throws IOException {
        AdditionalInfo info = new AdditionalInfo();
        info.setTitle(this.getTitle());
        String rawdata = this.httpGet(this.getIcalUrl(), "UTF-8");
        if (this.shouldStripTimezoneInfo()) {
            Pattern pattern = Pattern.compile("BEGIN:VTIMEZONE.*END:VTIMEZONE", 32);
            rawdata = pattern.matcher(rawdata).replaceAll("");
        }
        DateTime now = DateTime.now().withTimeAtStartOfDay();
        List icals = Biweekly.parse((String)rawdata).all();
        ArrayList<Event> events = new ArrayList<Event>();
        for (ICalendar ical : icals) {
            for (VEvent event : ical.getEvents()) {
                Event item = new Event();
                TimeZone timezoneStart = this.getTimeZoneStart(ical, event);
                if (event.getDescription() != null) {
                    item.description = (String)event.getDescription().getValue();
                }
                if (event.getSummary() != null) {
                    item.summary = (String)event.getSummary().getValue();
                }
                if (event.getDateStart() == null) continue;
                item.startDate = new DateTime(event.getDateStart().getValue());
                item.startHasTime = ((ICalDate)event.getDateStart().getValue()).hasTime();
                if (event.getDateEnd() != null) {
                    item.endDate = new DateTime(event.getDateEnd().getValue());
                    item.endHasTime = ((ICalDate)event.getDateEnd().getValue()).hasTime();
                }
                if (event.getLocation() != null) {
                    item.location = (String)event.getLocation().getValue();
                }
                if (event.getUrl() != null) {
                    item.url = (String)event.getUrl().getValue();
                }
                if (event.getRecurrenceRule() == null && item.endDate != null && item.endDate.compareTo((ReadableInstant)now) < 0 || event.getRecurrenceRule() == null && item.startDate.compareTo((ReadableInstant)now) < 0 || event.getRecurrenceRule() != null && ((Recurrence)event.getRecurrenceRule().getValue()).getUntil() != null && ((Recurrence)event.getRecurrenceRule().getValue()).getUntil().compareTo(now.toDate()) < 0) continue;
                if (event.getRecurrenceRule() != null) {
                    Duration duration = null;
                    if (event.getDateEnd() != null) {
                        duration = new Duration((ReadableInstant)new DateTime(event.getDateStart().getValue()), (ReadableInstant)new DateTime(event.getDateEnd().getValue()));
                    }
                    DateIterator iterator = event.getDateIterator(timezoneStart);
                    while (iterator.hasNext()) {
                        Date date = (Date)iterator.next();
                        Event reccitem = item.clone();
                        reccitem.startDate = new DateTime((Object)date);
                        reccitem.endDate = reccitem.startDate.plus((ReadableDuration)duration);
                        if (item.startDate.equals((Object)reccitem.startDate) || item.endDate != null && item.endDate.compareTo((ReadableInstant)now) < 0 || item.endDate == null && item.startDate.compareTo((ReadableInstant)now) < 0) continue;
                        events.add(reccitem);
                    }
                }
                if (item.endDate != null && item.endDate.compareTo((ReadableInstant)now) < 0 || item.endDate == null && item.startDate.compareTo((ReadableInstant)now) < 0) continue;
                events.add(item);
            }
        }
        Collections.sort(events, new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                return o1.startDate.compareTo((ReadableInstant)o2.startDate);
            }
        });
        StringBuilder content = new StringBuilder();
        int count = 0;
        DateTimeFormatter fmtDt = DateTimeFormat.shortDateTime().withLocale(Locale.GERMANY);
        DateTimeFormatter fmtD = DateTimeFormat.shortDate().withLocale(Locale.GERMANY);
        DateTimeFormatter fmtT = DateTimeFormat.shortTime().withLocale(Locale.GERMANY);
        for (Event item : events) {
            if (count >= this.getMaxItemsCount()) break;
            if (count != 0) {
                content.append("<br><br>\n\n");
            }
            DateTime start = item.startDate;
            if (item.endDate != null) {
                DateTime end = item.endDate;
                if (!item.endHasTime) {
                    end = end.minusDays(1);
                }
                content.append((item.startHasTime ? fmtDt : fmtD).print((ReadableInstant)start));
                if (!end.equals((Object)start)) {
                    content.append(" - ");
                    if (item.startHasTime && item.endHasTime && end.toLocalDate().equals((Object)start.toLocalDate())) {
                        content.append(fmtT.print((ReadableInstant)end));
                    } else {
                        content.append((item.endHasTime ? fmtDt : fmtD).print((ReadableInstant)end));
                    }
                }
            } else {
                content.append(fmtDt.print((ReadableInstant)start));
            }
            content.append("<br>\n");
            content.append("<b>");
            content.append(item.summary);
            content.append("</b>");
            ++count;
        }
        info.setText(content.toString());
        return info;
    }

    protected boolean shouldStripTimezoneInfo() {
        return false;
    }

    private TimeZone getTimeZoneStart(ICalendar ical, VEvent event) {
        TimezoneAssignment dtstartTimezone;
        if (event.getDateStart() == null) {
            return null;
        }
        TimezoneInfo tzinfo = ical.getTimezoneInfo();
        TimeZone timezone = tzinfo.isFloating((ICalProperty)event.getDateStart()) ? TimeZone.getDefault() : ((dtstartTimezone = tzinfo.getTimezone((ICalProperty)event.getDateStart())) == null ? TimeZone.getTimeZone("UTC") : dtstartTimezone.getTimeZone());
        return timezone;
    }

    private class Event
    implements Cloneable {
        public String summary;
        public String description;
        public String location;
        public DateTime startDate;
        public DateTime endDate;
        public String url;
        public boolean startHasTime;
        public boolean endHasTime;

        private Event() {
        }

        protected Event clone() {
            Event clone = new Event();
            clone.summary = this.summary;
            clone.description = this.description;
            clone.location = this.location;
            clone.startDate = this.startDate;
            clone.endDate = this.endDate;
            clone.url = this.url;
            return clone;
        }
    }
}

