/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import me.vertretungsplan.parser.UntisCommonParser;
import org.apache.http.client.HttpResponseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class UntisSubstitutionParser
extends UntisCommonParser {
    private static final String PARAM_BASEURL = "baseurl";
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_ENCODING = "encoding";
    private static final String PARAM_WEBSITE = "website";
    private List<String> urls;
    private JSONObject data;

    public UntisSubstitutionParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        try {
            this.data = scheduleData.getData();
            this.urls = new ArrayList<String>();
            if (this.data.has(PARAM_BASEURL)) {
                this.urls.add(this.data.getString(PARAM_BASEURL));
            } else {
                JSONArray urlsArray = this.data.getJSONArray(PARAM_URLS);
                for (int i = 0; i < urlsArray.length(); ++i) {
                    this.urls.add(urlsArray.getString(i));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        String encoding = this.data.optString(PARAM_ENCODING, null);
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        int successfulSchedules = 0;
        HttpResponseException lastExceptionSchedule = null;
        for (String baseUrl : ParserUtils.handleUrls(this.urls)) {
            try {
                Document doc = Jsoup.parse((String)this.httpGet(baseUrl, encoding));
                Elements classes = doc.select("td a");
                String lastChange = doc.select("td[align=right]:not(:has(b))").text();
                int successfulClasses = 0;
                HttpResponseException lastExceptionClass = null;
                for (Element klasse : classes) {
                    try {
                        Document classDoc = Jsoup.parse((String)this.httpGet(baseUrl.substring(0, baseUrl.lastIndexOf("/")) + "/" + klasse.attr("href"), encoding));
                        this.parseSubstitutionTable(v, lastChange, classDoc, klasse.text());
                        ++successfulClasses;
                    }
                    catch (HttpResponseException e) {
                        lastExceptionClass = e;
                    }
                }
                if (successfulClasses == 0 && lastExceptionClass != null) {
                    throw lastExceptionClass;
                }
                ++successfulSchedules;
            }
            catch (HttpResponseException e) {
                lastExceptionSchedule = e;
            }
        }
        if (successfulSchedules == 0 && lastExceptionSchedule != null) {
            throw lastExceptionSchedule;
        }
        if (this.data.has(PARAM_WEBSITE)) {
            v.setWebsite(this.data.getString(PARAM_WEBSITE));
        } else {
            v.setWebsite(this.urls.get(0));
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

