/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import me.vertretungsplan.parser.UntisCommonParser;
import org.apache.http.client.HttpResponseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class UntisMonitorParser
extends UntisCommonParser {
    private static final int MAX_RECURSION_DEPTH = 30;
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_ENCODING = "encoding";
    private static final String PARAM_EMBEDDED_CONTENT_SELECTOR = "embeddedContentSelector";
    private static final String PARAM_LAST_CHANGE_SELECTOR = "lastChangeSelector";
    private static final String PARAM_WEBSITE = "website";
    private static final String PARAM_FORCE_ALL_PAGES = "forceAllPages";
    private static final String SUBPARAM_FOLLOWING = "following";
    private static final String SUBPARAM_URL = "url";
    private static final String VALUE_URL_LOGIN_RESPONSE = "loginResponse";
    private static final Pattern VALUE_URL_LOGIN_RESPONSE_LINK_SELECTOR = Pattern.compile("loginResponse\\((.*)\\)");
    private String loginResponse;

    public UntisMonitorParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        this.loginResponse = new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLoginWithResponse(this.executor, this.cookieStore);
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        JSONArray urls = this.scheduleData.getData().getJSONArray(PARAM_URLS);
        String encoding = this.scheduleData.getData().optString(PARAM_ENCODING, null);
        ArrayList<Document> docs = new ArrayList<Document>();
        for (int i = 0; i < urls.length(); ++i) {
            JSONObject url = urls.getJSONObject(i);
            String urlStr = url.getString(SUBPARAM_URL);
            for (String dateUrl : ParserUtils.handleUrl(urlStr, this.loginResponse)) {
                this.loadUrl(dateUrl, encoding, url.getBoolean(SUBPARAM_FOLLOWING), docs);
            }
        }
        for (Document doc : docs) {
            if (this.scheduleData.getData().has(PARAM_EMBEDDED_CONTENT_SELECTOR)) {
                for (Element part : doc.select(this.scheduleData.getData().getString(PARAM_EMBEDDED_CONTENT_SELECTOR))) {
                    SubstitutionScheduleDay day = this.parseMonitorDay(part, this.scheduleData.getData());
                    v.addDay(day);
                }
            } else if (doc.title().contains("Untis") || doc.html().contains("<!--<title>Untis")) {
                SubstitutionScheduleDay day = this.parseMonitorDay((Element)doc, this.scheduleData.getData());
                v.addDay(day);
            } else if (docs.size() == 0 || this.scheduleData.getData().optBoolean(PARAM_FORCE_ALL_PAGES)) {
                throw new IOException("Seems like there is no Untis schedule here");
            }
            if (!this.scheduleData.getData().has(PARAM_LAST_CHANGE_SELECTOR) || doc.select(this.scheduleData.getData().getString(PARAM_LAST_CHANGE_SELECTOR)).size() <= 0) continue;
            String text = doc.select(this.scheduleData.getData().getString(PARAM_LAST_CHANGE_SELECTOR)).first().text();
            Pattern pattern = Pattern.compile("\\d\\d\\.\\d\\d\\.\\d\\d\\d\\d,? \\d\\d:\\d\\d");
            Matcher matcher = pattern.matcher(text);
            String lastChange = matcher.find() ? matcher.group() : text;
            v.setLastChangeString(lastChange);
            v.setLastChange(ParserUtils.parseDateTime(lastChange));
        }
        if (this.scheduleData.getData().has(PARAM_WEBSITE)) {
            v.setWebsite(this.scheduleData.getData().getString(PARAM_WEBSITE));
        } else if (urls.length() == 1) {
            v.setWebsite(urls.getJSONObject(0).getString(SUBPARAM_URL));
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    private void loadUrl(String url, String encoding, boolean following, List<Document> docs, String startUrl, int recursionDepth) throws IOException, CredentialInvalidException {
        Document doc;
        String html;
        Matcher matcher = VALUE_URL_LOGIN_RESPONSE_LINK_SELECTOR.matcher(url);
        if (url.equals(VALUE_URL_LOGIN_RESPONSE)) {
            html = this.loginResponse;
        } else {
            if (matcher.matches()) {
                doc = Jsoup.parse((String)this.loginResponse);
                try {
                    doc.setBaseUri(this.scheduleData.getData().getJSONObject("login").getString(SUBPARAM_URL));
                    html = this.httpGet(doc.select(matcher.group(1)).first().absUrl("href"));
                }
                catch (JSONException e) {
                    throw new IOException(e);
                }
            }
            try {
                html = this.httpGet(url, encoding).replace("&nbsp;", "");
            }
            catch (HttpResponseException e) {
                if (docs.size() == 0 || this.scheduleData.getData().optBoolean(PARAM_FORCE_ALL_PAGES)) {
                    throw e;
                }
                return;
            }
        }
        doc = Jsoup.parse((String)html);
        doc.setBaseUri(url);
        if (doc.select(".mon_title").size() == 0) {
            if (doc.select("frameset frame[name").size() > 0) {
                for (Element frame : doc.select("frameset frame")) {
                    if (!frame.attr("src").matches(".*subst_\\d\\d\\d.html?") || recursionDepth >= 30) continue;
                    String frameUrl = frame.absUrl("src");
                    this.loadUrl(frame.absUrl("src"), encoding, following, docs, frameUrl, recursionDepth + 1);
                }
            } else {
                if (doc.text().contains("registriert")) {
                    throw new CredentialInvalidException();
                }
                if (docs.size() == 0 || this.scheduleData.getData().optBoolean(PARAM_FORCE_ALL_PAGES)) {
                    throw new IOException("Could not find .mon-title, seems like there is no Untis schedule here");
                }
            }
        } else {
            UntisMonitorParser.findSubDocs(docs, html, doc);
            if (following && doc.select("meta[http-equiv=refresh]").size() > 0) {
                Element meta = doc.select("meta[http-equiv=refresh]").first();
                String attr = meta.attr("content").toLowerCase();
                String redirectUrl = attr.substring(attr.indexOf("url=") + 4);
                Matcher ownCloudMatcher = Pattern.compile("index\\.php/s/[\\w]+/download\\?path=([^&]+)&files=([^&]+)").matcher(url);
                redirectUrl = ownCloudMatcher.find() ? url.substring(0, ownCloudMatcher.start(2)) + redirectUrl + url.substring(ownCloudMatcher.end(2)) : url.substring(0, url.lastIndexOf("/") + 1) + redirectUrl;
                if (!redirectUrl.equals(startUrl) && recursionDepth < 30) {
                    this.loadUrl(redirectUrl, encoding, true, docs, startUrl, recursionDepth + 1);
                }
            }
        }
    }

    static void findSubDocs(List<Document> docs, String html, Document doc) {
        Pattern pattern = Pattern.compile("(<html>.*?</html>)", 32);
        Matcher matcher = pattern.matcher(html);
        ArrayList<String> subHtmls = new ArrayList<String>();
        while (matcher.find()) {
            subHtmls.add(matcher.group());
        }
        if (subHtmls.size() > 1) {
            for (String subHtml : subHtmls) {
                docs.add(Jsoup.parse((String)subHtml));
            }
        } else {
            docs.add(doc);
        }
    }

    private void loadUrl(String url, String encoding, boolean following, List<Document> docs) throws IOException, CredentialInvalidException {
        this.loadUrl(url, encoding, following, docs, url, 0);
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

