/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.ColumnTypeDetector;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.ParserUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public abstract class UntisCommonParser
extends BaseParser {
    private static final String[] EXCLUDED_CLASS_NAMES = new String[]{"-----"};
    private static final String PARAM_LAST_CHANGE_LEFT = "lastChangeLeft";
    private static final String PARAM_LAST_CHANGE_SELECTOR = "lastChangeSelector";
    private static final String PARAM_CLASS_IN_EXTRA_LINE = "classInExtraLine";
    private static final String PARAM_TEACHER_IN_EXTRA_LINE = "teacherInExtraLine";
    private static final String PARAM_COLUMNS = "columns";
    private static final String PARAM_CLASSES_SEPARATED = "classesSeparated";
    private static final String PARAM_EXCLUDE_CLASSES = "excludeClasses";
    private static final String PARAM_TYPE_AUTO_DETECTION = "typeAutoDetection";
    private static final String PARAM_MERGE_WITH_DIFFERENT_TYPE = "mergeWithDifferentType";
    private static final String PARAM_ALL_CLASSES_COURSES = "allClassesCourses";
    private static ColumnTypeDetector detector;

    private static ColumnTypeDetector getDetector() throws IOException, JSONException {
        if (detector == null) {
            detector = new ColumnTypeDetector();
        }
        return detector;
    }

    UntisCommonParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
    }

    static String findLastChange(Element doc, SubstitutionScheduleData scheduleData) {
        String lastChange = null;
        boolean lastChangeLeft = false;
        if (scheduleData != null) {
            lastChangeLeft = scheduleData.getData().has("stand_links") ? scheduleData.getData().optBoolean("stand_links", false) : scheduleData.getData().optBoolean(PARAM_LAST_CHANGE_LEFT, false);
        }
        if (doc.select("table.mon_head").size() > 0) {
            Element monHead = doc.select("table.mon_head").first();
            lastChange = UntisCommonParser.findLastChangeFromMonHeadTable(monHead);
        } else if (lastChangeLeft) {
            String bodyHtml = doc.select("body").size() > 0 ? doc.select("body").html() : doc.html();
            lastChange = bodyHtml.substring(0, bodyHtml.indexOf("<p>") - 1);
        } else {
            List childNodes = doc instanceof Document ? ((Document)doc).body().childNodes() : doc.childNodes();
            for (Node node : childNodes) {
                Comment comment;
                if (!(node instanceof Comment) || !(comment = (Comment)node).getData().contains("<table class=\"mon_head\">")) continue;
                Document commentedDoc = Jsoup.parse((String)comment.getData());
                Element monHead = commentedDoc.select("table.mon_head").first();
                lastChange = UntisCommonParser.findLastChangeFromMonHeadTable(monHead);
                break;
            }
        }
        return lastChange;
    }

    private static String findLastChangeFromMonHeadTable(Element monHead) {
        if (monHead.select("td[align=right]").size() == 0) {
            return null;
        }
        String lastChange = null;
        Pattern pattern = Pattern.compile("\\d\\d\\.\\d\\d\\.\\d\\d\\d\\d \\d\\d:\\d\\d");
        Matcher matcher = pattern.matcher(monHead.select("td[align=right]").first().text());
        if (matcher.find()) {
            lastChange = matcher.group();
        } else if (monHead.text().contains("Stand: ")) {
            lastChange = monHead.text().substring(monHead.text().indexOf("Stand:") + "Stand:".length()).trim();
        }
        return lastChange;
    }

    private static boolean equalsOrNull(String a, String b) {
        return a == null || b == null || a.equals(b);
    }

    void parseSubstitutionScheduleTable(Element table, JSONObject data, SubstitutionScheduleDay day, List<String> allClasses) throws JSONException, CredentialInvalidException, IOException {
        this.parseSubstitutionScheduleTable(table, data, day, null, allClasses, false);
    }

    private void parseSubstitutionScheduleTable(Element table, JSONObject data, SubstitutionScheduleDay day, String defaultClass, List<String> allClasses) throws CredentialInvalidException, IOException, JSONException {
        this.parseSubstitutionScheduleTable(table, data, day, defaultClass, allClasses, false);
    }

    private void parseSubstitutionScheduleTable(Element table, JSONObject data, SubstitutionScheduleDay day, String defaultClass, List<String> allClasses, boolean untisSubst) throws JSONException, CredentialInvalidException, IOException {
        Elements headerRows = table.select("tr:has(th)");
        ArrayList<String> columnTitles = new ArrayList<String>();
        if (headerRows.size() > 0) {
            Elements headers = ((Element)headerRows.get(0)).select("th");
            for (int i = 0; i < headers.size(); ++i) {
                StringBuilder builder = new StringBuilder();
                boolean first = true;
                for (Element headerRow : headerRows) {
                    String text = ((Element)headerRow.select("th").get(i)).text().replace("\u00a0", " ").trim();
                    if (first) {
                        if (!text.equals("")) {
                            first = false;
                        }
                    } else {
                        builder.append(" ");
                    }
                    builder.append(text);
                }
                columnTitles.add(builder.toString());
            }
        }
        this.debuggingDataHandler.columnTitles(columnTitles);
        JSONArray columnsJson = data.optJSONArray(PARAM_COLUMNS);
        ArrayList<String> columns = new ArrayList<String>();
        if (columnTitles.size() == 0) {
            for (int i = 0; i < columnsJson.length(); ++i) {
                columns.add(columnsJson.getString(i));
            }
        } else {
            for (String title : columnTitles) {
                String type = UntisCommonParser.getDetector().getColumnType(title, columnTitles);
                if (type != null) {
                    columns.add(type);
                    continue;
                }
                if (columnsJson != null && columnsJson.length() == columnTitles.size()) {
                    columns.clear();
                    for (int i = 0; i < columnsJson.length(); ++i) {
                        columns.add(columnsJson.getString(i));
                    }
                    break;
                }
                throw new IOException("unknown column title: " + title);
            }
        }
        if (data.optBoolean(PARAM_CLASS_IN_EXTRA_LINE) || data.optBoolean("class_in_extra_line")) {
            for (Element element : table.select("td.inline_header")) {
                String className = this.getClassName(element.text(), data);
                if (!UntisCommonParser.isValidClass(className, data)) continue;
                this.parseWithExtraLine(data, day, columns, element, className, null);
            }
        } else if (data.optBoolean(PARAM_TEACHER_IN_EXTRA_LINE)) {
            for (Element element : table.select("td.inline_header")) {
                String teacherName = this.getClassName(element.text(), data);
                this.parseWithExtraLine(data, day, columns, element, null, teacherName);
            }
        } else {
            boolean hasType = false;
            for (String column : columns) {
                if (!column.equals("type")) continue;
                hasType = true;
            }
            int skipLines = 0;
            for (Element zeile : table.select("tr.list.odd:not(:has(td.inline_header)), tr.list.even:not(:has(td.inline_header)), tr:has(td[align=center]):gt(0)")) {
                if (skipLines > 0) {
                    --skipLines;
                    continue;
                }
                Element previousLine = zeile.previousElementSibling();
                if (this.isGroupMessage(zeile) && previousLine != null && previousLine.select(".inline_header").size() > 0) {
                    this.addGroupMessage(day, this.getClassName(previousLine.text(), data), zeile);
                    continue;
                }
                Substitution v = new Substitution();
                String klassen = defaultClass != null ? defaultClass : "";
                String course = null;
                int i = 0;
                for (Element spalte : zeile.select("td")) {
                    String text = spalte.text();
                    String type = (String)columns.get(i);
                    if (this.isEmpty(text) && !type.equals("type-entfall") && !type.equals("teacher")) {
                        ++i;
                        continue;
                    }
                    int skipLinesForThisColumn = 0;
                    Element nextLine = zeile.nextElementSibling();
                    boolean continueSkippingLines = true;
                    while (continueSkippingLines) {
                        if (nextLine != null && nextLine.children().size() == zeile.children().size()) {
                            Element columnInNextLine = nextLine.child(spalte.elementSiblingIndex().intValue());
                            String nextLineText = columnInNextLine.text().replaceAll("\u00a0", "").trim();
                            if (nextLineText.equals(nextLine.text().replaceAll("\u00a0", "").trim())) {
                                if (untisSubst && i == 0 && !allClasses.contains(nextLineText.split(",")[0])) {
                                    if (day.getMessages().contains(nextLineText)) continue;
                                    day.addMessage(nextLineText);
                                    continueSkippingLines = false;
                                    continue;
                                }
                                text = text + " " + columnInNextLine.text();
                                ++skipLinesForThisColumn;
                                nextLine = nextLine.nextElementSibling();
                                continue;
                            }
                            continueSkippingLines = false;
                            continue;
                        }
                        continueSkippingLines = false;
                    }
                    if (skipLinesForThisColumn > skipLines) {
                        skipLines = skipLinesForThisColumn;
                    }
                    switch (type) {
                        case "lesson": {
                            v.setLesson(text);
                            break;
                        }
                        case "subject": {
                            UntisCommonParser.handleSubject(v, spalte);
                            if (course == null) break;
                            v.setSubject((v.getSubject() != null ? v.getSubject() + " " : "") + course);
                            course = null;
                            break;
                        }
                        case "course": {
                            if (v.getSubject() != null) {
                                v.setSubject(v.getSubject() + " " + text);
                                break;
                            }
                            course = text;
                            break;
                        }
                        case "previousSubject": {
                            v.setPreviousSubject(text);
                            break;
                        }
                        case "type": {
                            v.setType(text);
                            v.setColor(this.colorProvider.getColor(text));
                            break;
                        }
                        case "type-entfall": {
                            if (text.equals("x")) {
                                v.setType("Entfall");
                                v.setColor(this.colorProvider.getColor("Entfall"));
                                break;
                            }
                            if (hasType || v.getType() != null) break;
                            v.setType("Vertretung");
                            v.setColor(this.colorProvider.getColor("Vertretung"));
                            break;
                        }
                        case "room": {
                            UntisCommonParser.handleRoom(v, spalte);
                            break;
                        }
                        case "previousRoom": {
                            v.setPreviousRoom(text);
                            break;
                        }
                        case "desc": {
                            v.setDesc(text);
                            break;
                        }
                        case "desc-type": {
                            v.setDesc(text);
                            String recognizedType = UntisCommonParser.recognizeType(text);
                            v.setType(recognizedType);
                            v.setColor(this.colorProvider.getColor(recognizedType));
                            break;
                        }
                        case "teacher": {
                            if (text.equals("+")) {
                                v.setType("Eigenverantw. Arbeiten");
                                v.setColor(this.colorProvider.getColor(v.getType()));
                                break;
                            }
                            if (this.isEmpty(text)) break;
                            UntisCommonParser.handleTeacher(v, spalte, data, false);
                            break;
                        }
                        case "previousTeacher": {
                            UntisCommonParser.handleTeacher(v, spalte, data, true);
                            break;
                        }
                        case "substitutionFrom": {
                            v.setSubstitutionFrom(text);
                            break;
                        }
                        case "teacherTo": {
                            v.setTeacherTo(text);
                            break;
                        }
                        case "class": {
                            klassen = this.getClassName(text, data);
                            break;
                        }
                        case "ignore": {
                            break;
                        }
                        case "date": {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown column type: " + type);
                        }
                    }
                    ++i;
                }
                if (course != null) {
                    v.setSubject(course);
                }
                if (v.getLesson() == null || v.getLesson().equals("")) continue;
                this.autoDetectType(data, zeile, v);
                UntisCommonParser.handleClasses(data, v, klassen, allClasses);
                if (data.optBoolean(PARAM_MERGE_WITH_DIFFERENT_TYPE, false)) {
                    boolean found = false;
                    for (Substitution subst : day.getSubstitutions()) {
                        if (!subst.equalsExcludingType(v)) continue;
                        found = true;
                        if (!v.getType().equals("Vertretung")) break;
                        subst.setType("Vertretung");
                        subst.setColor(this.colorProvider.getColor("Vertretung"));
                        break;
                    }
                    if (found) continue;
                    day.addSubstitution(v);
                    continue;
                }
                day.addSubstitution(v);
            }
        }
    }

    static void handleClasses(JSONObject data, Substitution v, String klassen, List<String> allClasses) throws JSONException, CredentialInvalidException {
        List<Object> affectedClasses;
        if (data.has(PARAM_ALL_CLASSES_COURSES)) {
            JSONArray arr = data.getJSONArray(PARAM_ALL_CLASSES_COURSES);
            for (int i = 0; i < arr.length(); ++i) {
                String s = arr.getString(i);
                if (!klassen.equals(s)) continue;
                v.getClasses().addAll(allClasses);
                return;
            }
        }
        Pattern singlePattern = Pattern.compile("(\\d{1,2})");
        Matcher singleMatcher = singlePattern.matcher(klassen);
        Pattern rangePattern = Pattern.compile("(\\d+) ?- ?(\\d+)");
        Matcher rangeMatcher = rangePattern.matcher(klassen);
        Pattern pattern2 = Pattern.compile("^(\\d+).*");
        if (rangeMatcher.matches()) {
            affectedClasses = new ArrayList();
            int min = Integer.parseInt(rangeMatcher.group(1));
            int n = Integer.parseInt(rangeMatcher.group(2));
            for (String klasse : allClasses) {
                int num;
                Matcher matcher2 = pattern2.matcher(klasse);
                if (!matcher2.matches() || min > (num = Integer.parseInt(matcher2.group(1))) || num > n) continue;
                affectedClasses.add(klasse);
            }
        } else if (singleMatcher.matches()) {
            affectedClasses = new ArrayList();
            int grade = Integer.parseInt(singleMatcher.group(1));
            for (String klasse : allClasses) {
                Matcher matcher2 = pattern2.matcher(klasse);
                if (!matcher2.matches() || grade != Integer.parseInt(matcher2.group(1))) continue;
                affectedClasses.add(klasse);
            }
        } else if (data.optBoolean(PARAM_CLASSES_SEPARATED, true) && data.optBoolean("classes_separated", true)) {
            affectedClasses = Arrays.asList(klassen.split(", "));
        } else {
            affectedClasses = new ArrayList();
            if (klassen.matches("([\\d]{1,2}[a-zA-Z]+)+")) {
                Pattern pattern = Pattern.compile("([\\d]{1,2})([a-zA-Z]+)");
                Matcher matcher = pattern.matcher(klassen);
                while (matcher.find()) {
                    String base = matcher.group(1);
                    for (char letter : matcher.group(2).toCharArray()) {
                        if (!allClasses.contains(base + letter)) continue;
                        affectedClasses.add(base + letter);
                    }
                }
            } else {
                for (String string : allClasses) {
                    StringBuilder regex = new StringBuilder();
                    for (char character : string.toCharArray()) {
                        if (character == '?') {
                            regex.append("\\?");
                        } else {
                            regex.append(character);
                        }
                        regex.append(".*");
                    }
                    if (!klassen.matches(regex.toString())) continue;
                    affectedClasses.add(string);
                }
            }
        }
        for (String string : affectedClasses) {
            if (!UntisCommonParser.isValidClass(string, data)) continue;
            v.getClasses().add(string);
        }
    }

    private void parseWithExtraLine(JSONObject data, SubstitutionScheduleDay day, List<String> columns, Element element, String className, String teacherName) {
        Element zeile = null;
        try {
            zeile = element.parent().nextElementSibling();
            if (zeile.select("td") == null) {
                zeile = zeile.nextElementSibling();
            }
            int skipLines = 0;
            while (zeile != null && !zeile.select("td").attr("class").equals("list inline_header")) {
                if (skipLines > 0) {
                    --skipLines;
                    zeile = zeile.nextElementSibling();
                    continue;
                }
                if (this.isGroupMessage(zeile)) {
                    this.addGroupMessage(day, className != null ? className : teacherName, zeile);
                    zeile = zeile.nextElementSibling();
                    continue;
                }
                Substitution v = new Substitution();
                String klassen = null;
                String course = null;
                int i = 0;
                for (Element spalte : zeile.select("td")) {
                    String text = spalte.text();
                    String type = columns.get(i);
                    if (this.isEmpty(text) && !type.equals("teacher")) {
                        ++i;
                        continue;
                    }
                    int skipLinesForThisColumn = 0;
                    Element nextLine = zeile.nextElementSibling();
                    boolean continueSkippingLines = true;
                    while (continueSkippingLines) {
                        if (nextLine != null && nextLine.children().size() == zeile.children().size()) {
                            Element columnInNextLine = nextLine.child(spalte.elementSiblingIndex().intValue());
                            if (columnInNextLine.text().replaceAll("\u00a0", "").trim().equals(nextLine.text().replaceAll("\u00a0", "").trim())) {
                                text = text + " " + columnInNextLine.text();
                                ++skipLinesForThisColumn;
                                nextLine = nextLine.nextElementSibling();
                                continue;
                            }
                            continueSkippingLines = false;
                            continue;
                        }
                        continueSkippingLines = false;
                    }
                    if (skipLinesForThisColumn > skipLines) {
                        skipLines = skipLinesForThisColumn;
                    }
                    switch (type) {
                        case "lesson": {
                            v.setLesson(text);
                            break;
                        }
                        case "subject": {
                            UntisCommonParser.handleSubject(v, spalte);
                            if (course == null) break;
                            v.setSubject((v.getSubject() != null ? v.getSubject() + " " : "") + course);
                            course = null;
                            break;
                        }
                        case "course": {
                            if (v.getSubject() != null) {
                                v.setSubject(v.getSubject() + " " + text);
                                break;
                            }
                            course = text;
                            break;
                        }
                        case "previousSubject": {
                            v.setPreviousSubject(text);
                            break;
                        }
                        case "type": {
                            v.setType(text);
                            v.setColor(this.colorProvider.getColor(text));
                            break;
                        }
                        case "type-entfall": {
                            if (text.equals("x")) {
                                v.setType("Entfall");
                                v.setColor(this.colorProvider.getColor("Entfall"));
                                break;
                            }
                            if (v.getType() != null) break;
                            v.setType("Vertretung");
                            v.setColor(this.colorProvider.getColor("Vertretung"));
                            break;
                        }
                        case "room": {
                            UntisCommonParser.handleRoom(v, spalte);
                            break;
                        }
                        case "teacher": {
                            if (text.equals("+")) {
                                v.setType("Eigenverantw. Arbeiten");
                                v.setColor(this.colorProvider.getColor(v.getType()));
                                break;
                            }
                            if (this.isEmpty(text) || teacherName != null) break;
                            UntisCommonParser.handleTeacher(v, spalte, data, false);
                            break;
                        }
                        case "previousTeacher": {
                            UntisCommonParser.handleTeacher(v, spalte, data, true);
                            break;
                        }
                        case "desc": {
                            v.setDesc(text);
                            break;
                        }
                        case "desc-type": {
                            v.setDesc(text);
                            String recognizedType = UntisCommonParser.recognizeType(text);
                            v.setType(recognizedType);
                            v.setColor(this.colorProvider.getColor(recognizedType));
                            break;
                        }
                        case "previousRoom": {
                            v.setPreviousRoom(text);
                            break;
                        }
                        case "substitutionFrom": {
                            v.setSubstitutionFrom(text);
                            break;
                        }
                        case "teacherTo": {
                            v.setTeacherTo(text);
                            break;
                        }
                        case "ignore": {
                            break;
                        }
                        case "date": {
                            break;
                        }
                        case "class": {
                            if (className != null) break;
                            klassen = this.getClassName(text, data);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown column type: " + type);
                        }
                    }
                    ++i;
                }
                if (course != null) {
                    v.setSubject(course);
                }
                this.autoDetectType(data, zeile, v);
                if (className != null) {
                    v.getClasses().add(className);
                } else if (klassen != null) {
                    UntisCommonParser.handleClasses(data, v, klassen, this.getAllClasses());
                }
                if (teacherName != null) {
                    v.setTeacher(teacherName);
                }
                if (v.getLesson() != null && !v.getLesson().equals("")) {
                    day.addSubstitution(v);
                }
                zeile = zeile.nextElementSibling();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void addGroupMessage(SubstitutionScheduleDay day, String groupName, Element zeile) {
        String message = "<b>" + groupName + ":</b> " + zeile.select("td").first().text();
        day.addMessage(message);
    }

    private boolean isGroupMessage(Element zeile) {
        return zeile.select("td").size() == 1 && zeile.select("td").first().hasAttr("colspan");
    }

    private void autoDetectType(JSONObject data, Element zeile, Substitution v) {
        if (v.getType() == null) {
            if (data.optBoolean(PARAM_TYPE_AUTO_DETECTION, true)) {
                if (zeile.select("strike").size() > 0 && UntisCommonParser.equalsOrNull(v.getSubject(), v.getPreviousSubject()) && UntisCommonParser.equalsOrNull(v.getTeacher(), v.getPreviousTeacher()) || v.getSubject() == null && (v.getRoom() == null || v.getRoom().equals(v.getPreviousRoom())) && v.getTeacher() == null && v.getPreviousSubject() != null) {
                    v.setType("Entfall");
                    v.setColor(this.colorProvider.getColor("Entfall"));
                } else {
                    v.setType("Vertretung");
                    v.setColor(this.colorProvider.getColor("Vertretung"));
                }
            } else {
                v.setType("Vertretung");
                v.setColor(this.colorProvider.getColor("Vertretung"));
            }
        }
    }

    static void handleTeacher(Substitution subst, Element cell, JSONObject data, boolean previousTeacher) {
        if ((cell = UntisCommonParser.getContentElement(cell)).select("s").size() > 0) {
            subst.setPreviousTeachers(UntisCommonParser.splitTeachers(cell.select("s").text(), data));
            if (cell.ownText().length() > 0) {
                subst.setTeachers(UntisCommonParser.splitTeachers(cell.ownText().replaceFirst("^\\?", "").replaceFirst("\u2192", ""), data));
            }
        } else if (previousTeacher) {
            subst.setPreviousTeachers(UntisCommonParser.splitTeachers(cell.text(), data));
        } else {
            subst.setTeachers(UntisCommonParser.splitTeachers(cell.text(), data));
        }
    }

    private static Set<String> splitTeachers(String s, JSONObject data) {
        HashSet<String> teachers = new HashSet<String>();
        if (data.optBoolean("splitTeachers", true)) {
            teachers.addAll(Arrays.asList(s.split(", ")));
        } else {
            teachers.add(s);
        }
        return teachers;
    }

    static void handleRoom(Substitution subst, Element cell) {
        if ((cell = UntisCommonParser.getContentElement(cell)).select("s").size() > 0) {
            subst.setPreviousRoom(cell.select("s").text());
            if (cell.ownText().length() > 0) {
                subst.setRoom(cell.ownText().replaceFirst("^\\?", "").replaceFirst("\u2192", ""));
            }
        } else {
            subst.setRoom(cell.text());
        }
    }

    private static Element getContentElement(Element cell) {
        if (cell.ownText().isEmpty() && cell.select("> span").size() == 1) {
            cell = cell.select("> span").first();
        }
        return cell;
    }

    static void handleSubject(Substitution subst, Element cell) {
        if ((cell = UntisCommonParser.getContentElement(cell)).select("s").size() > 0) {
            subst.setPreviousSubject(cell.select("s").text());
            if (cell.ownText().length() > 0) {
                subst.setSubject(cell.ownText().replaceFirst("^\\?", "").replaceFirst("\u2192", ""));
            }
        } else {
            subst.setSubject(cell.text());
        }
    }

    private boolean isEmpty(String text) {
        String trim = text.replaceAll("\u00a0", "").trim();
        return trim.equals("") || trim.equals("---") || trim.equals("+");
    }

    private void parseMessages(Element table, SubstitutionScheduleDay day) {
        Elements zeilen = table.select("tr:not(:contains(Nachrichten zum Tag))");
        for (Element i : zeilen) {
            Elements spalten = i.select("td");
            String info = "";
            for (Element b : spalten) {
                info = info + "\n" + TextNode.createFromEncoded((String)b.html(), null).getWholeText();
            }
            info = info.substring(1);
            day.addMessage(info);
        }
    }

    SubstitutionScheduleDay parseMonitorDay(Element doc, JSONObject data) throws JSONException, CredentialInvalidException, IOException {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        String date = doc.select(".mon_title").first().text().replaceAll(" \\(Seite \\d+ / \\d+\\)", "");
        day.setDateString(date);
        day.setDate(ParserUtils.parseDate(date));
        if (!this.scheduleData.getData().has(PARAM_LAST_CHANGE_SELECTOR)) {
            String lastChange = UntisCommonParser.findLastChange(doc, this.scheduleData);
            day.setLastChangeString(lastChange);
            day.setLastChange(ParserUtils.parseDateTime(lastChange));
        }
        if (doc.select("table.info").size() > 0) {
            this.parseMessages(doc.select("table.info").first(), day);
        }
        if (doc.select("table:has(tr.list)").size() > 0) {
            this.parseSubstitutionScheduleTable(doc.select("table:has(tr.list)").first(), data, day, this.getAllClasses());
        }
        return day;
    }

    private static boolean isValidClass(String klasse, JSONObject data) throws JSONException {
        return !(klasse == null || Arrays.asList(EXCLUDED_CLASS_NAMES).contains(klasse) || data.has(PARAM_EXCLUDE_CLASSES) && UntisCommonParser.contains(data.getJSONArray(PARAM_EXCLUDE_CLASSES), klasse) || data.has("exclude_classes") && UntisCommonParser.contains(data.getJSONArray("exclude_classes"), klasse));
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException, CredentialInvalidException {
        return this.getClassesFromJson();
    }

    void parseDay(SubstitutionScheduleDay day, Element next, SubstitutionSchedule v, String klasse, List<String> allClasses) throws JSONException, CredentialInvalidException, IOException {
        if (next.children().size() == 0) {
            next = next.nextElementSibling();
        }
        if (next.className().equals("subst") || next.select(".list").size() > 0 || next.text().contains("Vertretungen sind nicht freigegeben") || next.text().contains("Keine Vertretungen")) {
            if (next.text().contains("Vertretungen sind nicht freigegeben")) {
                return;
            }
            this.parseSubstitutionScheduleTable(next, this.scheduleData.getData(), day, klasse, allClasses);
        } else {
            this.parseMessages(next, day);
            next = next.nextElementSibling().nextElementSibling();
            this.parseSubstitutionScheduleTable(next, this.scheduleData.getData(), day, klasse, allClasses);
        }
        v.addDay(day);
    }

    void parseMultipleMonitorDays(SubstitutionSchedule v, Document doc, JSONObject data) throws JSONException, CredentialInvalidException, IOException {
        if (doc.select(".mon_head").size() > 1) {
            for (int j = 0; j < doc.select(".mon_head").size(); ++j) {
                Document doc2 = Document.createShell((String)doc.baseUri());
                doc2.body().appendChild((Node)((Element)doc.select(".mon_head").get(j)).clone());
                Element next = ((Element)doc.select(".mon_head").get(j)).nextElementSibling();
                if (next != null && next.tagName().equals("center")) {
                    doc2.body().appendChild((Node)next.select(".mon_title").first().clone());
                    if (next.select("table:has(tr.list)").size() > 0) {
                        doc2.body().appendChild((Node)next.select("table:has(tr.list)").first());
                    }
                    if (next.select("table.info").size() > 0) {
                        doc2.body().appendChild((Node)next.select("table.info").first());
                    }
                } else {
                    if (doc.select(".mon_title").size() - 1 < j) continue;
                    doc2.body().appendChild((Node)((Element)doc.select(".mon_title").get(j)).clone());
                    doc2.body().appendChild((Node)((Element)doc.select("table:has(tr.list)").get(j)).clone());
                }
                SubstitutionScheduleDay day = this.parseMonitorDay((Element)doc2, data);
                v.addDay(day);
            }
        } else if (doc.select(".mon_title").size() > 1) {
            for (int j = 0; j < doc.select(".mon_title").size(); ++j) {
                Document doc2 = Document.createShell((String)doc.baseUri());
                doc2.body().appendChild((Node)((Element)doc.select(".mon_title").get(j)).clone());
                Element next = ((Element)doc.select(".mon_title").get(j)).nextElementSibling();
                while (next != null && !next.tagName().equals("center")) {
                    doc2.body().appendChild((Node)next);
                    next = ((Element)doc.select(".mon_title").get(j)).nextElementSibling();
                }
                SubstitutionScheduleDay day = this.parseMonitorDay((Element)doc2, data);
                v.addDay(day);
            }
        } else {
            SubstitutionScheduleDay day = this.parseMonitorDay((Element)doc, data);
            v.addDay(day);
        }
    }

    protected void parseSubstitutionTable(SubstitutionSchedule v, String lastChange, Document doc) throws CredentialInvalidException, IOException, JSONException {
        this.parseSubstitutionTable(v, lastChange, doc, null);
    }

    protected void parseSubstitutionTable(SubstitutionSchedule v, String lastChange, Document doc, String className) throws JSONException, CredentialInvalidException, IOException {
        Element table;
        JSONObject data = this.scheduleData.getData();
        LocalDateTime lastChangeDate = ParserUtils.parseDateTime(lastChange);
        Pattern dayPattern = Pattern.compile("\\d\\d?.\\d\\d?. / \\w+");
        int dateColumn = -1;
        JSONArray columns = data.getJSONArray(PARAM_COLUMNS);
        for (int i = 0; i < columns.length(); ++i) {
            if (!columns.getString(i).equals("date")) continue;
            dateColumn = i;
            break;
        }
        if ((table = doc.select("table[rules=all], table:has(tr:has(td[align=center]))").first()) == null || table.text().replace("\u00a0", "").trim().equals("Keine Vertretungen")) {
            return;
        }
        if (dateColumn == -1) {
            SubstitutionScheduleDay day = new SubstitutionScheduleDay();
            day.setLastChangeString(lastChange);
            day.setLastChange(lastChangeDate);
            String title = doc.select("font[size=5], font[size=4], font[size=3] b").text();
            Matcher matcher = dayPattern.matcher(title);
            if (matcher.find()) {
                String date = matcher.group();
                day.setDateString(date);
                day.setDate(ParserUtils.parseDate(date));
            }
            this.parseSubstitutionScheduleTable(table, data, day, className, this.getAllClasses(), true);
            v.addDay(day);
        } else {
            for (Element line : table.select("tr.list.odd:not(:has(td.inline_header)), tr.list.even:not(:has(td.inline_header)), tr:has(td[align=center]):gt(0)")) {
                SubstitutionScheduleDay day = null;
                String date = ((Element)line.select("td").get(dateColumn)).text().replace("\u00a0", "").trim();
                if (date.isEmpty()) continue;
                if (date.indexOf("-") > 0) {
                    date = date.substring(0, date.indexOf("-") - 1).trim();
                }
                LocalDate parsedDate = ParserUtils.parseDate(date);
                for (SubstitutionScheduleDay search : v.getDays()) {
                    if (!Objects.equals(search.getDate(), parsedDate) && !Objects.equals(search.getDateString(), date)) continue;
                    day = search;
                    break;
                }
                if (day == null) {
                    day = new SubstitutionScheduleDay();
                    day.setDateString(date);
                    day.setDate(parsedDate);
                    day.setLastChangeString(lastChange);
                    day.setLastChange(lastChangeDate);
                    v.addDay(day);
                }
                this.parseSubstitutionScheduleTable(line, data, day, className, this.getAllClasses(), true);
            }
        }
    }
}

