/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.jetbrains.annotations.NotNull;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class TurboVertretungParser
extends BaseParser {
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_ENCODING = "encoding";
    private JSONObject data;

    public TurboVertretungParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        JSONArray urls = this.data.getJSONArray(PARAM_URLS);
        String encoding = this.data.optString(PARAM_ENCODING, null);
        ArrayList<Document> docs = new ArrayList<Document>();
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        for (int i = 0; i < urls.length(); ++i) {
            String url = urls.get(i) instanceof JSONObject ? urls.getJSONObject(i).getString("url") : urls.getString(i);
            this.loadUrl(url, encoding, docs);
        }
        for (Document doc : docs) {
            String html = doc.body().html();
            String[] parts = html.split("<p class=\"Titel\">");
            for (int i = 1; i < parts.length; ++i) {
                Document partDoc = Jsoup.parse((String)("<p class=\"Titel\">" + parts[i]));
                this.parseTurboVertretungDay(v, partDoc);
            }
        }
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    private void parseTurboVertretungDay(SubstitutionSchedule v, Document doc) {
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        String date = doc.select(".Titel").text().replaceFirst("Vertretungsplan( f\u00fcr)? ", "");
        day.setDate(DateTimeFormat.forPattern((String)"EEEE, d. MMMM yyyy").withLocale(Locale.GERMAN).parseLocalDate(date));
        String lastChange = doc.select(".Stand").text();
        day.setLastChange(ParserUtils.parseDateTime(lastChange));
        if (doc.text().contains("Kein Vertretungsplan")) {
            v.addDay(day);
            return;
        }
        if (doc.select(".LehrerFrueher").size() > 0) {
            day.addMessage(doc.select(".LehrerFrueherLabel").text() + "\n" + doc.select(".LehrerFrueher").text());
        }
        if (doc.select(".LehrerVerplant").size() > 0) {
            day.addMessage(doc.select(".LehrerVerplantLabel").text() + "\n" + doc.select(".LehrerVerplant").text());
        }
        if (doc.select(".Abwesenheiten-Klassen").size() > 0) {
            day.addMessage(doc.select(".Abwesenheiten-KlassenLabel").text() + "\n" + doc.select(".Abwesenheiten-Klassen").text());
        }
        if (doc.select(".Abwesenheiten").size() > 0) {
            day.addMessage(doc.select(".AbwesenheitenLabel").text() + "\n" + doc.select(".Abwesenheiten").text());
        }
        Element table = doc.select("table").first();
        for (Element row : table.select("tr:has(td)")) {
            if (row.select(".Klasseleer").size() > 0) continue;
            Substitution substitution = new Substitution();
            substitution.setLesson(row.select(this.query("Stunde")).text());
            substitution.setPreviousTeacher(row.select(this.query("Lehrer")).text());
            substitution.setTeacher(row.select(this.query("Vertretung")).text());
            substitution.setClasses(new HashSet<String>(Arrays.asList(row.select(this.query("Klasse")).text().split(" "))));
            substitution.setSubject(row.select(this.query("Fach")).text());
            substitution.setDesc(row.select(this.query("Anmerkung")).text());
            substitution.setRoom(row.select(this.query("Raum")).text());
            String type = TurboVertretungParser.recognizeType(row.select(this.query("Anmerkung")).text());
            if (type == null) {
                type = "Vertretung";
            }
            substitution.setType(type);
            substitution.setColor(this.colorProvider.getColor(type));
            day.addSubstitution(substitution);
        }
        v.addDay(day);
    }

    @NotNull
    private String query(String css) {
        return "." + css + ", ." + css + "Neu";
    }

    private void loadUrl(String url, String encoding, List<Document> docs) throws IOException, CredentialInvalidException {
        String html = this.httpGet(url, encoding).replace("&nbsp;", "");
        Document doc = Jsoup.parse((String)html);
        docs.add(doc);
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() {
        return null;
    }
}

