/*
 * Decompiled with CFR 0.152.
 */
package me.vertretungsplan.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vertretungsplan.exception.CredentialInvalidException;
import me.vertretungsplan.objects.Substitution;
import me.vertretungsplan.objects.SubstitutionSchedule;
import me.vertretungsplan.objects.SubstitutionScheduleData;
import me.vertretungsplan.objects.SubstitutionScheduleDay;
import me.vertretungsplan.parser.BaseParser;
import me.vertretungsplan.parser.CookieProvider;
import me.vertretungsplan.parser.LoginHandler;
import me.vertretungsplan.parser.ParserUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.joda.time.format.DateTimeFormat;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class IndiwareParser
extends BaseParser {
    private static final String PARAM_URLS = "urls";
    private static final String PARAM_ENCODING = "encoding";
    private static final String PARAM_EMBEDDED_CONTENT_SELECTOR = "embeddedContentSelector";
    private static final String PARAM_SPLIT_TEACHERS = "splitTeachers";
    protected JSONObject data;
    private static final int MAX_DAYS = 7;
    static final Pattern datePattern = Pattern.compile("\\w+, \\d\\d?\\. \\w+ \\d{4}", 256);
    static final Pattern lastChangePattern = Pattern.compile("\\d\\d?\\.\\d\\d?\\.\\d{4}, \\d\\d?\\:\\d\\d");
    static final Pattern substitutionPattern = Pattern.compile("f\u00fcr ([^\\s]+) ((?:(?! ,|Frau|Herr).)+|(?:Herr|Frau) [^\\s]+) ?,? ?(.*)");
    static final Pattern cancelPattern = Pattern.compile("((?!verlegt|statt)[^\\s]+) (?:(.+) )?f\u00e4llt (:?leider )?aus");
    static final Pattern delayPattern = Pattern.compile("([^\\s]+) (.+) (verlegt nach .*)");
    static final Pattern selfPattern = Pattern.compile("selbst\\. ?,? ?(.*)");
    static final Pattern coursePattern = Pattern.compile("(.*)/ (.*)");
    static final Pattern bracesPattern = Pattern.compile("^\\((.*)\\)$");
    static final Pattern takeOverPattern = Pattern.compile("((?:(?! ,|Frau|Herr).)+|(?:Herr|Frau) [^\\s]+) \u00fcbernimmt mit");
    static final Pattern newPattern = Pattern.compile("^neu(?:, )?(.*)$");
    static final Pattern examPattern = Pattern.compile("^Pr\u00fcfung(?:; )?(.*)$");

    public IndiwareParser(SubstitutionScheduleData scheduleData, CookieProvider cookieProvider) {
        super(scheduleData, cookieProvider);
        this.data = scheduleData.getData();
    }

    @Override
    public SubstitutionSchedule getSubstitutionSchedule() throws IOException, JSONException, CredentialInvalidException {
        new LoginHandler(this.scheduleData, this.credential, this.cookieProvider).handleLogin(this.executor, this.cookieStore);
        JSONArray urls = this.data.getJSONArray(PARAM_URLS);
        String encoding = this.data.optString(PARAM_ENCODING, null);
        ArrayList<String> docs = new ArrayList<String>();
        SubstitutionSchedule v = SubstitutionSchedule.fromData(this.scheduleData);
        int successfulSchedules = 0;
        IOException lastException = null;
        for (int i = 0; i < urls.length(); ++i) {
            if (urls.optJSONObject(i) != null) {
                try {
                    JSONObject obj = urls.getJSONObject(i);
                    String url = obj.getString("url");
                    if (!obj.has("postData")) continue;
                    JSONObject postParams = obj.getJSONObject("postData");
                    ArrayList<NameValuePair> nvps = new ArrayList<NameValuePair>();
                    for (String name : JSONObject.getNames((JSONObject)postParams)) {
                        String value = postParams.getString(name);
                        nvps.add((NameValuePair)new BasicNameValuePair(name, value));
                    }
                    docs.add(this.httpPost(url, encoding, nvps));
                    ++successfulSchedules;
                }
                catch (IOException e) {
                    lastException = e;
                }
                continue;
            }
            for (String url : ParserUtils.handleUrl(urls.getString(i))) {
                try {
                    docs.add(this.httpGet(url, encoding));
                    ++successfulSchedules;
                }
                catch (IOException e) {
                    lastException = e;
                }
            }
        }
        if (successfulSchedules == 0 && lastException != null) {
            throw lastException;
        }
        successfulSchedules = 0;
        lastException = null;
        for (String response : docs) {
            try {
                this.parseIndiwarePage(v, response);
                ++successfulSchedules;
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (successfulSchedules == 0 && lastException != null) {
            throw lastException;
        }
        v.setWebsite(urls.optString(0, this.data.optString("website", null)));
        v.setClasses(this.getAllClasses());
        v.setTeachers(this.getAllTeachers());
        return v;
    }

    void parseIndiwarePage(SubstitutionSchedule v, String response) throws JSONException, IOException {
        Document doc;
        boolean html;
        if (response.contains("<html") || response.contains("<table")) {
            html = true;
            doc = Jsoup.parse((String)response);
        } else {
            html = false;
            doc = Jsoup.parse((String)response, (String)"", (Parser)Parser.xmlParser());
        }
        if (html && this.data.has(PARAM_EMBEDDED_CONTENT_SELECTOR)) {
            String selector = this.data.getString(PARAM_EMBEDDED_CONTENT_SELECTOR);
            Elements elems = doc.select(selector);
            if (elems.size() == 0) {
                throw new IOException("No elements found using " + selector);
            }
            for (Element elem : elems) {
                v.addDay(this.parseIndiwareDay(elem, true));
            }
        } else if (html && doc.select(".vpfuer").size() > 1) {
            String[] htmls = doc.html().split("<span class=\"vpfuer\">");
            for (int i = 1; i < htmls.length; ++i) {
                Document splitDoc = Jsoup.parse((String)htmls[i]);
                v.addDay(this.parseIndiwareDay((Element)splitDoc, true));
            }
        } else if (!html && doc.select("kopf").size() > 1) {
            String[] xmls = doc.html().split("<kopf>");
            for (int i = 1; i < xmls.length; ++i) {
                String xml = "<vp><kopf>" + xmls[i];
                if (i < xmls.length - 1) {
                    xml = xml + "</vp>";
                }
                Document splitDoc = Jsoup.parse((String)xml);
                v.addDay(this.parseIndiwareDay((Element)splitDoc, false));
            }
        } else {
            v.addDay(this.parseIndiwareDay((Element)doc, html));
        }
    }

    SubstitutionScheduleDay parseIndiwareDay(Element doc, boolean html) throws IOException, JSONException {
        StringBuilder message;
        SubstitutionScheduleDay day = new SubstitutionScheduleDay();
        DataSource ds = html ? new HTMLDataSource(doc) : new XMLDataSource(doc);
        Matcher matcher = datePattern.matcher(ds.titel().text());
        if (!matcher.find()) {
            throw new IOException("malformed date: " + ds.titel().text());
        }
        String date = matcher.group();
        day.setDate(DateTimeFormat.forPattern((String)"EEEE, dd. MMMM yyyy").withLocale(Locale.GERMAN).parseLocalDate(date));
        matcher = lastChangePattern.matcher(ds.datum().text());
        if (!matcher.find()) {
            throw new IOException("malformed date: " + ds.datum().text());
        }
        String lastChange = matcher.group();
        day.setLastChange(DateTimeFormat.forPattern((String)"dd.MM.yyyy, HH:mm").withLocale(Locale.GERMAN).parseLocalDateTime(lastChange));
        if (ds.kopfinfos().size() > 0) {
            for (Element kopfinfo : ds.kopfinfos()) {
                String title = html ? kopfinfo.select("th").text() : IndiwareParser.kopfinfoTitle(kopfinfo.tagName()) + ":";
                StringBuilder message2 = new StringBuilder();
                if (title != null && !title.isEmpty()) {
                    message2.append("<b>").append(title).append("</b>").append(" ");
                }
                message2.append(html ? kopfinfo.select("td").text() : kopfinfo.text());
                day.addMessage(message2.toString());
            }
        }
        if (ds.fuss() != null) {
            message = new StringBuilder();
            boolean first = true;
            for (Element fusszeile : ds.fusszeilen()) {
                if (first) {
                    first = false;
                } else {
                    message.append("<br>\n");
                }
                message.append(fusszeile.text());
            }
            day.addMessage(message.toString());
        }
        if (ds.aufsichten() != null) {
            message = new StringBuilder();
            message.append("<b>").append("Ge\u00e4nderte Aufsichten:").append("</b>");
            for (Element aufsicht : ds.aufsichtzeilen()) {
                message.append("<br>\n");
                message.append(aufsicht.text());
            }
            day.addMessage(message.toString());
        }
        ArrayList<String> columnTypes = null;
        if (html) {
            columnTypes = new ArrayList<String>();
            block25: for (Element th : ((HTMLDataSource)ds).headers()) {
                Set classNames = th.classNames();
                for (String className : classNames) {
                    if (!className.contains("thplan") && !className.contains("thlplan")) continue;
                    columnTypes.add(className.replace("thplan", "").replace("thlplan", "").replace("_scheuler", ""));
                    continue block25;
                }
            }
        }
        for (Element aktion : ds.aktionen()) {
            Substitution substitution = new Substitution();
            String course = null;
            int i = 0;
            boolean splitTeachers = this.data.optBoolean(PARAM_SPLIT_TEACHERS, true);
            for (Element info : aktion.children()) {
                String value = info.text().replace("\u00a0", "");
                if (value.equals("---")) {
                    ++i;
                    continue;
                }
                String columnType = html ? (String)columnTypes.get(i) : info.tagName();
                Matcher bracesMatcher = bracesPattern.matcher(value);
                switch (columnType) {
                    case "klasse": {
                        ClassAndCourse cac = new ClassAndCourse(value, this.data);
                        course = cac.course;
                        substitution.setClasses(cac.classes);
                        break;
                    }
                    case "stunde": {
                        substitution.setLesson(value);
                        break;
                    }
                    case "fach": {
                        String subject = this.subjectAndCourse(course, value);
                        if (html ? columnTypes.contains("vfach") : aktion.getElementsByTag("vfach").size() > 0) {
                            substitution.setPreviousSubject(subject);
                            break;
                        }
                        substitution.setSubject(subject);
                        break;
                    }
                    case "vfach": {
                        substitution.setSubject(this.subjectAndCourse(course, value));
                        break;
                    }
                    case "lehrer": {
                        if (bracesMatcher.matches()) {
                            value = bracesMatcher.group(1);
                            substitution.setPreviousTeachers(IndiwareParser.splitTeachers(value, splitTeachers));
                            break;
                        }
                        if (html ? columnTypes.contains("vlehrer") : aktion.getElementsByTag("vlehrer").size() > 0) {
                            substitution.setPreviousTeachers(IndiwareParser.splitTeachers(value, splitTeachers));
                            break;
                        }
                        substitution.setTeachers(IndiwareParser.splitTeachers(value, splitTeachers));
                        break;
                    }
                    case "vlehrer": {
                        if (bracesMatcher.matches()) {
                            value = bracesMatcher.group(1);
                            substitution.setPreviousTeachers(IndiwareParser.splitTeachers(value, splitTeachers));
                            break;
                        }
                        substitution.setTeachers(IndiwareParser.splitTeachers(value, splitTeachers));
                        break;
                    }
                    case "raum": {
                        if (columnTypes != null && columnTypes.contains("vraum")) {
                            substitution.setPreviousRoom(value);
                            break;
                        }
                        substitution.setRoom(value);
                        break;
                    }
                    case "vraum": {
                        substitution.setRoom(value);
                    }
                    case "info": {
                        IndiwareParser.handleDescription(substitution, value);
                    }
                }
                ++i;
            }
            if (substitution.getType() == null) {
                substitution.setType("Vertretung");
            }
            substitution.setColor(this.colorProvider.getColor(substitution.getType()));
            if (course != null && substitution.getSubject() == null) {
                substitution.setSubject(course);
            }
            day.addSubstitution(substitution);
        }
        return day;
    }

    @NotNull
    static HashSet<String> splitTeachers(String value, boolean split) {
        if (split) {
            return new HashSet<String>(Arrays.asList(value.split(", ")));
        }
        return new HashSet<String>(Collections.singletonList(value));
    }

    static void handleDescription(Substitution substitution, String value) {
        IndiwareParser.handleDescription(substitution, value, false);
    }

    static void handleDescription(Substitution substitution, String value, boolean teacher) {
        Matcher takeOverMatcher;
        if (value == null) {
            return;
        }
        Matcher newMatcher = newPattern.matcher(value);
        if (newMatcher.matches()) {
            value = newMatcher.group(1);
        }
        Matcher examMatcher = examPattern.matcher(value);
        Matcher substitutionMatcher = substitutionPattern.matcher(value);
        Matcher cancelMatcher = cancelPattern.matcher(value);
        Matcher delayMatcher = delayPattern.matcher(value);
        Matcher selfMatcher = selfPattern.matcher(value);
        if (examMatcher.matches()) {
            substitution.setType("Pr\u00fcfung");
            substitution.setDesc(examMatcher.group(1));
        } else if (substitutionMatcher.matches()) {
            substitution.setPreviousSubject(substitutionMatcher.group(1));
            substitution.setPreviousTeacher(substitutionMatcher.group(2));
            if (!substitutionMatcher.group(3).isEmpty()) {
                substitution.setDesc(substitutionMatcher.group(3));
            }
        } else if (cancelMatcher.matches()) {
            substitution.setType("Entfall");
            substitution.setPreviousSubject(cancelMatcher.group(1));
            if (cancelMatcher.groupCount() > 1) {
                if (teacher) {
                    substitution.setClasses(Collections.singleton(cancelMatcher.group(2)));
                } else {
                    substitution.setPreviousTeacher(cancelMatcher.group(2));
                }
            }
        } else if (delayMatcher.matches()) {
            substitution.setType("Verlegung");
            substitution.setPreviousSubject(delayMatcher.group(1));
            substitution.setPreviousTeacher(delayMatcher.group(2));
            substitution.setDesc(delayMatcher.group(3));
        } else if (selfMatcher.matches()) {
            substitution.setType("selbst.");
            if (!selfMatcher.group(1).isEmpty()) {
                substitution.setDesc(selfMatcher.group(1));
            }
        } else if (value.equals("f\u00e4llt aus") || value.equals("Klausur") || value.equals("Aufg.")) {
            substitution.setType(value);
        } else {
            substitution.setDesc(value);
        }
        if (substitution.getDesc() != null && (takeOverMatcher = takeOverPattern.matcher(substitution.getDesc())).find()) {
            substitution.setTeacher(takeOverMatcher.group(1));
        }
    }

    @NotNull
    private String subjectAndCourse(String course, String subject) {
        StringBuilder subjectBuilder = new StringBuilder();
        subjectBuilder.append(subject);
        if (course != null) {
            subjectBuilder.append(" ").append(course);
        }
        return subjectBuilder.toString();
    }

    private static String kopfinfoTitle(String type) {
        switch (type) {
            case "abwesendl": {
                return "Abwesende Lehrer";
            }
            case "abwesendk": {
                return "Abwesende Klassen";
            }
            case "abwesendr": {
                return "Nicht verf\u00fcgbare R\u00e4ume";
            }
            case "aenderungl": {
                return "Lehrer mit \u00c4nderung";
            }
            case "aenderungk": {
                return "Klassen mit \u00c4nderung";
            }
        }
        return null;
    }

    @Override
    public List<String> getAllClasses() throws IOException, JSONException {
        return this.getClassesFromJson();
    }

    @Override
    public List<String> getAllTeachers() throws IOException, JSONException {
        return null;
    }

    static class ClassAndCourse {
        public String course = null;
        public Set<String> classes;

        public ClassAndCourse(String value, JSONObject data) throws JSONException {
            String classesString;
            Matcher courseMatcher = coursePattern.matcher(value);
            if (courseMatcher.matches()) {
                classesString = courseMatcher.group(1);
                this.course = courseMatcher.group(2);
            } else {
                classesString = value;
            }
            this.classes = new HashSet<String>(Arrays.asList(classesString.split(",")));
            this.classes = BaseParser.handleClassRanges(this.classes, data);
        }
    }

    private class HTMLDataSource
    implements DataSource {
        private Element doc;

        public HTMLDataSource(Element doc) {
            this.doc = doc;
        }

        @Override
        public Element titel() {
            return this.doc.select(".vpfuerdatum").first();
        }

        @Override
        public Element datum() {
            return this.doc.select(".vpdatum").first();
        }

        @Override
        public Elements kopfinfos() {
            return this.doc.select("table:has(th[class^=thkopf]) tr");
        }

        @Override
        public Element fuss() {
            return this.doc.select("table:not(:has(th[class^=thkopf])):not(:has(.tdaktionen)):not(span:contains(Aufsichten) + table)").first();
        }

        @Override
        public Elements fusszeilen() {
            return this.fuss().select("tr td");
        }

        @Override
        public Element aufsichten() {
            return this.doc.select("span:contains(Aufsichten) + table").first();
        }

        @Override
        public Elements aufsichtzeilen() {
            return this.aufsichten().select("tr td");
        }

        @Override
        public Elements aktionen() {
            return this.doc.select("table:has(.tdaktionen) tr:gt(0)");
        }

        public Elements headers() {
            return this.doc.select("table:has(.tdaktionen) th");
        }
    }

    private class XMLDataSource
    implements DataSource {
        private Element vp;
        private Element kopf;

        public XMLDataSource(Element doc) {
            this.vp = doc.select("vp").first();
            this.kopf = this.vp.select("kopf").first();
        }

        @Override
        public Element titel() {
            return this.kopf.select("titel").first();
        }

        @Override
        public Element datum() {
            return this.kopf.select("datum").first();
        }

        @Override
        public Elements kopfinfos() {
            return this.kopf.select("kopfinfo > *");
        }

        @Override
        public Element fuss() {
            return this.vp.select("fuss").first();
        }

        @Override
        public Elements fusszeilen() {
            return this.fuss().select("fusszeile fussinfo");
        }

        @Override
        public Element aufsichten() {
            return this.vp.select("aufsichten").first();
        }

        @Override
        public Elements aufsichtzeilen() {
            return this.aufsichten().select("aufsichtzeile aufsichtinfo");
        }

        @Override
        public Elements aktionen() {
            return this.vp.select("haupt > aktion");
        }
    }

    private static interface DataSource {
        public Element titel();

        public Element datum();

        public Elements kopfinfos();

        public Element fuss();

        public Elements fusszeilen();

        public Element aufsichten();

        public Elements aufsichtzeilen();

        public Elements aktionen();
    }
}

